/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.encoding;

import io.camunda.zeebe.protocol.record.AdminRequestDecoder;
import io.camunda.zeebe.protocol.record.AdminRequestEncoder;
import io.camunda.zeebe.protocol.record.AdminRequestType;
import io.camunda.zeebe.protocol.record.MessageHeaderDecoder;
import io.camunda.zeebe.protocol.record.MessageHeaderEncoder;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.camunda.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class AdminRequest
implements BufferReader,
BufferWriter {
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final AdminRequestEncoder bodyEncoder = new AdminRequestEncoder();
    private final AdminRequestDecoder bodyDecoder = new AdminRequestDecoder();
    private int partitionId;
    private AdminRequestType type;

    public AdminRequest reset() {
        this.partitionId = AdminRequestEncoder.partitionIdNullValue();
        this.type = AdminRequestType.NULL_VAL;
        return this;
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.bodyDecoder.wrapAndApplyHeader(buffer, offset, this.headerDecoder);
        this.partitionId = this.bodyDecoder.partitionId();
        this.type = this.bodyDecoder.type();
    }

    public int getLength() {
        return this.headerEncoder.encodedLength() + this.bodyEncoder.sbeBlockLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.bodyEncoder.wrapAndApplyHeader(buffer, offset, this.headerEncoder).partitionId(this.partitionId).type(this.type);
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(int partitionId) {
        this.partitionId = partitionId;
    }

    public AdminRequestType getType() {
        return this.type;
    }

    public void setType(AdminRequestType type) {
        this.type = type;
    }
}

