/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.deployment;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.BinaryProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessMetadata;
import io.camunda.zeebe.protocol.record.value.deployment.Process;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class ProcessRecord
extends UnifiedRecordValue
implements Process {
    private final StringProperty bpmnProcessIdProp = new StringProperty("bpmnProcessId");
    private final IntegerProperty versionProp = new IntegerProperty("version");
    private final LongProperty keyProp = new LongProperty("processDefinitionKey");
    private final StringProperty resourceNameProp = new StringProperty("resourceName");
    private final BinaryProperty checksumProp = new BinaryProperty("checksum", (DirectBuffer)new UnsafeBuffer());
    private final BinaryProperty resourceProp = new BinaryProperty("resource", (DirectBuffer)new UnsafeBuffer());
    private final StringProperty tenantIdProp = new StringProperty("tenantId", "<default>");

    public ProcessRecord() {
        this.declareProperty((BaseProperty)this.bpmnProcessIdProp).declareProperty((BaseProperty)this.versionProp).declareProperty((BaseProperty)this.keyProp).declareProperty((BaseProperty)this.resourceNameProp).declareProperty((BaseProperty)this.checksumProp).declareProperty((BaseProperty)this.resourceProp).declareProperty((BaseProperty)this.tenantIdProp);
    }

    public ProcessRecord wrap(ProcessMetadata metadata, byte[] resource) {
        this.bpmnProcessIdProp.setValue(metadata.getBpmnProcessIdBuffer());
        this.versionProp.setValue(metadata.getVersion());
        this.checksumProp.setValue(metadata.getChecksumBuffer());
        this.keyProp.setValue(metadata.getKey());
        this.resourceNameProp.setValue(metadata.getResourceNameBuffer());
        this.resourceProp.setValue((DirectBuffer)BufferUtil.wrapArray((byte[])resource));
        this.tenantIdProp.setValue(metadata.getTenantId());
        return this;
    }

    public String getBpmnProcessId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.bpmnProcessIdProp.getValue());
    }

    public int getVersion() {
        return this.versionProp.getValue();
    }

    public long getProcessDefinitionKey() {
        return this.getKey();
    }

    public String getResourceName() {
        return BufferUtil.bufferAsString((DirectBuffer)this.resourceNameProp.getValue());
    }

    public byte[] getChecksum() {
        return BufferUtil.bufferAsArray((DirectBuffer)this.checksumProp.getValue());
    }

    public boolean isDuplicate() {
        return false;
    }

    public ProcessRecord setChecksum(DirectBuffer checksumBuffer) {
        this.checksumProp.setValue(checksumBuffer);
        return this;
    }

    public ProcessRecord setResourceName(String resourceName) {
        this.resourceNameProp.setValue(resourceName);
        return this;
    }

    public ProcessRecord setResourceName(DirectBuffer resourceName) {
        this.resourceNameProp.setValue(resourceName);
        return this;
    }

    public ProcessRecord setVersion(int version) {
        this.versionProp.setValue(version);
        return this;
    }

    public ProcessRecord setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    public ProcessRecord setBpmnProcessId(DirectBuffer bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getChecksumBuffer() {
        return this.checksumProp.getValue();
    }

    public byte[] getResource() {
        return BufferUtil.bufferAsArray((DirectBuffer)this.resourceProp.getValue());
    }

    public ProcessRecord setResource(DirectBuffer resource) {
        return this.setResource(resource, 0, resource.capacity());
    }

    @JsonIgnore
    public long getKey() {
        return this.keyProp.getValue();
    }

    public ProcessRecord setKey(long key) {
        this.keyProp.setValue(key);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getBpmnProcessIdBuffer() {
        return this.bpmnProcessIdProp.getValue();
    }

    @Override
    @JsonIgnore
    public int getLength() {
        return super.getLength();
    }

    @Override
    @JsonIgnore
    public int getEncodedLength() {
        return super.getEncodedLength();
    }

    @JsonIgnore
    public DirectBuffer getResourceNameBuffer() {
        return this.resourceNameProp.getValue();
    }

    public ProcessRecord setBpmnProcessId(DirectBuffer bpmnProcessId, int offset, int length) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId, offset, length);
        return this;
    }

    public ProcessRecord setResource(DirectBuffer resource, int offset, int length) {
        this.resourceProp.setValue(resource, offset, length);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getResourceBuffer() {
        return this.resourceProp.getValue();
    }

    public String getTenantId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.tenantIdProp.getValue());
    }

    public ProcessRecord setTenantId(String tenantId) {
        this.tenantIdProp.setValue(tenantId);
        return this;
    }
}

