/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.signal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.value.SignalSubscriptionRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class SignalSubscriptionRecord
extends UnifiedRecordValue
implements SignalSubscriptionRecordValue {
    private final LongProperty processDefinitionKeyProp = new LongProperty("processDefinitionKey", -1L);
    private final StringProperty bpmnProcessIdProp = new StringProperty("bpmnProcessId", "");
    private final StringProperty signalNameProp = new StringProperty("signalName", "");
    private final StringProperty catchEventIdProp = new StringProperty("catchEventId", "");
    private final LongProperty catchEventInstanceKeyProp = new LongProperty("catchEventInstanceKey", -1L);

    public SignalSubscriptionRecord() {
        this.declareProperty((BaseProperty)this.processDefinitionKeyProp).declareProperty((BaseProperty)this.signalNameProp).declareProperty((BaseProperty)this.catchEventIdProp).declareProperty((BaseProperty)this.bpmnProcessIdProp).declareProperty((BaseProperty)this.catchEventInstanceKeyProp);
    }

    public void wrap(SignalSubscriptionRecord record) {
        this.processDefinitionKeyProp.setValue(record.getProcessDefinitionKey());
        this.bpmnProcessIdProp.setValue(record.getBpmnProcessIdBuffer());
        this.signalNameProp.setValue(record.getSignalNameBuffer());
        this.catchEventIdProp.setValue(record.getCatchEventId());
        this.catchEventInstanceKeyProp.setValue(record.getCatchEventInstanceKey());
    }

    @JsonIgnore
    public DirectBuffer getSignalNameBuffer() {
        return this.signalNameProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getCatchEventIdBuffer() {
        return this.catchEventIdProp.getValue();
    }

    public long getProcessDefinitionKey() {
        return this.processDefinitionKeyProp.getValue();
    }

    public String getBpmnProcessId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.bpmnProcessIdProp.getValue());
    }

    public String getCatchEventId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.catchEventIdProp.getValue());
    }

    public long getCatchEventInstanceKey() {
        return this.catchEventInstanceKeyProp.getValue();
    }

    public String getSignalName() {
        return BufferUtil.bufferAsString((DirectBuffer)this.signalNameProp.getValue());
    }

    public SignalSubscriptionRecord setSignalName(DirectBuffer signalName) {
        this.signalNameProp.setValue(signalName);
        return this;
    }

    public SignalSubscriptionRecord setCatchEventInstanceKey(long catchEventInstanceKey) {
        this.catchEventInstanceKeyProp.setValue(catchEventInstanceKey);
        return this;
    }

    public SignalSubscriptionRecord setCatchEventId(DirectBuffer catchEventId) {
        this.catchEventIdProp.setValue(catchEventId);
        return this;
    }

    public SignalSubscriptionRecord setBpmnProcessId(DirectBuffer bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    public SignalSubscriptionRecord setProcessDefinitionKey(long key) {
        this.processDefinitionKeyProp.setValue(key);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getBpmnProcessIdBuffer() {
        return this.bpmnProcessIdProp.getValue();
    }

    @JsonIgnore
    public long getSubscriptionKey() {
        long catchEventInstanceKey = this.catchEventInstanceKeyProp.getValue();
        return catchEventInstanceKey > -1L ? catchEventInstanceKey : this.processDefinitionKeyProp.getValue();
    }

    public String getTenantId() {
        return "<default>";
    }
}

