/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.encoding;

import io.camunda.zeebe.protocol.impl.Loggers;
import io.camunda.zeebe.protocol.record.BrokerInfoDecoder;
import io.camunda.zeebe.protocol.record.BrokerInfoEncoder;
import io.camunda.zeebe.protocol.record.MessageHeaderDecoder;
import io.camunda.zeebe.protocol.record.MessageHeaderEncoder;
import io.camunda.zeebe.protocol.record.PartitionHealthStatus;
import io.camunda.zeebe.protocol.record.PartitionRole;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.IntConsumer;
import java.util.function.ObjLongConsumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;

public final class BrokerInfo
implements BufferReader,
BufferWriter {
    private static final String BROKER_INFO_PROPERTY_NAME = "brokerInfo";
    private static final DirectBuffer COMMAND_API_NAME = BufferUtil.wrapString((String)"commandApi");
    private static final Logger LOG = Loggers.PROTOCOL_LOGGER;
    private static final Base64.Encoder BASE_64_ENCODER = Base64.getEncoder();
    private static final Base64.Decoder BASE_64_DECODER = Base64.getDecoder();
    private static final Charset BASE_64_CHARSET = StandardCharsets.UTF_8;
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final BrokerInfoEncoder bodyEncoder = new BrokerInfoEncoder();
    private final BrokerInfoDecoder bodyDecoder = new BrokerInfoDecoder();
    private final Map<DirectBuffer, DirectBuffer> addresses = new HashMap<DirectBuffer, DirectBuffer>();
    private final Map<Integer, PartitionRole> partitionRoles = new HashMap<Integer, PartitionRole>();
    private final Map<Integer, Long> partitionLeaderTerms = new HashMap<Integer, Long>();
    private final Map<Integer, PartitionHealthStatus> partitionHealthStatuses = new HashMap<Integer, PartitionHealthStatus>();
    private int nodeId;
    private int partitionsCount;
    private int clusterSize;
    private int replicationFactor;
    private DirectBuffer version = new UnsafeBuffer();

    public BrokerInfo() {
        this.reset();
    }

    public BrokerInfo(int nodeId, String commandApiAddress) {
        this.reset();
        this.nodeId = nodeId;
        this.setCommandApiAddress(BufferUtil.wrapString((String)commandApiAddress));
    }

    public BrokerInfo reset() {
        this.nodeId = BrokerInfoEncoder.nodeIdNullValue();
        this.partitionsCount = BrokerInfoEncoder.partitionsCountNullValue();
        this.clusterSize = BrokerInfoEncoder.clusterSizeNullValue();
        this.replicationFactor = BrokerInfoEncoder.replicationFactorNullValue();
        this.addresses.clear();
        this.version.wrap(0L, 0);
        this.clearPartitions();
        return this;
    }

    public void clearPartitions() {
        this.partitionRoles.clear();
        this.partitionLeaderTerms.clear();
        this.partitionHealthStatuses.clear();
    }

    public void removePartition(int partitionId) {
        this.partitionRoles.remove(partitionId);
        this.partitionLeaderTerms.remove(partitionId);
        this.partitionHealthStatuses.remove(partitionId);
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public BrokerInfo setNodeId(int nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public int getPartitionsCount() {
        return this.partitionsCount;
    }

    public BrokerInfo setPartitionsCount(int partitionsCount) {
        this.partitionsCount = partitionsCount;
        return this;
    }

    public int getClusterSize() {
        return this.clusterSize;
    }

    public BrokerInfo setClusterSize(int clusterSize) {
        this.clusterSize = clusterSize;
        return this;
    }

    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public BrokerInfo setReplicationFactor(int replicationFactor) {
        this.replicationFactor = replicationFactor;
        return this;
    }

    public String getVersion() {
        return BufferUtil.bufferAsString((DirectBuffer)this.version);
    }

    public void setVersion(String version) {
        this.version = BufferUtil.wrapString((String)version);
    }

    public void setVersion(DirectBuffer buffer, int offset, int length) {
        this.version.wrap(buffer, offset, length);
    }

    public Map<DirectBuffer, DirectBuffer> getAddresses() {
        return this.addresses;
    }

    public BrokerInfo addAddress(DirectBuffer apiName, DirectBuffer address) {
        this.addresses.put(apiName, address);
        return this;
    }

    public String getCommandApiAddress() {
        DirectBuffer buffer = this.addresses.get(COMMAND_API_NAME);
        if (buffer != null) {
            return BufferUtil.bufferAsString((DirectBuffer)buffer);
        }
        return null;
    }

    public BrokerInfo setCommandApiAddress(String address) {
        return this.setCommandApiAddress(BufferUtil.wrapString((String)address));
    }

    public BrokerInfo setCommandApiAddress(DirectBuffer address) {
        return this.addAddress(COMMAND_API_NAME, address);
    }

    public Map<Integer, PartitionRole> getPartitionRoles() {
        return this.partitionRoles;
    }

    public Map<Integer, PartitionHealthStatus> getPartitionHealthStatuses() {
        return this.partitionHealthStatuses;
    }

    public Map<Integer, Long> getPartitionLeaderTerms() {
        return this.partitionLeaderTerms;
    }

    public BrokerInfo addPartitionRole(Integer partitionId, PartitionRole role) {
        this.partitionRoles.put(partitionId, role);
        return this;
    }

    public BrokerInfo addPartitionHealth(Integer partitionId, PartitionHealthStatus status) {
        this.partitionHealthStatuses.put(partitionId, status);
        return this;
    }

    public BrokerInfo setPartitionUnhealthy(Integer partitionId) {
        this.addPartitionHealth(partitionId, PartitionHealthStatus.UNHEALTHY);
        return this;
    }

    public BrokerInfo setPartitionHealthy(Integer partitionId) {
        this.addPartitionHealth(partitionId, PartitionHealthStatus.HEALTHY);
        return this;
    }

    public BrokerInfo setPartitionDead(Integer partitionId) {
        this.addPartitionHealth(partitionId, PartitionHealthStatus.DEAD);
        return this;
    }

    public BrokerInfo setFollowerForPartition(int partitionId) {
        this.partitionLeaderTerms.remove(partitionId);
        return this.addPartitionRole(partitionId, PartitionRole.FOLLOWER);
    }

    public BrokerInfo setLeaderForPartition(int partitionId, long term) {
        this.partitionLeaderTerms.put(partitionId, term);
        return this.addPartitionRole(partitionId, PartitionRole.LEADER);
    }

    public BrokerInfo setInactiveForPartition(int partitionId) {
        this.partitionLeaderTerms.remove(partitionId);
        return this.addPartitionRole(partitionId, PartitionRole.INACTIVE);
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.reset();
        int frameEnd = offset + length;
        this.headerDecoder.wrap(buffer, offset);
        this.bodyDecoder.wrap(buffer, offset += this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        this.nodeId = this.bodyDecoder.nodeId();
        this.partitionsCount = this.bodyDecoder.partitionsCount();
        this.clusterSize = this.bodyDecoder.clusterSize();
        this.replicationFactor = this.bodyDecoder.replicationFactor();
        BrokerInfoDecoder.AddressesDecoder addressesDecoder = this.bodyDecoder.addresses();
        while (addressesDecoder.hasNext()) {
            addressesDecoder.next();
            int apiNameLength = addressesDecoder.apiNameLength();
            byte[] apiNameBytes = new byte[apiNameLength];
            addressesDecoder.getApiName(apiNameBytes, 0, apiNameLength);
            int addressLength = addressesDecoder.addressLength();
            byte[] addressBytes = new byte[addressLength];
            addressesDecoder.getAddress(addressBytes, 0, addressLength);
            this.addAddress((DirectBuffer)new UnsafeBuffer(apiNameBytes), (DirectBuffer)new UnsafeBuffer(addressBytes));
        }
        BrokerInfoDecoder.PartitionRolesDecoder partitionRolesDecoder = this.bodyDecoder.partitionRoles();
        while (partitionRolesDecoder.hasNext()) {
            partitionRolesDecoder.next();
            this.addPartitionRole(partitionRolesDecoder.partitionId(), partitionRolesDecoder.role());
        }
        BrokerInfoDecoder.PartitionLeaderTermsDecoder partitionLeaderTermsDecoder = this.bodyDecoder.partitionLeaderTerms();
        while (partitionLeaderTermsDecoder.hasNext()) {
            partitionLeaderTermsDecoder.next();
            this.partitionLeaderTerms.put(partitionLeaderTermsDecoder.partitionId(), partitionLeaderTermsDecoder.term());
        }
        if (this.bodyDecoder.versionLength() > 0) {
            this.bodyDecoder.wrapVersion(this.version);
        } else {
            this.bodyDecoder.skipVersion();
        }
        BrokerInfoDecoder.PartitionHealthDecoder partitionHealthDecoder = this.bodyDecoder.partitionHealth();
        while (partitionHealthDecoder.hasNext()) {
            partitionHealthDecoder.next();
            this.partitionHealthStatuses.put(partitionHealthDecoder.partitionId(), partitionHealthDecoder.healthStatus());
        }
        assert (this.bodyDecoder.limit() == frameEnd) : "Decoder read only to position " + this.bodyDecoder.limit() + " but expected " + frameEnd + " as final position";
    }

    public int getLength() {
        int length = this.headerEncoder.encodedLength() + this.bodyEncoder.sbeBlockLength() + BrokerInfoEncoder.AddressesEncoder.sbeHeaderSize() + BrokerInfoEncoder.PartitionRolesEncoder.sbeHeaderSize() + BrokerInfoEncoder.PartitionLeaderTermsEncoder.sbeHeaderSize() + BrokerInfoEncoder.PartitionHealthEncoder.sbeHeaderSize() + BrokerInfoEncoder.versionHeaderLength() + this.version.capacity();
        for (Map.Entry<DirectBuffer, DirectBuffer> entry : this.addresses.entrySet()) {
            length += BrokerInfoEncoder.AddressesEncoder.sbeBlockLength() + BrokerInfoEncoder.AddressesEncoder.apiNameHeaderLength() + entry.getKey().capacity() + BrokerInfoEncoder.AddressesEncoder.addressHeaderLength() + entry.getValue().capacity();
        }
        length += this.partitionRoles.size() * BrokerInfoEncoder.PartitionRolesEncoder.sbeBlockLength();
        length += this.partitionLeaderTerms.size() * BrokerInfoEncoder.PartitionLeaderTermsEncoder.sbeBlockLength();
        return length += this.partitionHealthStatuses.size() * BrokerInfoEncoder.PartitionHealthEncoder.sbeBlockLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset).blockLength(this.bodyEncoder.sbeBlockLength()).templateId(this.bodyEncoder.sbeTemplateId()).schemaId(this.bodyEncoder.sbeSchemaId()).version(this.bodyEncoder.sbeSchemaVersion());
        this.bodyEncoder.wrap(buffer, offset += this.headerEncoder.encodedLength()).nodeId(this.nodeId).partitionsCount(this.partitionsCount).clusterSize(this.clusterSize).replicationFactor(this.replicationFactor);
        int addressesCount = this.addresses.size();
        BrokerInfoEncoder.AddressesEncoder addressesEncoder = this.bodyEncoder.addressesCount(addressesCount);
        if (addressesCount > 0) {
            for (Map.Entry<DirectBuffer, DirectBuffer> entry : this.addresses.entrySet()) {
                DirectBuffer apiName = entry.getKey();
                DirectBuffer directBuffer = entry.getValue();
                addressesEncoder.next().putApiName(apiName, 0, apiName.capacity()).putAddress(directBuffer, 0, directBuffer.capacity());
            }
        }
        int partitionRolesCount = this.partitionRoles.size();
        BrokerInfoEncoder.PartitionRolesEncoder partitionRolesEncoder = this.bodyEncoder.partitionRolesCount(partitionRolesCount);
        if (partitionRolesCount > 0) {
            for (Map.Entry entry : this.partitionRoles.entrySet()) {
                partitionRolesEncoder.next().partitionId(((Integer)entry.getKey()).intValue()).role((PartitionRole)entry.getValue());
            }
        }
        int partitionLeaderTermsCount = this.partitionLeaderTerms.size();
        BrokerInfoEncoder.PartitionLeaderTermsEncoder partitionLeaderTermsEncoder = this.bodyEncoder.partitionLeaderTermsCount(partitionLeaderTermsCount);
        if (partitionLeaderTermsCount > 0) {
            for (Map.Entry<Integer, Long> entry : this.partitionLeaderTerms.entrySet()) {
                partitionLeaderTermsEncoder.next().partitionId(entry.getKey().intValue()).term(entry.getValue().longValue());
            }
        }
        this.bodyEncoder.putVersion(this.version, 0, this.version.capacity());
        int partitionHealthCount = this.partitionHealthStatuses.size();
        BrokerInfoEncoder.PartitionHealthEncoder partitionHealthEncoder = this.bodyEncoder.partitionHealthCount(partitionHealthCount);
        if (partitionHealthCount > 0) {
            for (Map.Entry<Integer, PartitionHealthStatus> entry : this.partitionHealthStatuses.entrySet()) {
                partitionHealthEncoder.next().partitionId(entry.getKey().intValue()).healthStatus(entry.getValue());
            }
        }
    }

    public static BrokerInfo fromProperties(Properties properties) {
        String property = properties.getProperty(BROKER_INFO_PROPERTY_NAME);
        if (property != null) {
            return BrokerInfo.readFromString(property);
        }
        return null;
    }

    private static BrokerInfo readFromString(String property) {
        byte[] bytes = BASE_64_DECODER.decode(property.getBytes(BASE_64_CHARSET));
        BrokerInfo brokerInfo = new BrokerInfo();
        brokerInfo.wrap((DirectBuffer)new UnsafeBuffer(bytes), 0, bytes.length);
        return brokerInfo;
    }

    public void writeIntoProperties(Properties memberProperties) {
        memberProperties.setProperty(BROKER_INFO_PROPERTY_NAME, this.writeToString());
    }

    private String writeToString() {
        byte[] bytes = new byte[this.getLength()];
        UnsafeBuffer buffer = new UnsafeBuffer(bytes);
        this.write((MutableDirectBuffer)buffer, 0);
        return new String(BASE_64_ENCODER.encode(bytes), BASE_64_CHARSET);
    }

    public void consumePartitions(ObjLongConsumer<Integer> leaderPartitionConsumer, IntConsumer followerPartitionsConsumer, IntConsumer inactivePartitionsConsumer) {
        this.consumePartitions(p -> {}, leaderPartitionConsumer, followerPartitionsConsumer, inactivePartitionsConsumer);
    }

    public void consumePartitions(IntConsumer partitionConsumer, ObjLongConsumer<Integer> leaderPartitionConsumer, IntConsumer followerPartitionsConsumer, IntConsumer inactivePartitionsConsumer) {
        this.partitionRoles.forEach((partition, role) -> {
            partitionConsumer.accept((int)partition);
            switch (role) {
                case LEADER: {
                    leaderPartitionConsumer.accept((Integer)partition, this.partitionLeaderTerms.get(partition));
                    break;
                }
                case FOLLOWER: {
                    followerPartitionsConsumer.accept((int)partition);
                    break;
                }
                case INACTIVE: {
                    inactivePartitionsConsumer.accept((int)partition);
                    break;
                }
                default: {
                    LOG.warn("Failed to decode broker info, found unknown partition role: {}", role);
                }
            }
        });
    }

    public BrokerInfo consumePartitionsHealth(BiConsumer<Integer, PartitionHealthStatus> partitionConsumer) {
        this.partitionHealthStatuses.forEach(partitionConsumer);
        return this;
    }

    public String toString() {
        return "BrokerInfo{nodeId=" + this.nodeId + ", partitionsCount=" + this.partitionsCount + ", clusterSize=" + this.clusterSize + ", replicationFactor=" + this.replicationFactor + ", partitionRoles=" + String.valueOf(this.partitionRoles) + ", partitionLeaderTerms=" + String.valueOf(this.partitionLeaderTerms) + ", partitionHealthStatuses=" + String.valueOf(this.partitionHealthStatuses) + ", version=" + BufferUtil.bufferAsString((DirectBuffer)this.version) + "}";
    }
}

