/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.usertask;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.DocumentProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.value.UserTaskRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Map;
import org.agrona.DirectBuffer;

public final class UserTaskRecord
extends UnifiedRecordValue
implements UserTaskRecordValue {
    private static final String EMPTY_STRING = "";
    private final LongProperty userTaskKeyProp = new LongProperty("userTaskKey", -1L);
    private final StringProperty assigneeProp = new StringProperty("assignee", "");
    private final StringProperty candidateGroupsProp = new StringProperty("candidateGroups", "");
    private final StringProperty candidateUsersProp = new StringProperty("candidateUsers", "");
    private final StringProperty dueDateProp = new StringProperty("dueDate", "");
    private final StringProperty followUpDateProp = new StringProperty("followUpDate", "");
    private final LongProperty formKeyProp = new LongProperty("formKey", -1L);
    private final DocumentProperty variableProp = new DocumentProperty("variables");
    private final LongProperty processInstanceKeyProp = new LongProperty("processInstanceKey", -1L);
    private final StringProperty bpmnProcessIdProp = new StringProperty("bpmnProcessId", "");
    private final IntegerProperty processDefinitionVersionProp = new IntegerProperty("processDefinitionVersion", -1);
    private final LongProperty processDefinitionKeyProp = new LongProperty("processDefinitionKey", -1L);
    private final StringProperty elementIdProp = new StringProperty("elementId", "");
    private final LongProperty elementInstanceKeyProp = new LongProperty("elementInstanceKey", -1L);
    private final StringProperty tenantIdProp = new StringProperty("tenantId", "<default>");

    public UserTaskRecord() {
        super(15);
        this.declareProperty((BaseProperty)this.userTaskKeyProp).declareProperty((BaseProperty)this.assigneeProp).declareProperty((BaseProperty)this.candidateGroupsProp).declareProperty((BaseProperty)this.candidateUsersProp).declareProperty((BaseProperty)this.dueDateProp).declareProperty((BaseProperty)this.followUpDateProp).declareProperty((BaseProperty)this.formKeyProp).declareProperty((BaseProperty)this.variableProp).declareProperty((BaseProperty)this.bpmnProcessIdProp).declareProperty((BaseProperty)this.processDefinitionVersionProp).declareProperty((BaseProperty)this.processDefinitionKeyProp).declareProperty((BaseProperty)this.processInstanceKeyProp).declareProperty((BaseProperty)this.elementIdProp).declareProperty((BaseProperty)this.elementInstanceKeyProp).declareProperty((BaseProperty)this.tenantIdProp);
    }

    public void wrapWithoutVariables(UserTaskRecord record) {
        this.userTaskKeyProp.setValue(record.getUserTaskKey());
        this.assigneeProp.setValue(record.getAssigneeBuffer());
        this.candidateGroupsProp.setValue(record.getCandidateGroupsBuffer());
        this.candidateUsersProp.setValue(record.getCandidateUsersBuffer());
        this.dueDateProp.setValue(record.getDueDateBuffer());
        this.followUpDateProp.setValue(record.getFollowUpDateBuffer());
        this.formKeyProp.setValue(record.getFormKey());
        this.bpmnProcessIdProp.setValue(record.getBpmnProcessIdBuffer());
        this.processDefinitionVersionProp.setValue(record.getProcessDefinitionVersion());
        this.processDefinitionKeyProp.setValue(record.getProcessDefinitionKey());
        this.processInstanceKeyProp.setValue(record.getProcessInstanceKey());
        this.elementIdProp.setValue(record.getElementIdBuffer());
        this.elementInstanceKeyProp.setValue(record.getElementInstanceKey());
        this.tenantIdProp.setValue(record.getTenantIdBuffer());
    }

    public void wrap(UserTaskRecord record) {
        this.wrapWithoutVariables(record);
        this.variableProp.setValue(record.getVariablesBuffer());
    }

    public UserTaskRecord resetVariables() {
        this.variableProp.reset();
        return this;
    }

    public long getUserTaskKey() {
        return this.userTaskKeyProp.getValue();
    }

    public String getAssignee() {
        return BufferUtil.bufferAsString((DirectBuffer)this.assigneeProp.getValue());
    }

    public String getCandidateGroups() {
        return BufferUtil.bufferAsString((DirectBuffer)this.candidateGroupsProp.getValue());
    }

    public String getCandidateUsers() {
        return BufferUtil.bufferAsString((DirectBuffer)this.candidateUsersProp.getValue());
    }

    public String getDueDate() {
        return BufferUtil.bufferAsString((DirectBuffer)this.dueDateProp.getValue());
    }

    public String getFollowUpDate() {
        return BufferUtil.bufferAsString((DirectBuffer)this.followUpDateProp.getValue());
    }

    public long getFormKey() {
        return this.formKeyProp.getValue();
    }

    public String getElementId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.elementIdProp.getValue());
    }

    public long getElementInstanceKey() {
        return this.elementInstanceKeyProp.getValue();
    }

    public String getBpmnProcessId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.bpmnProcessIdProp.getValue());
    }

    public int getProcessDefinitionVersion() {
        return this.processDefinitionVersionProp.getValue();
    }

    public long getProcessDefinitionKey() {
        return this.processDefinitionKeyProp.getValue();
    }

    public UserTaskRecord setProcessDefinitionKey(long processDefinitionKey) {
        this.processDefinitionKeyProp.setValue(processDefinitionKey);
        return this;
    }

    public UserTaskRecord setProcessDefinitionVersion(int version) {
        this.processDefinitionVersionProp.setValue(version);
        return this;
    }

    public UserTaskRecord setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    public UserTaskRecord setBpmnProcessId(DirectBuffer bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    public UserTaskRecord setElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKeyProp.setValue(elementInstanceKey);
        return this;
    }

    public UserTaskRecord setElementId(String elementId) {
        this.elementIdProp.setValue(elementId);
        return this;
    }

    public UserTaskRecord setElementId(DirectBuffer elementId) {
        this.elementIdProp.setValue(elementId);
        return this;
    }

    public UserTaskRecord setFormKey(long formKey) {
        this.formKeyProp.setValue(formKey);
        return this;
    }

    public UserTaskRecord setFollowUpDate(String followUpDate) {
        this.followUpDateProp.setValue(followUpDate);
        return this;
    }

    public UserTaskRecord setFollowUpDate(DirectBuffer followUpDate) {
        this.followUpDateProp.setValue(followUpDate);
        return this;
    }

    public UserTaskRecord setDueDate(String dueDate) {
        this.dueDateProp.setValue(dueDate);
        return this;
    }

    public UserTaskRecord setDueDate(DirectBuffer dueDate) {
        this.dueDateProp.setValue(dueDate);
        return this;
    }

    public UserTaskRecord setCandidateUsers(String candidateUsers) {
        this.candidateUsersProp.setValue(candidateUsers);
        return this;
    }

    public UserTaskRecord setCandidateUsers(DirectBuffer candidateUsers) {
        this.candidateUsersProp.setValue(candidateUsers);
        return this;
    }

    public UserTaskRecord setCandidateGroups(String candidateGroups) {
        this.candidateGroupsProp.setValue(candidateGroups);
        return this;
    }

    public UserTaskRecord setCandidateGroups(DirectBuffer candidateGroups) {
        this.candidateGroupsProp.setValue(candidateGroups);
        return this;
    }

    public UserTaskRecord setAssignee(String assignee) {
        this.assigneeProp.setValue(assignee);
        return this;
    }

    public UserTaskRecord setAssignee(DirectBuffer assignee) {
        this.assigneeProp.setValue(assignee);
        return this;
    }

    public UserTaskRecord setUserTaskKey(long userTaskKey) {
        this.userTaskKeyProp.setValue(userTaskKey);
        return this;
    }

    public String getTenantId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.tenantIdProp.getValue());
    }

    public UserTaskRecord setTenantId(String tenantId) {
        this.tenantIdProp.setValue(tenantId);
        return this;
    }

    public Map<String, Object> getVariables() {
        return MsgPackConverter.convertToMap(this.variableProp.getValue());
    }

    public UserTaskRecord setVariables(DirectBuffer variables) {
        this.variableProp.setValue(variables);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getAssigneeBuffer() {
        return this.assigneeProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getCandidateGroupsBuffer() {
        return this.candidateGroupsProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getCandidateUsersBuffer() {
        return this.candidateUsersProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getDueDateBuffer() {
        return this.dueDateProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getFollowUpDateBuffer() {
        return this.followUpDateProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getTenantIdBuffer() {
        return this.tenantIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getVariablesBuffer() {
        return this.variableProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getBpmnProcessIdBuffer() {
        return this.bpmnProcessIdProp.getValue();
    }

    public long getProcessInstanceKey() {
        return this.processInstanceKeyProp.getValue();
    }

    public UserTaskRecord setProcessInstanceKey(long key) {
        this.processInstanceKeyProp.setValue(key);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getElementIdBuffer() {
        return this.elementIdProp.getValue();
    }
}

