/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.user;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.EnumProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.value.UserRecordValue;
import io.camunda.zeebe.protocol.record.value.UserType;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class UserRecord
extends UnifiedRecordValue
implements UserRecordValue {
    private final LongProperty userKeyProp = new LongProperty("userKey", -1L);
    private final StringProperty usernameProp = new StringProperty("username");
    private final StringProperty nameProp = new StringProperty("name", "");
    private final StringProperty emailProp = new StringProperty("email", "");
    private final StringProperty passwordProp = new StringProperty("password", "");
    private final EnumProperty<UserType> userTypeProp = new EnumProperty("userType", UserType.class, (Enum)UserType.REGULAR);

    public UserRecord() {
        super(6);
        this.declareProperty((BaseProperty)this.userKeyProp).declareProperty((BaseProperty)this.usernameProp).declareProperty((BaseProperty)this.nameProp).declareProperty((BaseProperty)this.emailProp).declareProperty((BaseProperty)this.passwordProp).declareProperty(this.userTypeProp);
    }

    public void wrap(UserRecord record) {
        this.userKeyProp.setValue(record.getUserKey().longValue());
        this.usernameProp.setValue(record.getUsernameBuffer());
        this.nameProp.setValue(record.getNameBuffer());
        this.emailProp.setValue(record.getEmailBuffer());
        this.passwordProp.setValue(record.getPasswordBuffer());
        this.userTypeProp.setValue((Enum)record.getUserType());
    }

    public UserRecord copy() {
        UserRecord copy = new UserRecord();
        copy.usernameProp.setValue(BufferUtil.cloneBuffer((DirectBuffer)this.getUsernameBuffer()));
        copy.nameProp.setValue(BufferUtil.cloneBuffer((DirectBuffer)this.getNameBuffer()));
        copy.emailProp.setValue(BufferUtil.cloneBuffer((DirectBuffer)this.getEmailBuffer()));
        copy.passwordProp.setValue(BufferUtil.cloneBuffer((DirectBuffer)this.getPasswordBuffer()));
        copy.userTypeProp.setValue((Enum)this.getUserType());
        return copy;
    }

    public Long getUserKey() {
        return this.userKeyProp.getValue();
    }

    public UserRecord setUserKey(Long userKey) {
        this.userKeyProp.setValue(userKey.longValue());
        return this;
    }

    public String getUsername() {
        return BufferUtil.bufferAsString((DirectBuffer)this.usernameProp.getValue());
    }

    public UserRecord setUsername(String username) {
        this.usernameProp.setValue(username);
        return this;
    }

    public UserRecord setUsername(DirectBuffer username) {
        this.usernameProp.setValue(username);
        return this;
    }

    public String getName() {
        return BufferUtil.bufferAsString((DirectBuffer)this.nameProp.getValue());
    }

    public UserRecord setName(String name) {
        this.nameProp.setValue(name);
        return this;
    }

    public UserRecord setName(DirectBuffer name) {
        this.nameProp.setValue(name);
        return this;
    }

    public String getEmail() {
        return BufferUtil.bufferAsString((DirectBuffer)this.emailProp.getValue());
    }

    public UserRecord setEmail(String email) {
        this.emailProp.setValue(email);
        return this;
    }

    public UserRecord setEmail(DirectBuffer email) {
        this.emailProp.setValue(email);
        return this;
    }

    public String getPassword() {
        return BufferUtil.bufferAsString((DirectBuffer)this.passwordProp.getValue());
    }

    public UserType getUserType() {
        return (UserType)this.userTypeProp.getValue();
    }

    public UserRecord setUserType(UserType userType) {
        this.userTypeProp.setValue((Enum)userType);
        return this;
    }

    public UserRecord setPassword(String password) {
        this.passwordProp.setValue(password);
        return this;
    }

    public UserRecord setPassword(DirectBuffer password) {
        this.passwordProp.setValue(password);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getUsernameBuffer() {
        return this.usernameProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getNameBuffer() {
        return this.nameProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getEmailBuffer() {
        return this.emailProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getPasswordBuffer() {
        return this.passwordProp.getValue();
    }
}

