/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.message;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.DocumentProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageCorrelationRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Map;
import org.agrona.DirectBuffer;

public final class MessageCorrelationRecord
extends UnifiedRecordValue
implements MessageCorrelationRecordValue {
    private final StringProperty nameProp = new StringProperty("name");
    private final StringProperty correlationKeyProp = new StringProperty("correlationKey");
    private final DocumentProperty variablesProp = new DocumentProperty("variables");
    private final StringProperty tenantIdProp = new StringProperty("tenantId", "<default>");
    private final LongProperty messageKey = new LongProperty("messageKey", -1L);
    private final LongProperty requestIdProp = new LongProperty("requestId", -1L);
    private final IntegerProperty requestStreamIdProp = new IntegerProperty("requestStreamId", -1);
    private final LongProperty processInstanceKeyProp = new LongProperty("processInstanceKey", -1L);

    public MessageCorrelationRecord() {
        super(7);
        this.declareProperty((BaseProperty)this.nameProp).declareProperty((BaseProperty)this.correlationKeyProp).declareProperty((BaseProperty)this.variablesProp).declareProperty((BaseProperty)this.tenantIdProp).declareProperty((BaseProperty)this.messageKey).declareProperty((BaseProperty)this.requestIdProp).declareProperty((BaseProperty)this.requestStreamIdProp).declareProperty((BaseProperty)this.processInstanceKeyProp);
    }

    public void wrap(MessageCorrelationRecord record) {
        this.setName(record.getName());
        this.setCorrelationKey(record.getCorrelationKey());
        this.setVariables(record.getVariablesBuffer());
        this.setTenantId(record.getTenantId());
        this.setProcessInstanceKey(record.getProcessInstanceKey());
    }

    public String getName() {
        return BufferUtil.bufferAsString((DirectBuffer)this.nameProp.getValue());
    }

    public String getCorrelationKey() {
        return BufferUtil.bufferAsString((DirectBuffer)this.correlationKeyProp.getValue());
    }

    public MessageCorrelationRecord setCorrelationKey(String correlationKey) {
        this.correlationKeyProp.setValue(correlationKey);
        return this;
    }

    public long getMessageKey() {
        return this.messageKey.getValue();
    }

    public long getRequestId() {
        return this.requestIdProp.getValue();
    }

    public int getRequestStreamId() {
        return this.requestStreamIdProp.getValue();
    }

    public MessageCorrelationRecord setRequestStreamId(int requestStreamId) {
        this.requestStreamIdProp.setValue(requestStreamId);
        return this;
    }

    public MessageCorrelationRecord setRequestId(long requestId) {
        this.requestIdProp.setValue(requestId);
        return this;
    }

    public MessageCorrelationRecord setMessageKey(long messageKey) {
        this.messageKey.setValue(messageKey);
        return this;
    }

    public MessageCorrelationRecord setName(String name) {
        this.nameProp.setValue(name);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getNameBuffer() {
        return this.nameProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getCorrelationKeyBuffer() {
        return this.correlationKeyProp.getValue();
    }

    public Map<String, Object> getVariables() {
        return MsgPackConverter.convertToMap(this.variablesProp.getValue());
    }

    public MessageCorrelationRecord setVariables(DirectBuffer variables) {
        this.variablesProp.setValue(variables);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getVariablesBuffer() {
        return this.variablesProp.getValue();
    }

    public String getTenantId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.tenantIdProp.getValue());
    }

    public MessageCorrelationRecord setTenantId(String tenantId) {
        this.tenantIdProp.setValue(tenantId);
        return this;
    }

    public long getProcessInstanceKey() {
        return this.processInstanceKeyProp.getValue();
    }

    public MessageCorrelationRecord setProcessInstanceKey(long processInstanceKey) {
        this.processInstanceKeyProp.setValue(processInstanceKey);
        return this;
    }
}

