/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.util;

import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.Record;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProtocolTypeMapping {
    private static final String PROTOCOL_PACKAGE_NAME = Record.class.getPackage().getName() + "*";
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolTypeMapping.class);
    private final Map<Class<?>, Mapping<?>> concreteMappings = new HashMap();
    private final Map<Class<?>, Mapping<?>> abstractMappings = new HashMap();
    private final Map<Class<?>, Mapping<?>> builderMappings = new HashMap();

    private ProtocolTypeMapping() {
        this.loadTypeMappings();
    }

    public static void forEach(Consumer<Mapping<?>> consumer) {
        Singleton.INSTANCE.concreteMappings.values().forEach(consumer);
    }

    public static Mapping<?> getForConcreteType(Class<?> concreteType) {
        return Singleton.INSTANCE.concreteMappings.get(concreteType);
    }

    public static Mapping<?> getForAbstractType(Class<?> abstractType) {
        return Singleton.INSTANCE.abstractMappings.get(abstractType);
    }

    public static Mapping<?> getForBuilderType(Class<?> builderType) {
        return Singleton.INSTANCE.builderMappings.get(builderType);
    }

    private void loadTypeMappings() {
        ClassInfoList abstractTypes = ProtocolTypeMapping.findProtocolTypes();
        for (ClassInfo abstractType : abstractTypes) {
            LOGGER.trace("Found abstract protocol type {}", (Object)abstractType);
            this.loadTypeMappingsFor(abstractType, abstractType.loadClass());
        }
        if (abstractTypes.isEmpty()) {
            LOGGER.warn("Found no abstract protocol types in package {}; deserialization will most likely not work", (Object)PROTOCOL_PACKAGE_NAME);
        }
    }

    private <T> void loadTypeMappingsFor(ClassInfo abstractType, Class<T> abstractClass) {
        Objects.requireNonNull(abstractType, "must specify an abstract type");
        Objects.requireNonNull(abstractClass, "must specify the abstract class");
        ClassInfoList concreteTypes = abstractType.getClassesImplementing().filter(ClassInfo::isStandardClass).filter(info -> !info.isAbstract()).directOnly();
        for (ClassInfo concreteType : concreteTypes) {
            Class concreteClass = concreteType.loadClass(abstractClass);
            LOGGER.trace("Found concrete type mapping for protocol class {} => {}", abstractClass, (Object)concreteClass);
            this.loadTypeMappingsFor(concreteType, abstractClass, concreteClass);
        }
        if (concreteTypes.isEmpty()) {
            LOGGER.warn("Found no concrete type mapping for protocol type {}; deserialization may not always work", abstractClass);
        }
    }

    private <T> void loadTypeMappingsFor(ClassInfo concreteType, Class<T> abstractClass, Class<T> concreteClass) {
        Objects.requireNonNull(concreteType, "must specify a concrete type");
        Objects.requireNonNull(abstractClass, "must specify an abstract class");
        Objects.requireNonNull(concreteClass, "must specify a concrete class");
        ClassInfoList builderTypes = concreteType.getInnerClasses().filter(info -> "Builder".equals(info.getSimpleName()));
        for (ClassInfo builder : builderTypes) {
            Class builderClass = builder.loadClass();
            Mapping mapping = new Mapping(abstractClass, concreteClass, builderClass);
            this.concreteMappings.put(concreteClass, mapping);
            this.abstractMappings.put(abstractClass, mapping);
            this.builderMappings.put(builderClass, mapping);
        }
        if (builderTypes.isEmpty()) {
            LOGGER.warn("Found no inner builder type for concrete type {} of protocol type {}; deserialization may not work", concreteClass, abstractClass);
        }
    }

    static ClassInfoList findProtocolTypes() {
        return new ClassGraph().acceptPackages(new String[]{PROTOCOL_PACKAGE_NAME}).enableAnnotationInfo().scan().getAllInterfaces().filter(info -> info.hasAnnotation(ImmutableProtocol.class)).directOnly();
    }

    private static final class Singleton {
        private static final ProtocolTypeMapping INSTANCE = new ProtocolTypeMapping();

        private Singleton() {
        }
    }

    public static final class Mapping<T> {
        final Class<T> abstractClass;
        final Class<? extends T> concreteClass;
        final Class<?> builderClass;

        private Mapping(Class<T> abstractClass, Class<? extends T> concreteClass, Class<?> builderClass) {
            this.abstractClass = Objects.requireNonNull(abstractClass, "must specify an abstract class");
            this.concreteClass = Objects.requireNonNull(concreteClass, "must specify a concrete class");
            this.builderClass = Objects.requireNonNull(builderClass, "must specify a builder class");
        }

        public Class<T> getAbstractClass() {
            return this.abstractClass;
        }

        public Class<? extends T> getConcreteClass() {
            return this.concreteClass;
        }

        public Class<?> getBuilderClass() {
            return this.builderClass;
        }
    }
}

