/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="VariableRecordValue", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableVariableRecordValue
implements VariableRecordValue {
    private final String name;
    private final String value;
    private final long scopeKey;
    private final long processInstanceKey;
    private final long processDefinitionKey;
    private final String bpmnProcessId;
    private transient int hashCode;

    private ImmutableVariableRecordValue(String name, String value, long scopeKey, long processInstanceKey, long processDefinitionKey, String bpmnProcessId) {
        this.name = name;
        this.value = value;
        this.scopeKey = scopeKey;
        this.processInstanceKey = processInstanceKey;
        this.processDefinitionKey = processDefinitionKey;
        this.bpmnProcessId = bpmnProcessId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public long getScopeKey() {
        return this.scopeKey;
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    public final ImmutableVariableRecordValue withName(String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableVariableRecordValue(value, this.value, this.scopeKey, this.processInstanceKey, this.processDefinitionKey, this.bpmnProcessId);
    }

    public final ImmutableVariableRecordValue withValue(String value) {
        if (Objects.equals(this.value, value)) {
            return this;
        }
        return new ImmutableVariableRecordValue(this.name, value, this.scopeKey, this.processInstanceKey, this.processDefinitionKey, this.bpmnProcessId);
    }

    public final ImmutableVariableRecordValue withScopeKey(long value) {
        if (this.scopeKey == value) {
            return this;
        }
        return new ImmutableVariableRecordValue(this.name, this.value, value, this.processInstanceKey, this.processDefinitionKey, this.bpmnProcessId);
    }

    public final ImmutableVariableRecordValue withProcessInstanceKey(long value) {
        if (this.processInstanceKey == value) {
            return this;
        }
        return new ImmutableVariableRecordValue(this.name, this.value, this.scopeKey, value, this.processDefinitionKey, this.bpmnProcessId);
    }

    public final ImmutableVariableRecordValue withProcessDefinitionKey(long value) {
        if (this.processDefinitionKey == value) {
            return this;
        }
        return new ImmutableVariableRecordValue(this.name, this.value, this.scopeKey, this.processInstanceKey, value, this.bpmnProcessId);
    }

    public final ImmutableVariableRecordValue withBpmnProcessId(String value) {
        if (Objects.equals(this.bpmnProcessId, value)) {
            return this;
        }
        return new ImmutableVariableRecordValue(this.name, this.value, this.scopeKey, this.processInstanceKey, this.processDefinitionKey, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVariableRecordValue && this.equalTo(0, (ImmutableVariableRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableVariableRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.name, another.name) && Objects.equals(this.value, another.value) && this.scopeKey == another.scopeKey && this.processInstanceKey == another.processInstanceKey && this.processDefinitionKey == another.processDefinitionKey && Objects.equals(this.bpmnProcessId, another.bpmnProcessId);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.value);
        h += (h << 5) + Long.hashCode(this.scopeKey);
        h += (h << 5) + Long.hashCode(this.processInstanceKey);
        h += (h << 5) + Long.hashCode(this.processDefinitionKey);
        h += (h << 5) + Objects.hashCode(this.bpmnProcessId);
        return h;
    }

    public String toString() {
        return "VariableRecordValue{name=" + this.name + ", value=" + this.value + ", scopeKey=" + this.scopeKey + ", processInstanceKey=" + this.processInstanceKey + ", processDefinitionKey=" + this.processDefinitionKey + ", bpmnProcessId=" + this.bpmnProcessId + "}";
    }

    public static ImmutableVariableRecordValue copyOf(VariableRecordValue instance) {
        if (instance instanceof ImmutableVariableRecordValue) {
            return (ImmutableVariableRecordValue)instance;
        }
        return ImmutableVariableRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="VariableRecordValue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String name;
        @Nullable
        private String value;
        private long scopeKey;
        private long processInstanceKey;
        private long processDefinitionKey;
        @Nullable
        private String bpmnProcessId;

        private Builder() {
        }

        public final Builder from(ProcessInstanceRelated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(VariableRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ProcessInstanceRelated instance;
            long bits = 0L;
            if (object instanceof ProcessInstanceRelated) {
                instance = (ProcessInstanceRelated)object;
                if ((bits & 1L) == 0L) {
                    this.withProcessInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
            }
            if (object instanceof VariableRecordValue) {
                String valueValue;
                String bpmnProcessIdValue;
                instance = (VariableRecordValue)object;
                String nameValue = instance.getName();
                if (nameValue != null) {
                    this.withName(nameValue);
                }
                this.withScopeKey(instance.getScopeKey());
                if ((bits & 1L) == 0L) {
                    this.withProcessInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
                if ((bpmnProcessIdValue = instance.getBpmnProcessId()) != null) {
                    this.withBpmnProcessId(bpmnProcessIdValue);
                }
                if ((valueValue = instance.getValue()) != null) {
                    this.withValue(valueValue);
                }
                this.withProcessDefinitionKey(instance.getProcessDefinitionKey());
            }
        }

        public final Builder withName(String name) {
            this.name = name;
            return this;
        }

        public final Builder withValue(String value) {
            this.value = value;
            return this;
        }

        public final Builder withScopeKey(long scopeKey) {
            this.scopeKey = scopeKey;
            return this;
        }

        public final Builder withProcessInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            return this;
        }

        public final Builder withProcessDefinitionKey(long processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
            return this;
        }

        public final Builder withBpmnProcessId(String bpmnProcessId) {
            this.bpmnProcessId = bpmnProcessId;
            return this;
        }

        public Builder clear() {
            this.name = null;
            this.value = null;
            this.scopeKey = 0L;
            this.processInstanceKey = 0L;
            this.processDefinitionKey = 0L;
            this.bpmnProcessId = null;
            return this;
        }

        public ImmutableVariableRecordValue build() {
            return new ImmutableVariableRecordValue(this.name, this.value, this.scopeKey, this.processInstanceKey, this.processDefinitionKey, this.bpmnProcessId);
        }
    }
}

