/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import java.util.Arrays;
import java.util.Optional;

public enum BpmnElementType {
    UNSPECIFIED(null),
    PROCESS("process"),
    SUB_PROCESS("subProcess"),
    EVENT_SUB_PROCESS(null),
    START_EVENT("startEvent"),
    INTERMEDIATE_CATCH_EVENT("intermediateCatchEvent"),
    INTERMEDIATE_THROW_EVENT("intermediateThrowEvent"),
    BOUNDARY_EVENT("boundaryEvent"),
    END_EVENT("endEvent"),
    SERVICE_TASK("serviceTask"),
    RECEIVE_TASK("receiveTask"),
    USER_TASK("userTask"),
    MANUAL_TASK("manualTask"),
    EXCLUSIVE_GATEWAY("exclusiveGateway"),
    PARALLEL_GATEWAY("parallelGateway"),
    EVENT_BASED_GATEWAY("eventBasedGateway"),
    SEQUENCE_FLOW("sequenceFlow"),
    MULTI_INSTANCE_BODY(null),
    CALL_ACTIVITY("callActivity"),
    TESTING_ONLY(null),
    BUSINESS_RULE_TASK("businessRuleTask"),
    SCRIPT_TASK("scriptTask"),
    SEND_TASK("sendTask");

    private final String elementTypeName;

    private BpmnElementType(String elementTypeName) {
        this.elementTypeName = elementTypeName;
    }

    public Optional<String> getElementTypeName() {
        return Optional.ofNullable(this.elementTypeName);
    }

    public static BpmnElementType bpmnElementTypeFor(String elementTypeName) {
        return Arrays.stream(BpmnElementType.values()).filter(bpmnElementType -> bpmnElementType.elementTypeName != null && bpmnElementType.elementTypeName.equals(elementTypeName)).findFirst().orElseThrow(() -> new RuntimeException("Unsupported BPMN element of type " + elementTypeName));
    }
}

