/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.RecordValueWithVariables;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceCreationRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ProcessInstanceCreationRecordValue", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableProcessInstanceCreationRecordValue
implements ProcessInstanceCreationRecordValue {
    private final Map<String, Object> variables;
    private final long processInstanceKey;
    private final String bpmnProcessId;
    private final int version;
    private final long processDefinitionKey;
    private transient int hashCode;

    private ImmutableProcessInstanceCreationRecordValue(Map<String, Object> variables, long processInstanceKey, String bpmnProcessId, int version, long processDefinitionKey) {
        this.variables = variables;
        this.processInstanceKey = processInstanceKey;
        this.bpmnProcessId = bpmnProcessId;
        this.version = version;
        this.processDefinitionKey = processDefinitionKey;
    }

    @Override
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public final ImmutableProcessInstanceCreationRecordValue withVariables(Map<String, ? extends Object> entries) {
        if (this.variables == entries) {
            return this;
        }
        Map<String, Object> newValue = ImmutableProcessInstanceCreationRecordValue.createUnmodifiableMap(false, false, entries);
        return new ImmutableProcessInstanceCreationRecordValue(newValue, this.processInstanceKey, this.bpmnProcessId, this.version, this.processDefinitionKey);
    }

    public final ImmutableProcessInstanceCreationRecordValue withProcessInstanceKey(long value) {
        if (this.processInstanceKey == value) {
            return this;
        }
        return new ImmutableProcessInstanceCreationRecordValue(this.variables, value, this.bpmnProcessId, this.version, this.processDefinitionKey);
    }

    public final ImmutableProcessInstanceCreationRecordValue withBpmnProcessId(String value) {
        if (Objects.equals(this.bpmnProcessId, value)) {
            return this;
        }
        return new ImmutableProcessInstanceCreationRecordValue(this.variables, this.processInstanceKey, value, this.version, this.processDefinitionKey);
    }

    public final ImmutableProcessInstanceCreationRecordValue withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableProcessInstanceCreationRecordValue(this.variables, this.processInstanceKey, this.bpmnProcessId, value, this.processDefinitionKey);
    }

    public final ImmutableProcessInstanceCreationRecordValue withProcessDefinitionKey(long value) {
        if (this.processDefinitionKey == value) {
            return this;
        }
        return new ImmutableProcessInstanceCreationRecordValue(this.variables, this.processInstanceKey, this.bpmnProcessId, this.version, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProcessInstanceCreationRecordValue && this.equalTo(0, (ImmutableProcessInstanceCreationRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableProcessInstanceCreationRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.variables.equals(another.variables) && this.processInstanceKey == another.processInstanceKey && Objects.equals(this.bpmnProcessId, another.bpmnProcessId) && this.version == another.version && this.processDefinitionKey == another.processDefinitionKey;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.variables.hashCode();
        h += (h << 5) + Long.hashCode(this.processInstanceKey);
        h += (h << 5) + Objects.hashCode(this.bpmnProcessId);
        h += (h << 5) + this.version;
        h += (h << 5) + Long.hashCode(this.processDefinitionKey);
        return h;
    }

    public String toString() {
        return "ProcessInstanceCreationRecordValue{variables=" + this.variables + ", processInstanceKey=" + this.processInstanceKey + ", bpmnProcessId=" + this.bpmnProcessId + ", version=" + this.version + ", processDefinitionKey=" + this.processDefinitionKey + "}";
    }

    public static ImmutableProcessInstanceCreationRecordValue copyOf(ProcessInstanceCreationRecordValue instance) {
        if (instance instanceof ImmutableProcessInstanceCreationRecordValue) {
            return (ImmutableProcessInstanceCreationRecordValue)instance;
        }
        return ImmutableProcessInstanceCreationRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="ProcessInstanceCreationRecordValue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private Map<String, Object> variables = new LinkedHashMap<String, Object>();
        private long processInstanceKey;
        @Nullable
        private String bpmnProcessId;
        private int version;
        private long processDefinitionKey;

        private Builder() {
        }

        public final Builder from(ProcessInstanceCreationRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ProcessInstanceRelated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RecordValueWithVariables instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof ProcessInstanceCreationRecordValue) {
                String bpmnProcessIdValue;
                instance = (ProcessInstanceCreationRecordValue)object;
                if ((bits & 1L) == 0L) {
                    this.withProcessInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.putAllVariables(instance.getVariables());
                    bits |= 2L;
                }
                if ((bpmnProcessIdValue = instance.getBpmnProcessId()) != null) {
                    this.withBpmnProcessId(bpmnProcessIdValue);
                }
                this.withVersion(instance.getVersion());
                this.withProcessDefinitionKey(instance.getProcessDefinitionKey());
            }
            if (object instanceof ProcessInstanceRelated) {
                instance = (ProcessInstanceRelated)object;
                if ((bits & 1L) == 0L) {
                    this.withProcessInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
            }
            if (object instanceof RecordValueWithVariables) {
                instance = (RecordValueWithVariables)object;
                if ((bits & 2L) == 0L) {
                    this.putAllVariables(instance.getVariables());
                    bits |= 2L;
                }
            }
        }

        public final Builder putVariable(@Nullable String key, @Nullable Object value) {
            this.variables.put(key, value);
            return this;
        }

        public final Builder putVariable(Map.Entry<String, ? extends Object> entry) {
            String k = entry.getKey();
            Object v = entry.getValue();
            this.variables.put(k, v);
            return this;
        }

        public final Builder withVariables(Map<String, ? extends Object> entries) {
            this.variables.clear();
            return this.putAllVariables(entries);
        }

        public final Builder putAllVariables(Map<String, ? extends Object> entries) {
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.variables.put(k, v);
            }
            return this;
        }

        public final Builder withProcessInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            return this;
        }

        public final Builder withBpmnProcessId(String bpmnProcessId) {
            this.bpmnProcessId = bpmnProcessId;
            return this;
        }

        public final Builder withVersion(int version) {
            this.version = version;
            return this;
        }

        public final Builder withProcessDefinitionKey(long processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
            return this;
        }

        public Builder clear() {
            this.variables.clear();
            this.processInstanceKey = 0L;
            this.bpmnProcessId = null;
            this.version = 0;
            this.processDefinitionKey = 0L;
            return this;
        }

        public ImmutableProcessInstanceCreationRecordValue build() {
            return new ImmutableProcessInstanceCreationRecordValue(ImmutableProcessInstanceCreationRecordValue.createUnmodifiableMap(false, false, this.variables), this.processInstanceKey, this.bpmnProcessId, this.version, this.processDefinitionKey);
        }
    }
}

