/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value.deployment;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.value.deployment.DeploymentResource;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="DeploymentResource", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableDeploymentResource
implements DeploymentResource {
    private final byte[] resource;
    private final String resourceName;
    private transient int hashCode;

    private ImmutableDeploymentResource(byte[] resource, String resourceName) {
        this.resource = resource;
        this.resourceName = resourceName;
    }

    @Override
    public byte[] getResource() {
        return this.resource;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    public final ImmutableDeploymentResource withResource(byte ... elements) {
        byte[] newValue = elements == null ? null : (byte[])elements.clone();
        return new ImmutableDeploymentResource(newValue, this.resourceName);
    }

    public final ImmutableDeploymentResource withResourceName(String value) {
        if (Objects.equals(this.resourceName, value)) {
            return this;
        }
        return new ImmutableDeploymentResource(this.resource, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeploymentResource && this.equalTo(0, (ImmutableDeploymentResource)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeploymentResource another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Arrays.equals(this.resource, another.resource) && Objects.equals(this.resourceName, another.resourceName);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Arrays.hashCode(this.resource);
        h += (h << 5) + Objects.hashCode(this.resourceName);
        return h;
    }

    public String toString() {
        return "DeploymentResource{resource=" + Arrays.toString(this.resource) + ", resourceName=" + this.resourceName + "}";
    }

    public static ImmutableDeploymentResource copyOf(DeploymentResource instance) {
        if (instance instanceof ImmutableDeploymentResource) {
            return (ImmutableDeploymentResource)instance;
        }
        return ImmutableDeploymentResource.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DeploymentResource", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private byte[] resource;
        @Nullable
        private String resourceName;

        private Builder() {
        }

        public final Builder from(DeploymentResource instance) {
            String resourceNameValue;
            Objects.requireNonNull(instance, "instance");
            byte[] resourceValue = instance.getResource();
            if (resourceValue != null) {
                this.withResource(resourceValue);
            }
            if ((resourceNameValue = instance.getResourceName()) != null) {
                this.withResourceName(resourceNameValue);
            }
            return this;
        }

        public final Builder withResource(byte ... resource) {
            this.resource = resource;
            return this;
        }

        public final Builder withResourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public Builder clear() {
            this.resource = null;
            this.resourceName = null;
            return this;
        }

        public ImmutableDeploymentResource build() {
            return new ImmutableDeploymentResource(this.resource, this.resourceName);
        }
    }
}

