/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value.deployment;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.value.deployment.Process;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Process", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableProcess
implements Process {
    private final String bpmnProcessId;
    private final int version;
    private final long processDefinitionKey;
    private final String resourceName;
    private final byte[] checksum;
    private final boolean duplicate;
    private final byte[] resource;
    private transient int hashCode;

    private ImmutableProcess(String bpmnProcessId, int version, long processDefinitionKey, String resourceName, byte[] checksum, boolean duplicate, byte[] resource) {
        this.bpmnProcessId = bpmnProcessId;
        this.version = version;
        this.processDefinitionKey = processDefinitionKey;
        this.resourceName = resourceName;
        this.checksum = checksum;
        this.duplicate = duplicate;
        this.resource = resource;
    }

    @Override
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public byte[] getChecksum() {
        return this.checksum;
    }

    @Override
    public boolean isDuplicate() {
        return this.duplicate;
    }

    @Override
    public byte[] getResource() {
        return this.resource;
    }

    public final ImmutableProcess withBpmnProcessId(String value) {
        if (Objects.equals(this.bpmnProcessId, value)) {
            return this;
        }
        return new ImmutableProcess(value, this.version, this.processDefinitionKey, this.resourceName, this.checksum, this.duplicate, this.resource);
    }

    public final ImmutableProcess withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableProcess(this.bpmnProcessId, value, this.processDefinitionKey, this.resourceName, this.checksum, this.duplicate, this.resource);
    }

    public final ImmutableProcess withProcessDefinitionKey(long value) {
        if (this.processDefinitionKey == value) {
            return this;
        }
        return new ImmutableProcess(this.bpmnProcessId, this.version, value, this.resourceName, this.checksum, this.duplicate, this.resource);
    }

    public final ImmutableProcess withResourceName(String value) {
        if (Objects.equals(this.resourceName, value)) {
            return this;
        }
        return new ImmutableProcess(this.bpmnProcessId, this.version, this.processDefinitionKey, value, this.checksum, this.duplicate, this.resource);
    }

    public final ImmutableProcess withChecksum(byte ... elements) {
        byte[] newValue = elements == null ? null : (byte[])elements.clone();
        return new ImmutableProcess(this.bpmnProcessId, this.version, this.processDefinitionKey, this.resourceName, newValue, this.duplicate, this.resource);
    }

    public final ImmutableProcess withDuplicate(boolean value) {
        if (this.duplicate == value) {
            return this;
        }
        return new ImmutableProcess(this.bpmnProcessId, this.version, this.processDefinitionKey, this.resourceName, this.checksum, value, this.resource);
    }

    public final ImmutableProcess withResource(byte ... elements) {
        byte[] newValue = elements == null ? null : (byte[])elements.clone();
        return new ImmutableProcess(this.bpmnProcessId, this.version, this.processDefinitionKey, this.resourceName, this.checksum, this.duplicate, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProcess && this.equalTo(0, (ImmutableProcess)another);
    }

    private boolean equalTo(int synthetic, ImmutableProcess another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.bpmnProcessId, another.bpmnProcessId) && this.version == another.version && this.processDefinitionKey == another.processDefinitionKey && Objects.equals(this.resourceName, another.resourceName) && Arrays.equals(this.checksum, another.checksum) && this.duplicate == another.duplicate && Arrays.equals(this.resource, another.resource);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.bpmnProcessId);
        h += (h << 5) + this.version;
        h += (h << 5) + Long.hashCode(this.processDefinitionKey);
        h += (h << 5) + Objects.hashCode(this.resourceName);
        h += (h << 5) + Arrays.hashCode(this.checksum);
        h += (h << 5) + Boolean.hashCode(this.duplicate);
        h += (h << 5) + Arrays.hashCode(this.resource);
        return h;
    }

    public String toString() {
        return "Process{bpmnProcessId=" + this.bpmnProcessId + ", version=" + this.version + ", processDefinitionKey=" + this.processDefinitionKey + ", resourceName=" + this.resourceName + ", checksum=" + Arrays.toString(this.checksum) + ", duplicate=" + this.duplicate + ", resource=" + Arrays.toString(this.resource) + "}";
    }

    public static ImmutableProcess copyOf(Process instance) {
        if (instance instanceof ImmutableProcess) {
            return (ImmutableProcess)instance;
        }
        return ImmutableProcess.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Process", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String bpmnProcessId;
        private int version;
        private long processDefinitionKey;
        @Nullable
        private String resourceName;
        @Nullable
        private byte[] checksum;
        private boolean duplicate;
        @Nullable
        private byte[] resource;

        private Builder() {
        }

        public final Builder from(Process instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ProcessMetadataValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ProcessMetadataValue instance;
            long bits = 0L;
            if (object instanceof Process) {
                instance = (Process)object;
                byte[] resourceValue = instance.getResource();
                if (resourceValue != null) {
                    this.withResource(resourceValue);
                }
                if ((bits & 1L) == 0L) {
                    byte[] checksumValue = instance.getChecksum();
                    if (checksumValue != null) {
                        this.withChecksum(checksumValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    String resourceNameValue = instance.getResourceName();
                    if (resourceNameValue != null) {
                        this.withResourceName(resourceNameValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    String bpmnProcessIdValue = instance.getBpmnProcessId();
                    if (bpmnProcessIdValue != null) {
                        this.withBpmnProcessId(bpmnProcessIdValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.withDuplicate(instance.isDuplicate());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.withVersion(instance.getVersion());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.withProcessDefinitionKey(instance.getProcessDefinitionKey());
                    bits |= 0x20L;
                }
            }
            if (object instanceof ProcessMetadataValue) {
                instance = (ProcessMetadataValue)object;
                if ((bits & 1L) == 0L) {
                    byte[] checksumValue = instance.getChecksum();
                    if (checksumValue != null) {
                        this.withChecksum(checksumValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    String resourceNameValue = instance.getResourceName();
                    if (resourceNameValue != null) {
                        this.withResourceName(resourceNameValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    String bpmnProcessIdValue = instance.getBpmnProcessId();
                    if (bpmnProcessIdValue != null) {
                        this.withBpmnProcessId(bpmnProcessIdValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.withDuplicate(instance.isDuplicate());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.withVersion(instance.getVersion());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.withProcessDefinitionKey(instance.getProcessDefinitionKey());
                    bits |= 0x20L;
                }
            }
        }

        public final Builder withBpmnProcessId(String bpmnProcessId) {
            this.bpmnProcessId = bpmnProcessId;
            return this;
        }

        public final Builder withVersion(int version) {
            this.version = version;
            return this;
        }

        public final Builder withProcessDefinitionKey(long processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
            return this;
        }

        public final Builder withResourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final Builder withChecksum(byte ... checksum) {
            this.checksum = checksum;
            return this;
        }

        public final Builder withDuplicate(boolean duplicate) {
            this.duplicate = duplicate;
            return this;
        }

        public final Builder withResource(byte ... resource) {
            this.resource = resource;
            return this;
        }

        public Builder clear() {
            this.bpmnProcessId = null;
            this.version = 0;
            this.processDefinitionKey = 0L;
            this.resourceName = null;
            this.checksum = null;
            this.duplicate = false;
            this.resource = null;
            return this;
        }

        public ImmutableProcess build() {
            return new ImmutableProcess(this.bpmnProcessId, this.version, this.processDefinitionKey, this.resourceName, this.checksum, this.duplicate, this.resource);
        }
    }
}

