/* Generated SBE (Simple Binary Encoding) message codec. */
package io.camunda.zeebe.protocol.record;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;
import org.agrona.sbe.*;


/**
 * Broker topology information
 */
@SuppressWarnings("all")
public final class BrokerInfoDecoder implements MessageDecoderFlyweight
{
    public static final int BLOCK_LENGTH = 16;
    public static final int TEMPLATE_ID = 201;
    public static final int SCHEMA_ID = 0;
    public static final int SCHEMA_VERSION = 3;
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final BrokerInfoDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public DirectBuffer buffer()
    {
        return buffer;
    }

    public int initialOffset()
    {
        return initialOffset;
    }

    public int offset()
    {
        return offset;
    }

    public BrokerInfoDecoder wrap(
        final DirectBuffer buffer,
        final int offset,
        final int actingBlockLength,
        final int actingVersion)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        limit(offset + actingBlockLength);

        return this;
    }

    public BrokerInfoDecoder wrapAndApplyHeader(
        final DirectBuffer buffer,
        final int offset,
        final MessageHeaderDecoder headerDecoder)
    {
        headerDecoder.wrap(buffer, offset);

        final int templateId = headerDecoder.templateId();
        if (TEMPLATE_ID != templateId)
        {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }

        return wrap(
            buffer,
            offset + MessageHeaderDecoder.ENCODED_LENGTH,
            headerDecoder.blockLength(),
            headerDecoder.version());
    }

    public BrokerInfoDecoder sbeRewind()
    {
        return wrap(buffer, initialOffset, actingBlockLength, actingVersion);
    }

    public int sbeDecodedLength()
    {
        final int currentLimit = limit();
        sbeSkip();
        final int decodedLength = encodedLength();
        limit(currentLimit);

        return decodedLength;
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int nodeIdId()
    {
        return 1;
    }

    public static int nodeIdSinceVersion()
    {
        return 0;
    }

    public static int nodeIdEncodingOffset()
    {
        return 0;
    }

    public static int nodeIdEncodingLength()
    {
        return 4;
    }

    public static String nodeIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int nodeIdNullValue()
    {
        return -2147483648;
    }

    public static int nodeIdMinValue()
    {
        return -2147483647;
    }

    public static int nodeIdMaxValue()
    {
        return 2147483647;
    }

    public int nodeId()
    {
        return buffer.getInt(offset + 0, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int partitionsCountId()
    {
        return 2;
    }

    public static int partitionsCountSinceVersion()
    {
        return 0;
    }

    public static int partitionsCountEncodingOffset()
    {
        return 4;
    }

    public static int partitionsCountEncodingLength()
    {
        return 4;
    }

    public static String partitionsCountMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int partitionsCountNullValue()
    {
        return -2147483648;
    }

    public static int partitionsCountMinValue()
    {
        return -2147483647;
    }

    public static int partitionsCountMaxValue()
    {
        return 2147483647;
    }

    public int partitionsCount()
    {
        return buffer.getInt(offset + 4, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int clusterSizeId()
    {
        return 3;
    }

    public static int clusterSizeSinceVersion()
    {
        return 0;
    }

    public static int clusterSizeEncodingOffset()
    {
        return 8;
    }

    public static int clusterSizeEncodingLength()
    {
        return 4;
    }

    public static String clusterSizeMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int clusterSizeNullValue()
    {
        return -2147483648;
    }

    public static int clusterSizeMinValue()
    {
        return -2147483647;
    }

    public static int clusterSizeMaxValue()
    {
        return 2147483647;
    }

    public int clusterSize()
    {
        return buffer.getInt(offset + 8, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int replicationFactorId()
    {
        return 4;
    }

    public static int replicationFactorSinceVersion()
    {
        return 0;
    }

    public static int replicationFactorEncodingOffset()
    {
        return 12;
    }

    public static int replicationFactorEncodingLength()
    {
        return 4;
    }

    public static String replicationFactorMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int replicationFactorNullValue()
    {
        return -2147483648;
    }

    public static int replicationFactorMinValue()
    {
        return -2147483647;
    }

    public static int replicationFactorMaxValue()
    {
        return 2147483647;
    }

    public int replicationFactor()
    {
        return buffer.getInt(offset + 12, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    private final AddressesDecoder addresses = new AddressesDecoder(this);

    public static long addressesDecoderId()
    {
        return 5;
    }

    public static int addressesDecoderSinceVersion()
    {
        return 0;
    }

    public AddressesDecoder addresses()
    {
        addresses.wrap(buffer);
        return addresses;
    }

    public static final class AddressesDecoder
        implements Iterable<AddressesDecoder>, java.util.Iterator<AddressesDecoder>
    {
        public static final int HEADER_SIZE = 3;
        private final BrokerInfoDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        AddressesDecoder(final BrokerInfoDecoder parentMessage)
        {
            this.parentMessage = parentMessage;
        }

        public void wrap(final DirectBuffer buffer)
        {
            if (buffer != this.buffer)
            {
                this.buffer = buffer;
            }

            index = 0;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + HEADER_SIZE);
            blockLength = (buffer.getShort(limit + 0, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF);
            count = ((short)(buffer.getByte(limit + 2) & 0xFF));
        }

        public AddressesDecoder next()
        {
            if (index >= count)
            {
                throw new java.util.NoSuchElementException();
            }

            offset = parentMessage.limit();
            parentMessage.limit(offset + blockLength);
            ++index;

            return this;
        }

        public static short countMinValue()
        {
            return (short)0;
        }

        public static short countMaxValue()
        {
            return (short)254;
        }

        public static int sbeHeaderSize()
        {
            return HEADER_SIZE;
        }

        public static int sbeBlockLength()
        {
            return 0;
        }

        public int actingBlockLength()
        {
            return blockLength;
        }

        public int count()
        {
            return count;
        }

        public java.util.Iterator<AddressesDecoder> iterator()
        {
            return this;
        }

        public void remove()
        {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext()
        {
            return index < count;
        }

        public static int apiNameId()
        {
            return 6;
        }

        public static int apiNameSinceVersion()
        {
            return 0;
        }

        public static String apiNameCharacterEncoding()
        {
            return java.nio.charset.StandardCharsets.UTF_8.name();
        }

        public static String apiNameMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int apiNameHeaderLength()
        {
            return 4;
        }

        public int apiNameLength()
        {
            final int limit = parentMessage.limit();
            return (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        }

        public int skipApiName()
        {
            final int headerLength = 4;
            final int limit = parentMessage.limit();
            final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
            final int dataOffset = limit + headerLength;
            parentMessage.limit(dataOffset + dataLength);

            return dataLength;
        }

        public int getApiName(final MutableDirectBuffer dst, final int dstOffset, final int length)
        {
            final int headerLength = 4;
            final int limit = parentMessage.limit();
            final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
            final int bytesCopied = Math.min(length, dataLength);
            parentMessage.limit(limit + headerLength + dataLength);
            buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

            return bytesCopied;
        }

        public int getApiName(final byte[] dst, final int dstOffset, final int length)
        {
            final int headerLength = 4;
            final int limit = parentMessage.limit();
            final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
            final int bytesCopied = Math.min(length, dataLength);
            parentMessage.limit(limit + headerLength + dataLength);
            buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

            return bytesCopied;
        }

        public void wrapApiName(final DirectBuffer wrapBuffer)
        {
            final int headerLength = 4;
            final int limit = parentMessage.limit();
            final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
            parentMessage.limit(limit + headerLength + dataLength);
            wrapBuffer.wrap(buffer, limit + headerLength, dataLength);
        }

        public String apiName()
        {
            final int headerLength = 4;
            final int limit = parentMessage.limit();
            final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
            parentMessage.limit(limit + headerLength + dataLength);

            if (0 == dataLength)
            {
                return "";
            }

            final byte[] tmp = new byte[dataLength];
            buffer.getBytes(limit + headerLength, tmp, 0, dataLength);

            return new String(tmp, java.nio.charset.StandardCharsets.UTF_8);
        }

        public static int addressId()
        {
            return 7;
        }

        public static int addressSinceVersion()
        {
            return 0;
        }

        public static String addressCharacterEncoding()
        {
            return java.nio.charset.StandardCharsets.UTF_8.name();
        }

        public static String addressMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int addressHeaderLength()
        {
            return 4;
        }

        public int addressLength()
        {
            final int limit = parentMessage.limit();
            return (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        }

        public int skipAddress()
        {
            final int headerLength = 4;
            final int limit = parentMessage.limit();
            final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
            final int dataOffset = limit + headerLength;
            parentMessage.limit(dataOffset + dataLength);

            return dataLength;
        }

        public int getAddress(final MutableDirectBuffer dst, final int dstOffset, final int length)
        {
            final int headerLength = 4;
            final int limit = parentMessage.limit();
            final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
            final int bytesCopied = Math.min(length, dataLength);
            parentMessage.limit(limit + headerLength + dataLength);
            buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

            return bytesCopied;
        }

        public int getAddress(final byte[] dst, final int dstOffset, final int length)
        {
            final int headerLength = 4;
            final int limit = parentMessage.limit();
            final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
            final int bytesCopied = Math.min(length, dataLength);
            parentMessage.limit(limit + headerLength + dataLength);
            buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

            return bytesCopied;
        }

        public void wrapAddress(final DirectBuffer wrapBuffer)
        {
            final int headerLength = 4;
            final int limit = parentMessage.limit();
            final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
            parentMessage.limit(limit + headerLength + dataLength);
            wrapBuffer.wrap(buffer, limit + headerLength, dataLength);
        }

        public String address()
        {
            final int headerLength = 4;
            final int limit = parentMessage.limit();
            final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
            parentMessage.limit(limit + headerLength + dataLength);

            if (0 == dataLength)
            {
                return "";
            }

            final byte[] tmp = new byte[dataLength];
            buffer.getBytes(limit + headerLength, tmp, 0, dataLength);

            return new String(tmp, java.nio.charset.StandardCharsets.UTF_8);
        }

        public StringBuilder appendTo(final StringBuilder builder)
        {
            if (null == buffer)
            {
                return builder;
            }

            builder.append('(');
            builder.append("apiName=");
            builder.append('\'').append(apiName()).append('\'');
            builder.append('|');
            builder.append("address=");
            builder.append('\'').append(address()).append('\'');
            builder.append(')');

            return builder;
        }
        
        public AddressesDecoder sbeSkip()
        {
            skipApiName();
            skipAddress();

            return this;
        }
    }

    private final PartitionRolesDecoder partitionRoles = new PartitionRolesDecoder(this);

    public static long partitionRolesDecoderId()
    {
        return 8;
    }

    public static int partitionRolesDecoderSinceVersion()
    {
        return 0;
    }

    public PartitionRolesDecoder partitionRoles()
    {
        partitionRoles.wrap(buffer);
        return partitionRoles;
    }

    public static final class PartitionRolesDecoder
        implements Iterable<PartitionRolesDecoder>, java.util.Iterator<PartitionRolesDecoder>
    {
        public static final int HEADER_SIZE = 3;
        private final BrokerInfoDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        PartitionRolesDecoder(final BrokerInfoDecoder parentMessage)
        {
            this.parentMessage = parentMessage;
        }

        public void wrap(final DirectBuffer buffer)
        {
            if (buffer != this.buffer)
            {
                this.buffer = buffer;
            }

            index = 0;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + HEADER_SIZE);
            blockLength = (buffer.getShort(limit + 0, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF);
            count = ((short)(buffer.getByte(limit + 2) & 0xFF));
        }

        public PartitionRolesDecoder next()
        {
            if (index >= count)
            {
                throw new java.util.NoSuchElementException();
            }

            offset = parentMessage.limit();
            parentMessage.limit(offset + blockLength);
            ++index;

            return this;
        }

        public static short countMinValue()
        {
            return (short)0;
        }

        public static short countMaxValue()
        {
            return (short)254;
        }

        public static int sbeHeaderSize()
        {
            return HEADER_SIZE;
        }

        public static int sbeBlockLength()
        {
            return 5;
        }

        public int actingBlockLength()
        {
            return blockLength;
        }

        public int count()
        {
            return count;
        }

        public java.util.Iterator<PartitionRolesDecoder> iterator()
        {
            return this;
        }

        public void remove()
        {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext()
        {
            return index < count;
        }

        public static int partitionIdId()
        {
            return 9;
        }

        public static int partitionIdSinceVersion()
        {
            return 0;
        }

        public static int partitionIdEncodingOffset()
        {
            return 0;
        }

        public static int partitionIdEncodingLength()
        {
            return 4;
        }

        public static String partitionIdMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int partitionIdNullValue()
        {
            return -2147483648;
        }

        public static int partitionIdMinValue()
        {
            return -2147483647;
        }

        public static int partitionIdMaxValue()
        {
            return 2147483647;
        }

        public int partitionId()
        {
            return buffer.getInt(offset + 0, java.nio.ByteOrder.LITTLE_ENDIAN);
        }


        public static int roleId()
        {
            return 10;
        }

        public static int roleSinceVersion()
        {
            return 0;
        }

        public static int roleEncodingOffset()
        {
            return 4;
        }

        public static int roleEncodingLength()
        {
            return 1;
        }

        public static String roleMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public short roleRaw()
        {
            return ((short)(buffer.getByte(offset + 4) & 0xFF));
        }

        public PartitionRole role()
        {
            return PartitionRole.get(((short)(buffer.getByte(offset + 4) & 0xFF)));
        }


        public StringBuilder appendTo(final StringBuilder builder)
        {
            if (null == buffer)
            {
                return builder;
            }

            builder.append('(');
            builder.append("partitionId=");
            builder.append(this.partitionId());
            builder.append('|');
            builder.append("role=");
            builder.append(this.role());
            builder.append(')');

            return builder;
        }
        
        public PartitionRolesDecoder sbeSkip()
        {

            return this;
        }
    }

    private final PartitionLeaderTermsDecoder partitionLeaderTerms = new PartitionLeaderTermsDecoder(this);

    public static long partitionLeaderTermsDecoderId()
    {
        return 11;
    }

    public static int partitionLeaderTermsDecoderSinceVersion()
    {
        return 0;
    }

    public PartitionLeaderTermsDecoder partitionLeaderTerms()
    {
        partitionLeaderTerms.wrap(buffer);
        return partitionLeaderTerms;
    }

    public static final class PartitionLeaderTermsDecoder
        implements Iterable<PartitionLeaderTermsDecoder>, java.util.Iterator<PartitionLeaderTermsDecoder>
    {
        public static final int HEADER_SIZE = 3;
        private final BrokerInfoDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        PartitionLeaderTermsDecoder(final BrokerInfoDecoder parentMessage)
        {
            this.parentMessage = parentMessage;
        }

        public void wrap(final DirectBuffer buffer)
        {
            if (buffer != this.buffer)
            {
                this.buffer = buffer;
            }

            index = 0;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + HEADER_SIZE);
            blockLength = (buffer.getShort(limit + 0, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF);
            count = ((short)(buffer.getByte(limit + 2) & 0xFF));
        }

        public PartitionLeaderTermsDecoder next()
        {
            if (index >= count)
            {
                throw new java.util.NoSuchElementException();
            }

            offset = parentMessage.limit();
            parentMessage.limit(offset + blockLength);
            ++index;

            return this;
        }

        public static short countMinValue()
        {
            return (short)0;
        }

        public static short countMaxValue()
        {
            return (short)254;
        }

        public static int sbeHeaderSize()
        {
            return HEADER_SIZE;
        }

        public static int sbeBlockLength()
        {
            return 12;
        }

        public int actingBlockLength()
        {
            return blockLength;
        }

        public int count()
        {
            return count;
        }

        public java.util.Iterator<PartitionLeaderTermsDecoder> iterator()
        {
            return this;
        }

        public void remove()
        {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext()
        {
            return index < count;
        }

        public static int partitionIdId()
        {
            return 12;
        }

        public static int partitionIdSinceVersion()
        {
            return 0;
        }

        public static int partitionIdEncodingOffset()
        {
            return 0;
        }

        public static int partitionIdEncodingLength()
        {
            return 4;
        }

        public static String partitionIdMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int partitionIdNullValue()
        {
            return -2147483648;
        }

        public static int partitionIdMinValue()
        {
            return -2147483647;
        }

        public static int partitionIdMaxValue()
        {
            return 2147483647;
        }

        public int partitionId()
        {
            return buffer.getInt(offset + 0, java.nio.ByteOrder.LITTLE_ENDIAN);
        }


        public static int termId()
        {
            return 13;
        }

        public static int termSinceVersion()
        {
            return 0;
        }

        public static int termEncodingOffset()
        {
            return 4;
        }

        public static int termEncodingLength()
        {
            return 8;
        }

        public static String termMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long termNullValue()
        {
            return -9223372036854775808L;
        }

        public static long termMinValue()
        {
            return -9223372036854775807L;
        }

        public static long termMaxValue()
        {
            return 9223372036854775807L;
        }

        public long term()
        {
            return buffer.getLong(offset + 4, java.nio.ByteOrder.LITTLE_ENDIAN);
        }


        public StringBuilder appendTo(final StringBuilder builder)
        {
            if (null == buffer)
            {
                return builder;
            }

            builder.append('(');
            builder.append("partitionId=");
            builder.append(this.partitionId());
            builder.append('|');
            builder.append("term=");
            builder.append(this.term());
            builder.append(')');

            return builder;
        }
        
        public PartitionLeaderTermsDecoder sbeSkip()
        {

            return this;
        }
    }

    private final PartitionHealthDecoder partitionHealth = new PartitionHealthDecoder(this);

    public static long partitionHealthDecoderId()
    {
        return 15;
    }

    public static int partitionHealthDecoderSinceVersion()
    {
        return 3;
    }

    public PartitionHealthDecoder partitionHealth()
    {
        if (parentMessage.actingVersion < 3)
        {
            partitionHealth.count = 0;
            partitionHealth.index = 0;
            return partitionHealth;
        }

        partitionHealth.wrap(buffer);
        return partitionHealth;
    }

    public static final class PartitionHealthDecoder
        implements Iterable<PartitionHealthDecoder>, java.util.Iterator<PartitionHealthDecoder>
    {
        public static final int HEADER_SIZE = 3;
        private final BrokerInfoDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        PartitionHealthDecoder(final BrokerInfoDecoder parentMessage)
        {
            this.parentMessage = parentMessage;
        }

        public void wrap(final DirectBuffer buffer)
        {
            if (buffer != this.buffer)
            {
                this.buffer = buffer;
            }

            index = 0;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + HEADER_SIZE);
            blockLength = (buffer.getShort(limit + 0, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF);
            count = ((short)(buffer.getByte(limit + 2) & 0xFF));
        }

        public PartitionHealthDecoder next()
        {
            if (index >= count)
            {
                throw new java.util.NoSuchElementException();
            }

            offset = parentMessage.limit();
            parentMessage.limit(offset + blockLength);
            ++index;

            return this;
        }

        public static short countMinValue()
        {
            return (short)0;
        }

        public static short countMaxValue()
        {
            return (short)254;
        }

        public static int sbeHeaderSize()
        {
            return HEADER_SIZE;
        }

        public static int sbeBlockLength()
        {
            return 5;
        }

        public int actingBlockLength()
        {
            return blockLength;
        }

        public int count()
        {
            return count;
        }

        public java.util.Iterator<PartitionHealthDecoder> iterator()
        {
            return this;
        }

        public void remove()
        {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext()
        {
            return index < count;
        }

        public static int partitionIdId()
        {
            return 16;
        }

        public static int partitionIdSinceVersion()
        {
            return 0;
        }

        public static int partitionIdEncodingOffset()
        {
            return 0;
        }

        public static int partitionIdEncodingLength()
        {
            return 4;
        }

        public static String partitionIdMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int partitionIdNullValue()
        {
            return -2147483648;
        }

        public static int partitionIdMinValue()
        {
            return -2147483647;
        }

        public static int partitionIdMaxValue()
        {
            return 2147483647;
        }

        public int partitionId()
        {
            return buffer.getInt(offset + 0, java.nio.ByteOrder.LITTLE_ENDIAN);
        }


        public static int healthStatusId()
        {
            return 17;
        }

        public static int healthStatusSinceVersion()
        {
            return 0;
        }

        public static int healthStatusEncodingOffset()
        {
            return 4;
        }

        public static int healthStatusEncodingLength()
        {
            return 1;
        }

        public static String healthStatusMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public short healthStatusRaw()
        {
            return ((short)(buffer.getByte(offset + 4) & 0xFF));
        }

        public PartitionHealthStatus healthStatus()
        {
            return PartitionHealthStatus.get(((short)(buffer.getByte(offset + 4) & 0xFF)));
        }


        public StringBuilder appendTo(final StringBuilder builder)
        {
            if (null == buffer)
            {
                return builder;
            }

            builder.append('(');
            builder.append("partitionId=");
            builder.append(this.partitionId());
            builder.append('|');
            builder.append("healthStatus=");
            builder.append(this.healthStatus());
            builder.append(')');

            return builder;
        }
        
        public PartitionHealthDecoder sbeSkip()
        {

            return this;
        }
    }

    public static int versionId()
    {
        return 14;
    }

    public static int versionSinceVersion()
    {
        return 0;
    }

    public static String versionCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.UTF_8.name();
    }

    public static String versionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int versionHeaderLength()
    {
        return 4;
    }

    public int versionLength()
    {
        final int limit = parentMessage.limit();
        return (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
    }

    public int skipVersion()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;
        parentMessage.limit(dataOffset + dataLength);

        return dataLength;
    }

    public int getVersion(final MutableDirectBuffer dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public int getVersion(final byte[] dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public void wrapVersion(final DirectBuffer wrapBuffer)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);
        wrapBuffer.wrap(buffer, limit + headerLength, dataLength);
    }

    public String version()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);

        if (0 == dataLength)
        {
            return "";
        }

        final byte[] tmp = new byte[dataLength];
        buffer.getBytes(limit + headerLength, tmp, 0, dataLength);

        return new String(tmp, java.nio.charset.StandardCharsets.UTF_8);
    }

    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        final BrokerInfoDecoder decoder = new BrokerInfoDecoder();
        decoder.wrap(buffer, initialOffset, actingBlockLength, actingVersion);

        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final int originalLimit = limit();
        limit(initialOffset + actingBlockLength);
        builder.append("[BrokerInfo](sbeTemplateId=");
        builder.append(TEMPLATE_ID);
        builder.append("|sbeSchemaId=");
        builder.append(SCHEMA_ID);
        builder.append("|sbeSchemaVersion=");
        if (parentMessage.actingVersion != SCHEMA_VERSION)
        {
            builder.append(parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(SCHEMA_VERSION);
        builder.append("|sbeBlockLength=");
        if (actingBlockLength != BLOCK_LENGTH)
        {
            builder.append(actingBlockLength);
            builder.append('/');
        }
        builder.append(BLOCK_LENGTH);
        builder.append("):");
        builder.append("nodeId=");
        builder.append(this.nodeId());
        builder.append('|');
        builder.append("partitionsCount=");
        builder.append(this.partitionsCount());
        builder.append('|');
        builder.append("clusterSize=");
        builder.append(this.clusterSize());
        builder.append('|');
        builder.append("replicationFactor=");
        builder.append(this.replicationFactor());
        builder.append('|');
        builder.append("addresses=[");
        final int addressesOriginalOffset = addresses.offset;
        final int addressesOriginalIndex = addresses.index;
        final AddressesDecoder addresses = this.addresses();
        if (addresses.count() > 0)
        {
            while (addresses.hasNext())
            {
                addresses.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        addresses.offset = addressesOriginalOffset;
        addresses.index = addressesOriginalIndex;
        builder.append(']');
        builder.append('|');
        builder.append("partitionRoles=[");
        final int partitionRolesOriginalOffset = partitionRoles.offset;
        final int partitionRolesOriginalIndex = partitionRoles.index;
        final PartitionRolesDecoder partitionRoles = this.partitionRoles();
        if (partitionRoles.count() > 0)
        {
            while (partitionRoles.hasNext())
            {
                partitionRoles.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        partitionRoles.offset = partitionRolesOriginalOffset;
        partitionRoles.index = partitionRolesOriginalIndex;
        builder.append(']');
        builder.append('|');
        builder.append("partitionLeaderTerms=[");
        final int partitionLeaderTermsOriginalOffset = partitionLeaderTerms.offset;
        final int partitionLeaderTermsOriginalIndex = partitionLeaderTerms.index;
        final PartitionLeaderTermsDecoder partitionLeaderTerms = this.partitionLeaderTerms();
        if (partitionLeaderTerms.count() > 0)
        {
            while (partitionLeaderTerms.hasNext())
            {
                partitionLeaderTerms.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        partitionLeaderTerms.offset = partitionLeaderTermsOriginalOffset;
        partitionLeaderTerms.index = partitionLeaderTermsOriginalIndex;
        builder.append(']');
        builder.append('|');
        builder.append("partitionHealth=[");
        final int partitionHealthOriginalOffset = partitionHealth.offset;
        final int partitionHealthOriginalIndex = partitionHealth.index;
        final PartitionHealthDecoder partitionHealth = this.partitionHealth();
        if (partitionHealth.count() > 0)
        {
            while (partitionHealth.hasNext())
            {
                partitionHealth.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        partitionHealth.offset = partitionHealthOriginalOffset;
        partitionHealth.index = partitionHealthOriginalIndex;
        builder.append(']');
        builder.append('|');
        builder.append("version=");
        builder.append('\'').append(version()).append('\'');

        limit(originalLimit);

        return builder;
    }
    
    public BrokerInfoDecoder sbeSkip()
    {
        sbeRewind();
        AddressesDecoder addresses = this.addresses();
        if (addresses.count() > 0)
        {
            while (addresses.hasNext())
            {
                addresses.next();
                addresses.sbeSkip();
            }
        }
        PartitionRolesDecoder partitionRoles = this.partitionRoles();
        if (partitionRoles.count() > 0)
        {
            while (partitionRoles.hasNext())
            {
                partitionRoles.next();
                partitionRoles.sbeSkip();
            }
        }
        PartitionLeaderTermsDecoder partitionLeaderTerms = this.partitionLeaderTerms();
        if (partitionLeaderTerms.count() > 0)
        {
            while (partitionLeaderTerms.hasNext())
            {
                partitionLeaderTerms.next();
                partitionLeaderTerms.sbeSkip();
            }
        }
        PartitionHealthDecoder partitionHealth = this.partitionHealth();
        if (partitionHealth.count() > 0)
        {
            while (partitionHealth.hasNext())
            {
                partitionHealth.next();
                partitionHealth.sbeSkip();
            }
        }
        skipVersion();

        return this;
    }
}
