package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JobBatchRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJobBatchRecordValue.builder()}.
 */
@Generated(from = "JobBatchRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Immutable
@ImmutableProtocol.Type(builder=ImmutableJobBatchRecordValue.Builder.class)
public final class ImmutableJobBatchRecordValue
    implements JobBatchRecordValue {
  private final String type;
  private final String worker;
  private final long timeout;
  private final int maxJobsToActivate;
  private final List<Long> jobKeys;
  private final List<JobRecordValue> jobs;
  private final boolean truncated;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableJobBatchRecordValue(
      String type,
      String worker,
      long timeout,
      int maxJobsToActivate,
      List<Long> jobKeys,
      List<JobRecordValue> jobs,
      boolean truncated) {
    this.type = type;
    this.worker = worker;
    this.timeout = timeout;
    this.maxJobsToActivate = maxJobsToActivate;
    this.jobKeys = jobKeys;
    this.jobs = jobs;
    this.truncated = truncated;
  }

  /**
   * @return the type of the job
   */
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return the assigned worker to complete the job
   */
  @Override
  public String getWorker() {
    return worker;
  }

  /**
   * @return the timeout (time span in milliseconds) for which a job is exclusively assigned to this
   *     worker. If the timeout is exceeded, it can happen that the job is handed to another worker
   *     and the work is performed twice.
   */
  @Override
  public long getTimeout() {
    return timeout;
  }

  /**
   * @return the number of jobs to handle
   */
  @Override
  public int getMaxJobsToActivate() {
    return maxJobsToActivate;
  }

  /**
   * @return list of the keys from the jobs assigned to this batch
   */
  @Override
  public List<Long> getJobKeys() {
    return jobKeys;
  }

  /**
   * @return the jobs assigned to this batch
   */
  @Override
  public List<JobRecordValue> getJobs() {
    return jobs;
  }

  /**
   * @return the broker has more JobRecords that couldn't fit in this batch
   */
  @Override
  public boolean isTruncated() {
    return truncated;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobBatchRecordValue#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobBatchRecordValue withType(String value) {
    if (Objects.equals(this.type, value)) return this;
    return new ImmutableJobBatchRecordValue(
        value,
        this.worker,
        this.timeout,
        this.maxJobsToActivate,
        this.jobKeys,
        this.jobs,
        this.truncated);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobBatchRecordValue#getWorker() worker} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for worker (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobBatchRecordValue withWorker(String value) {
    if (Objects.equals(this.worker, value)) return this;
    return new ImmutableJobBatchRecordValue(this.type, value, this.timeout, this.maxJobsToActivate, this.jobKeys, this.jobs, this.truncated);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobBatchRecordValue#getTimeout() timeout} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for timeout
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobBatchRecordValue withTimeout(long value) {
    if (this.timeout == value) return this;
    return new ImmutableJobBatchRecordValue(this.type, this.worker, value, this.maxJobsToActivate, this.jobKeys, this.jobs, this.truncated);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobBatchRecordValue#getMaxJobsToActivate() maxJobsToActivate} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maxJobsToActivate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobBatchRecordValue withMaxJobsToActivate(int value) {
    if (this.maxJobsToActivate == value) return this;
    return new ImmutableJobBatchRecordValue(this.type, this.worker, this.timeout, value, this.jobKeys, this.jobs, this.truncated);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JobBatchRecordValue#getJobKeys() jobKeys}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJobBatchRecordValue withJobKeys(Long... elements) {
    List<Long> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableJobBatchRecordValue(
        this.type,
        this.worker,
        this.timeout,
        this.maxJobsToActivate,
        newValue,
        this.jobs,
        this.truncated);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JobBatchRecordValue#getJobKeys() jobKeys}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of jobKeys elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJobBatchRecordValue withJobKeys(Iterable<? extends Long> elements) {
    if (this.jobKeys == elements) return this;
    List<Long> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableJobBatchRecordValue(
        this.type,
        this.worker,
        this.timeout,
        this.maxJobsToActivate,
        newValue,
        this.jobs,
        this.truncated);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JobBatchRecordValue#getJobs() jobs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJobBatchRecordValue withJobs(JobRecordValue... elements) {
    List<JobRecordValue> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableJobBatchRecordValue(
        this.type,
        this.worker,
        this.timeout,
        this.maxJobsToActivate,
        this.jobKeys,
        newValue,
        this.truncated);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JobBatchRecordValue#getJobs() jobs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of jobs elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJobBatchRecordValue withJobs(Iterable<? extends JobRecordValue> elements) {
    if (this.jobs == elements) return this;
    List<JobRecordValue> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableJobBatchRecordValue(
        this.type,
        this.worker,
        this.timeout,
        this.maxJobsToActivate,
        this.jobKeys,
        newValue,
        this.truncated);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobBatchRecordValue#isTruncated() truncated} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for truncated
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobBatchRecordValue withTruncated(boolean value) {
    if (this.truncated == value) return this;
    return new ImmutableJobBatchRecordValue(this.type, this.worker, this.timeout, this.maxJobsToActivate, this.jobKeys, this.jobs, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJobBatchRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJobBatchRecordValue
        && equalTo(0, (ImmutableJobBatchRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableJobBatchRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(type, another.type)
        && Objects.equals(worker, another.worker)
        && timeout == another.timeout
        && maxJobsToActivate == another.maxJobsToActivate
        && jobKeys.equals(another.jobKeys)
        && jobs.equals(another.jobs)
        && truncated == another.truncated;
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code type}, {@code worker}, {@code timeout}, {@code maxJobsToActivate}, {@code jobKeys}, {@code jobs}, {@code truncated}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(worker);
    h += (h << 5) + Long.hashCode(timeout);
    h += (h << 5) + maxJobsToActivate;
    h += (h << 5) + jobKeys.hashCode();
    h += (h << 5) + jobs.hashCode();
    h += (h << 5) + Boolean.hashCode(truncated);
    return h;
  }

  /**
   * Prints the immutable value {@code JobBatchRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "JobBatchRecordValue{"
        + "type=" + type
        + ", worker=" + worker
        + ", timeout=" + timeout
        + ", maxJobsToActivate=" + maxJobsToActivate
        + ", jobKeys=" + jobKeys
        + ", jobs=" + jobs
        + ", truncated=" + truncated
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link JobBatchRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JobBatchRecordValue instance
   */
  public static ImmutableJobBatchRecordValue copyOf(JobBatchRecordValue instance) {
    if (instance instanceof ImmutableJobBatchRecordValue) {
      return (ImmutableJobBatchRecordValue) instance;
    }
    return ImmutableJobBatchRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJobBatchRecordValue ImmutableJobBatchRecordValue}.
   * <pre>
   * ImmutableJobBatchRecordValue.builder()
   *    .withType(String | null) // nullable {@link JobBatchRecordValue#getType() type}
   *    .withWorker(String | null) // nullable {@link JobBatchRecordValue#getWorker() worker}
   *    .withTimeout(long) // optional {@link JobBatchRecordValue#getTimeout() timeout}
   *    .withMaxJobsToActivate(int) // optional {@link JobBatchRecordValue#getMaxJobsToActivate() maxJobsToActivate}
   *    .addJobKey|addAllJobKeys(Long) // {@link JobBatchRecordValue#getJobKeys() jobKeys} elements
   *    .addJob|addAllJobs(io.camunda.zeebe.protocol.record.value.JobRecordValue) // {@link JobBatchRecordValue#getJobs() jobs} elements
   *    .withTruncated(boolean) // optional {@link JobBatchRecordValue#isTruncated() truncated}
   *    .build();
   * </pre>
   * @return A new ImmutableJobBatchRecordValue builder
   */
  public static ImmutableJobBatchRecordValue.Builder builder() {
    return new ImmutableJobBatchRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJobBatchRecordValue ImmutableJobBatchRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JobBatchRecordValue", generator = "Immutables")
  @NotThreadSafe
  @ImmutableProtocol.Builder
  public static final class Builder {
    private @Nullable String type;
    private @Nullable String worker;
    private long timeout;
    private int maxJobsToActivate;
    private List<Long> jobKeys = new ArrayList<Long>();
    private List<ImmutableJobRecordValue.Builder> jobs = new ArrayList<ImmutableJobRecordValue.Builder>();
    private boolean truncated;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JobBatchRecordValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(JobBatchRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      String typeValue = instance.getType();
      if (typeValue != null) {
        withType(typeValue);
      }
      String workerValue = instance.getWorker();
      if (workerValue != null) {
        withWorker(workerValue);
      }
      withTimeout(instance.getTimeout());
      withMaxJobsToActivate(instance.getMaxJobsToActivate());
      addAllJobKeys(instance.getJobKeys());
      addAllJobs(instance.getJobs());
      withTruncated(instance.isTruncated());
      return this;
    }

    /**
     * Initializes the value for the {@link JobBatchRecordValue#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withType(String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link JobBatchRecordValue#getWorker() worker} attribute.
     * @param worker The value for worker (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withWorker(String worker) {
      this.worker = worker;
      return this;
    }

    /**
     * Initializes the value for the {@link JobBatchRecordValue#getTimeout() timeout} attribute.
     * @param timeout The value for timeout 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTimeout(long timeout) {
      this.timeout = timeout;
      return this;
    }

    /**
     * Initializes the value for the {@link JobBatchRecordValue#getMaxJobsToActivate() maxJobsToActivate} attribute.
     * @param maxJobsToActivate The value for maxJobsToActivate 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withMaxJobsToActivate(int maxJobsToActivate) {
      this.maxJobsToActivate = maxJobsToActivate;
      return this;
    }

    /**
     * Adds one element to {@link JobBatchRecordValue#getJobKeys() jobKeys} list.
     * @param element A jobKeys element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addJobKey(@Nullable Long element) {
      this.jobKeys.add(element);
      return this;
    }

    /**
     * Adds elements to {@link JobBatchRecordValue#getJobKeys() jobKeys} list.
     * @param elements An array of jobKeys elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addJobKeys(Long... elements) {
      for (Long element : elements) {
        this.jobKeys.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link JobBatchRecordValue#getJobKeys() jobKeys} list.
     * @param elements An iterable of jobKeys elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withJobKeys(Iterable<? extends Long> elements) {
      this.jobKeys.clear();
      return addAllJobKeys(elements);
    }

    /**
     * Adds elements to {@link JobBatchRecordValue#getJobKeys() jobKeys} list.
     * @param elements An iterable of jobKeys elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllJobKeys(Iterable<? extends Long> elements) {
      for (Long element : elements) {
        this.jobKeys.add(element);
      }
      return this;
    }

    /**
     * Adds one element to {@link JobBatchRecordValue#getJobs() jobs} list.
     * @param element A jobs element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addJob(@Nullable JobRecordValue element) {
      if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableJobRecordValue(element);
      this.jobs.add(ImmutableJobRecordValue.builder().from(element));
      return this;
    }

    /**
     * Adds elements to {@link JobBatchRecordValue#getJobs() jobs} list.
     * @param elements An array of jobs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addJobs(JobRecordValue... elements) {
      for (JobRecordValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableJobRecordValue(element);
        this.jobs.add(ImmutableJobRecordValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds a new builder to the {@link JobBatchRecordValue#getJobs() jobs} list and returns
     * the builder.
     */
    public final ImmutableJobRecordValue.Builder addJobBuilder() {
      ImmutableJobRecordValue.Builder builder = ImmutableJobRecordValue.builder();
      this.jobs.add(builder);
      return builder;
    }

    /**
     * Adds elements to {@link JobBatchRecordValue#getJobs() jobs} list.
     * @param elements An array of jobs builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllJobBuilders(ImmutableJobRecordValue.Builder... elements) {
      for (ImmutableJobRecordValue.Builder element : elements) {
        this.jobs.add(element);
      }
      return this;
    }

    /**
     * Gets the builder elements to {@link JobBatchRecordValue#getJobs() jobs} list.
     * @return {@code this} unmodifiable list of modifiable builders.
     */
    public final List<ImmutableJobRecordValue.Builder> jobBuilders() {
      return createUnmodifiableList(false, this.jobs);
    }

    /**
     * Sets or replaces all elements for {@link JobBatchRecordValue#getJobs() jobs} list.
     * @param elements An iterable of jobs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withJobs(Iterable<? extends JobRecordValue> elements) {
      this.jobs.clear();
      return addAllJobs(elements);
    }

    /**
     * Adds elements to {@link JobBatchRecordValue#getJobs() jobs} list.
     * @param elements An iterable of jobs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllJobs(Iterable<? extends JobRecordValue> elements) {
      for (JobRecordValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableJobRecordValue(element);
        this.jobs.add(ImmutableJobRecordValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds elements to {@link JobBatchRecordValue#getJobs() jobs} list.
     * @param elements An iterable of jobs builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllJobBuilders(Iterable<ImmutableJobRecordValue.Builder> elements) {
      for (ImmutableJobRecordValue.Builder element : elements) {
        this.jobs.add(element);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link JobBatchRecordValue#isTruncated() truncated} attribute.
     * @param truncated The value for truncated 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTruncated(boolean truncated) {
      this.truncated = truncated;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.type = null;
      this.worker = null;
      this.timeout = 0;
      this.maxJobsToActivate = 0;
      this.jobKeys.clear();
      this.jobs.clear();
      this.truncated = false;
      return this;
    }

    /**
     * Builds a new {@link ImmutableJobBatchRecordValue ImmutableJobBatchRecordValue}.
     * @return An immutable instance of JobBatchRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJobBatchRecordValue build() {
      return new ImmutableJobBatchRecordValue(
          type,
          worker,
          timeout,
          maxJobsToActivate,
          createUnmodifiableList(true, jobKeys),
          createUnmodifiableList(true, convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableJobRecordValue(jobs)),
          truncated);
    }



    @Nullable 
    private static ImmutableJobRecordValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableJobRecordValue(@Nullable  ImmutableJobRecordValue.Builder builder) {
      if (builder == null) return null;
      return builder.build();
    }

    @Nullable 
    private static JobRecordValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableJobRecordValue(@Nullable  JobRecordValue value) {
      if (value == null) return null;
      return ImmutableJobRecordValue.builder().from(value).build();
    }

    @Nullable 
    private static ImmutableJobRecordValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableJobRecordValue(@Nullable  JobRecordValue value) {
      if (value == null) return null;
      return ImmutableJobRecordValue.builder().from(value);
    }

    private static List<JobRecordValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableJobRecordValue(Iterable<? extends ImmutableJobRecordValue.Builder> builderList) {
      ArrayList<JobRecordValue> list;
      if (builderList instanceof Collection<?>) {
        int size = ((Collection<?>) builderList).size();
        if (size == 0) return Collections.emptyList();
      }
      list = new ArrayList<>();
      for (ImmutableJobRecordValue.Builder element : builderList) {
        list.add(element.build());
      }
      return list;
    }

    private static List<JobRecordValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableJobRecordValue(ImmutableJobRecordValue.Builder... builderArray) {
      ArrayList<JobRecordValue> list;
      if (builderArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>();
      for (ImmutableJobRecordValue.Builder element : builderArray) {
        list.add(element.build());
      }
      return list;
    }

    private static List<ImmutableJobRecordValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableJobRecordValue(Iterable<? extends ImmutableJobRecordValue> valueList) {
      ArrayList<ImmutableJobRecordValue.Builder> list;
      if (valueList instanceof Collection<?>) {
        int size = ((Collection<?>) valueList).size();
        if (size == 0) return Collections.emptyList();
      }
      list = new ArrayList<>();
      for (ImmutableJobRecordValue element : valueList) {
        list.add(ImmutableJobRecordValue.builder().from(element));
      }
      return list;
    }

    private static List<ImmutableJobRecordValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableJobRecordValue(ImmutableJobRecordValue... valueArray) {
      ArrayList<ImmutableJobRecordValue.Builder> list;
      if (valueArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>();
      for (ImmutableJobRecordValue element : valueArray) {
        list.add(ImmutableJobRecordValue.builder().from(element));
      }
      return list;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }



  @Nullable 
  private static ImmutableJobRecordValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableJobRecordValue(@Nullable  ImmutableJobRecordValue.Builder builder) {
    if (builder == null) return null;
    return builder.build();
  }

  @Nullable 
  private static JobRecordValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableJobRecordValue(@Nullable  JobRecordValue value) {
    if (value == null) return null;
    return ImmutableJobRecordValue.builder().from(value).build();
  }

  @Nullable 
  private static ImmutableJobRecordValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableJobRecordValue(@Nullable  JobRecordValue value) {
    if (value == null) return null;
    return ImmutableJobRecordValue.builder().from(value);
  }

  private static List<JobRecordValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableJobRecordValue(Iterable<? extends ImmutableJobRecordValue.Builder> builderList) {
    ArrayList<JobRecordValue> list;
    if (builderList instanceof Collection<?>) {
      int size = ((Collection<?>) builderList).size();
      if (size == 0) return Collections.emptyList();
    }
    list = new ArrayList<>();
    for (ImmutableJobRecordValue.Builder element : builderList) {
      list.add(element.build());
    }
    return list;
  }

  private static List<JobRecordValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableJobRecordValue(ImmutableJobRecordValue.Builder... builderArray) {
    ArrayList<JobRecordValue> list;
    if (builderArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>();
    for (ImmutableJobRecordValue.Builder element : builderArray) {
      list.add(element.build());
    }
    return list;
  }

  private static List<ImmutableJobRecordValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableJobRecordValue(Iterable<? extends ImmutableJobRecordValue> valueList) {
    ArrayList<ImmutableJobRecordValue.Builder> list;
    if (valueList instanceof Collection<?>) {
      int size = ((Collection<?>) valueList).size();
      if (size == 0) return Collections.emptyList();
    }
    list = new ArrayList<>();
    for (ImmutableJobRecordValue element : valueList) {
      list.add(ImmutableJobRecordValue.builder().from(element));
    }
    return list;
  }

  private static List<ImmutableJobRecordValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableJobRecordValue(ImmutableJobRecordValue... valueArray) {
    ArrayList<ImmutableJobRecordValue.Builder> list;
    if (valueArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>();
    for (ImmutableJobRecordValue element : valueArray) {
      list.add(ImmutableJobRecordValue.builder().from(element));
    }
    return list;
  }
}
