/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.value.EscalationRecordValue;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="EscalationRecordValue", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableEscalationRecordValue
implements EscalationRecordValue {
    private final long processInstanceKey;
    private final String escalationCode;
    private final String throwElementId;
    private final String catchElementId;
    private transient int hashCode;

    private ImmutableEscalationRecordValue(long processInstanceKey, String escalationCode, String throwElementId, String catchElementId) {
        this.processInstanceKey = processInstanceKey;
        this.escalationCode = escalationCode;
        this.throwElementId = throwElementId;
        this.catchElementId = catchElementId;
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public String getEscalationCode() {
        return this.escalationCode;
    }

    @Override
    public String getThrowElementId() {
        return this.throwElementId;
    }

    @Override
    public String getCatchElementId() {
        return this.catchElementId;
    }

    public final ImmutableEscalationRecordValue withProcessInstanceKey(long value) {
        if (this.processInstanceKey == value) {
            return this;
        }
        return new ImmutableEscalationRecordValue(value, this.escalationCode, this.throwElementId, this.catchElementId);
    }

    public final ImmutableEscalationRecordValue withEscalationCode(String value) {
        if (Objects.equals(this.escalationCode, value)) {
            return this;
        }
        return new ImmutableEscalationRecordValue(this.processInstanceKey, value, this.throwElementId, this.catchElementId);
    }

    public final ImmutableEscalationRecordValue withThrowElementId(String value) {
        if (Objects.equals(this.throwElementId, value)) {
            return this;
        }
        return new ImmutableEscalationRecordValue(this.processInstanceKey, this.escalationCode, value, this.catchElementId);
    }

    public final ImmutableEscalationRecordValue withCatchElementId(String value) {
        if (Objects.equals(this.catchElementId, value)) {
            return this;
        }
        return new ImmutableEscalationRecordValue(this.processInstanceKey, this.escalationCode, this.throwElementId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEscalationRecordValue && this.equalTo(0, (ImmutableEscalationRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableEscalationRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.processInstanceKey == another.processInstanceKey && Objects.equals(this.escalationCode, another.escalationCode) && Objects.equals(this.throwElementId, another.throwElementId) && Objects.equals(this.catchElementId, another.catchElementId);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.processInstanceKey);
        h += (h << 5) + Objects.hashCode(this.escalationCode);
        h += (h << 5) + Objects.hashCode(this.throwElementId);
        h += (h << 5) + Objects.hashCode(this.catchElementId);
        return h;
    }

    public String toString() {
        return "EscalationRecordValue{processInstanceKey=" + this.processInstanceKey + ", escalationCode=" + this.escalationCode + ", throwElementId=" + this.throwElementId + ", catchElementId=" + this.catchElementId + "}";
    }

    public static ImmutableEscalationRecordValue copyOf(EscalationRecordValue instance) {
        if (instance instanceof ImmutableEscalationRecordValue) {
            return (ImmutableEscalationRecordValue)instance;
        }
        return ImmutableEscalationRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ImmutableProtocol.Builder
    @Generated(from="EscalationRecordValue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private long processInstanceKey;
        @Nullable
        private String escalationCode;
        @Nullable
        private String throwElementId;
        @Nullable
        private String catchElementId;

        private Builder() {
        }

        public final Builder from(EscalationRecordValue instance) {
            String catchElementIdValue;
            String throwElementIdValue;
            Objects.requireNonNull(instance, "instance");
            this.withProcessInstanceKey(instance.getProcessInstanceKey());
            String escalationCodeValue = instance.getEscalationCode();
            if (escalationCodeValue != null) {
                this.withEscalationCode(escalationCodeValue);
            }
            if ((throwElementIdValue = instance.getThrowElementId()) != null) {
                this.withThrowElementId(throwElementIdValue);
            }
            if ((catchElementIdValue = instance.getCatchElementId()) != null) {
                this.withCatchElementId(catchElementIdValue);
            }
            return this;
        }

        public final Builder withProcessInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            return this;
        }

        public final Builder withEscalationCode(String escalationCode) {
            this.escalationCode = escalationCode;
            return this;
        }

        public final Builder withThrowElementId(String throwElementId) {
            this.throwElementId = throwElementId;
            return this;
        }

        public final Builder withCatchElementId(String catchElementId) {
            this.catchElementId = catchElementId;
            return this;
        }

        public Builder clear() {
            this.processInstanceKey = 0L;
            this.escalationCode = null;
            this.throwElementId = null;
            this.catchElementId = null;
            return this;
        }

        public ImmutableEscalationRecordValue build() {
            return new ImmutableEscalationRecordValue(this.processInstanceKey, this.escalationCode, this.throwElementId, this.catchElementId);
        }
    }
}

