/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.management;

import io.camunda.zeebe.protocol.management.BackupStatusCode;
import io.camunda.zeebe.protocol.management.MessageHeaderDecoder;
import io.camunda.zeebe.protocol.management.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class BackupListResponseDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 0;
    public static final int TEMPLATE_ID = 5;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final String SEMANTIC_VERSION = "8.2.25";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final BackupListResponseDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private final BackupsDecoder backups = new BackupsDecoder(this);

    public int sbeBlockLength() {
        return 0;
    }

    public int sbeTemplateId() {
        return 5;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public BackupListResponseDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public BackupListResponseDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (5 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public BackupListResponseDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static long backupsDecoderId() {
        return 1L;
    }

    public static int backupsDecoderSinceVersion() {
        return 0;
    }

    public BackupsDecoder backups() {
        this.backups.wrap(this.buffer);
        return this.backups;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        BackupListResponseDecoder decoder = new BackupListResponseDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[BackupListResponse](sbeTemplateId=");
        builder.append(5);
        builder.append("|sbeSchemaId=");
        builder.append(1);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 0) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(0);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 0) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(0);
        builder.append("):");
        builder.append("backups=[");
        int backupsOriginalOffset = this.backups.offset;
        int backupsOriginalIndex = this.backups.index;
        BackupsDecoder backups = this.backups();
        if (backups.count() > 0) {
            while (backups.hasNext()) {
                backups.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        backups.offset = backupsOriginalOffset;
        backups.index = backupsOriginalIndex;
        builder.append(']');
        this.limit(originalLimit);
        return builder;
    }

    public BackupListResponseDecoder sbeSkip() {
        this.sbeRewind();
        BackupsDecoder backups = this.backups();
        if (backups.count() > 0) {
            while (backups.hasNext()) {
                backups.next();
                backups.sbeSkip();
            }
        }
        return this;
    }

    public static final class BackupsDecoder
    implements Iterable<BackupsDecoder>,
    Iterator<BackupsDecoder> {
        public static final int HEADER_SIZE = 8;
        private final BackupListResponseDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        BackupsDecoder(BackupListResponseDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 8);
            this.blockLength = buffer.getShort(limit + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.count = buffer.getShort(limit + 2, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        }

        @Override
        public BackupsDecoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static int countMinValue() {
            return 0;
        }

        public static int countMaxValue() {
            return 65534;
        }

        public static int sbeHeaderSize() {
            return 8;
        }

        public static int sbeBlockLength() {
            return 11;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<BackupsDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public static int backupIdId() {
            return 1;
        }

        public static int backupIdSinceVersion() {
            return 0;
        }

        public static int backupIdEncodingOffset() {
            return 0;
        }

        public static int backupIdEncodingLength() {
            return 8;
        }

        public static String backupIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long backupIdNullValue() {
            return Long.MIN_VALUE;
        }

        public static long backupIdMinValue() {
            return -9223372036854775807L;
        }

        public static long backupIdMaxValue() {
            return Long.MAX_VALUE;
        }

        public long backupId() {
            return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
        }

        public static int statusId() {
            return 2;
        }

        public static int statusSinceVersion() {
            return 0;
        }

        public static int statusEncodingOffset() {
            return 8;
        }

        public static int statusEncodingLength() {
            return 1;
        }

        public static String statusMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public short statusRaw() {
            return (short)(this.buffer.getByte(this.offset + 8) & 0xFF);
        }

        public BackupStatusCode status() {
            return BackupStatusCode.get((short)(this.buffer.getByte(this.offset + 8) & 0xFF));
        }

        public static int partitionIdId() {
            return 3;
        }

        public static int partitionIdSinceVersion() {
            return 0;
        }

        public static int partitionIdEncodingOffset() {
            return 9;
        }

        public static int partitionIdEncodingLength() {
            return 2;
        }

        public static String partitionIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int partitionIdNullValue() {
            return 65535;
        }

        public static int partitionIdMinValue() {
            return 0;
        }

        public static int partitionIdMaxValue() {
            return 65534;
        }

        public int partitionId() {
            return this.buffer.getShort(this.offset + 9, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        }

        public static int failureReasonId() {
            return 8;
        }

        public static int failureReasonSinceVersion() {
            return 0;
        }

        public static String failureReasonCharacterEncoding() {
            return StandardCharsets.UTF_8.name();
        }

        public static String failureReasonMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int failureReasonHeaderLength() {
            return 4;
        }

        public int failureReasonLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        }

        public int skipFailureReason() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getFailureReason(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getFailureReason(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapFailureReason(DirectBuffer wrapBuffer) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
        }

        public String failureReason() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            return new String(tmp, StandardCharsets.UTF_8);
        }

        public static int createdAtId() {
            return 9;
        }

        public static int createdAtSinceVersion() {
            return 0;
        }

        public static String createdAtCharacterEncoding() {
            return StandardCharsets.UTF_8.name();
        }

        public static String createdAtMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int createdAtHeaderLength() {
            return 4;
        }

        public int createdAtLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        }

        public int skipCreatedAt() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getCreatedAt(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getCreatedAt(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapCreatedAt(DirectBuffer wrapBuffer) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
        }

        public String createdAt() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            return new String(tmp, StandardCharsets.UTF_8);
        }

        public static int brokerVersionId() {
            return 11;
        }

        public static int brokerVersionSinceVersion() {
            return 0;
        }

        public static String brokerVersionCharacterEncoding() {
            return StandardCharsets.UTF_8.name();
        }

        public static String brokerVersionMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int brokerVersionHeaderLength() {
            return 4;
        }

        public int brokerVersionLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        }

        public int skipBrokerVersion() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getBrokerVersion(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getBrokerVersion(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapBrokerVersion(DirectBuffer wrapBuffer) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
        }

        public String brokerVersion() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            return new String(tmp, StandardCharsets.UTF_8);
        }

        public StringBuilder appendTo(StringBuilder builder) {
            if (null == this.buffer) {
                return builder;
            }
            builder.append('(');
            builder.append("backupId=");
            builder.append(this.backupId());
            builder.append('|');
            builder.append("status=");
            builder.append((Object)this.status());
            builder.append('|');
            builder.append("partitionId=");
            builder.append(this.partitionId());
            builder.append('|');
            builder.append("failureReason=");
            builder.append('\'').append(this.failureReason()).append('\'');
            builder.append('|');
            builder.append("createdAt=");
            builder.append('\'').append(this.createdAt()).append('\'');
            builder.append('|');
            builder.append("brokerVersion=");
            builder.append('\'').append(this.brokerVersion()).append('\'');
            builder.append(')');
            return builder;
        }

        public BackupsDecoder sbeSkip() {
            this.skipFailureReason();
            this.skipCreatedAt();
            this.skipBrokerVersion();
            return this;
        }
    }
}

