/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.value.CommandDistributionRecordValue;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="CommandDistributionRecordValue", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableCommandDistributionRecordValue
implements CommandDistributionRecordValue {
    private final int partitionId;
    private final ValueType valueType;
    private final RecordValue commandValue;
    private transient int hashCode;

    private ImmutableCommandDistributionRecordValue(int partitionId, ValueType valueType, RecordValue commandValue) {
        this.partitionId = partitionId;
        this.valueType = valueType;
        this.commandValue = commandValue;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public ValueType getValueType() {
        return this.valueType;
    }

    @Override
    public RecordValue getCommandValue() {
        return this.commandValue;
    }

    public final ImmutableCommandDistributionRecordValue withPartitionId(int value) {
        if (this.partitionId == value) {
            return this;
        }
        return new ImmutableCommandDistributionRecordValue(value, this.valueType, this.commandValue);
    }

    public final ImmutableCommandDistributionRecordValue withValueType(ValueType value) {
        if (this.valueType == value) {
            return this;
        }
        return new ImmutableCommandDistributionRecordValue(this.partitionId, value, this.commandValue);
    }

    public final ImmutableCommandDistributionRecordValue withCommandValue(RecordValue value) {
        if (this.commandValue == value) {
            return this;
        }
        return new ImmutableCommandDistributionRecordValue(this.partitionId, this.valueType, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommandDistributionRecordValue && this.equalTo(0, (ImmutableCommandDistributionRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableCommandDistributionRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.partitionId == another.partitionId && Objects.equals((Object)this.valueType, (Object)another.valueType) && Objects.equals(this.commandValue, another.commandValue);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.partitionId;
        h += (h << 5) + Objects.hashCode((Object)this.valueType);
        h += (h << 5) + Objects.hashCode(this.commandValue);
        return h;
    }

    public String toString() {
        return "CommandDistributionRecordValue{partitionId=" + this.partitionId + ", valueType=" + (Object)((Object)this.valueType) + ", commandValue=" + this.commandValue + "}";
    }

    public static ImmutableCommandDistributionRecordValue copyOf(CommandDistributionRecordValue instance) {
        if (instance instanceof ImmutableCommandDistributionRecordValue) {
            return (ImmutableCommandDistributionRecordValue)instance;
        }
        return ImmutableCommandDistributionRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ImmutableProtocol.Builder
    @Generated(from="CommandDistributionRecordValue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private int partitionId;
        @Nullable
        private ValueType valueType;
        @Nullable
        private RecordValue commandValue;

        private Builder() {
        }

        public final Builder from(CommandDistributionRecordValue instance) {
            RecordValue commandValueValue;
            Objects.requireNonNull(instance, "instance");
            this.withPartitionId(instance.getPartitionId());
            ValueType valueTypeValue = instance.getValueType();
            if (valueTypeValue != null) {
                this.withValueType(valueTypeValue);
            }
            if ((commandValueValue = instance.getCommandValue()) != null) {
                this.withCommandValue(commandValueValue);
            }
            return this;
        }

        public final Builder withPartitionId(int partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        public final Builder withValueType(ValueType valueType) {
            this.valueType = valueType;
            return this;
        }

        public final Builder withCommandValue(RecordValue commandValue) {
            this.commandValue = commandValue;
            return this;
        }

        public Builder clear() {
            this.partitionId = 0;
            this.valueType = null;
            this.commandValue = null;
            return this;
        }

        public ImmutableCommandDistributionRecordValue build() {
            return new ImmutableCommandDistributionRecordValue(this.partitionId, this.valueType, this.commandValue);
        }
    }
}

