/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import io.camunda.zeebe.protocol.record.value.TimerRecordValue;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="TimerRecordValue", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableTimerRecordValue
implements TimerRecordValue {
    private final long processDefinitionKey;
    private final long elementInstanceKey;
    private final long processInstanceKey;
    private final long dueDate;
    private final String targetElementId;
    private final int repetitions;
    private transient int hashCode;

    private ImmutableTimerRecordValue(long processDefinitionKey, long elementInstanceKey, long processInstanceKey, long dueDate, String targetElementId, int repetitions) {
        this.processDefinitionKey = processDefinitionKey;
        this.elementInstanceKey = elementInstanceKey;
        this.processInstanceKey = processInstanceKey;
        this.dueDate = dueDate;
        this.targetElementId = targetElementId;
        this.repetitions = repetitions;
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public long getDueDate() {
        return this.dueDate;
    }

    @Override
    public String getTargetElementId() {
        return this.targetElementId;
    }

    @Override
    public int getRepetitions() {
        return this.repetitions;
    }

    public final ImmutableTimerRecordValue withProcessDefinitionKey(long value) {
        if (this.processDefinitionKey == value) {
            return this;
        }
        return new ImmutableTimerRecordValue(value, this.elementInstanceKey, this.processInstanceKey, this.dueDate, this.targetElementId, this.repetitions);
    }

    public final ImmutableTimerRecordValue withElementInstanceKey(long value) {
        if (this.elementInstanceKey == value) {
            return this;
        }
        return new ImmutableTimerRecordValue(this.processDefinitionKey, value, this.processInstanceKey, this.dueDate, this.targetElementId, this.repetitions);
    }

    public final ImmutableTimerRecordValue withProcessInstanceKey(long value) {
        if (this.processInstanceKey == value) {
            return this;
        }
        return new ImmutableTimerRecordValue(this.processDefinitionKey, this.elementInstanceKey, value, this.dueDate, this.targetElementId, this.repetitions);
    }

    public final ImmutableTimerRecordValue withDueDate(long value) {
        if (this.dueDate == value) {
            return this;
        }
        return new ImmutableTimerRecordValue(this.processDefinitionKey, this.elementInstanceKey, this.processInstanceKey, value, this.targetElementId, this.repetitions);
    }

    public final ImmutableTimerRecordValue withTargetElementId(String value) {
        if (Objects.equals(this.targetElementId, value)) {
            return this;
        }
        return new ImmutableTimerRecordValue(this.processDefinitionKey, this.elementInstanceKey, this.processInstanceKey, this.dueDate, value, this.repetitions);
    }

    public final ImmutableTimerRecordValue withRepetitions(int value) {
        if (this.repetitions == value) {
            return this;
        }
        return new ImmutableTimerRecordValue(this.processDefinitionKey, this.elementInstanceKey, this.processInstanceKey, this.dueDate, this.targetElementId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTimerRecordValue && this.equalTo(0, (ImmutableTimerRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableTimerRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.processDefinitionKey == another.processDefinitionKey && this.elementInstanceKey == another.elementInstanceKey && this.processInstanceKey == another.processInstanceKey && this.dueDate == another.dueDate && Objects.equals(this.targetElementId, another.targetElementId) && this.repetitions == another.repetitions;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.processDefinitionKey);
        h += (h << 5) + Long.hashCode(this.elementInstanceKey);
        h += (h << 5) + Long.hashCode(this.processInstanceKey);
        h += (h << 5) + Long.hashCode(this.dueDate);
        h += (h << 5) + Objects.hashCode(this.targetElementId);
        h += (h << 5) + this.repetitions;
        return h;
    }

    public String toString() {
        return "TimerRecordValue{processDefinitionKey=" + this.processDefinitionKey + ", elementInstanceKey=" + this.elementInstanceKey + ", processInstanceKey=" + this.processInstanceKey + ", dueDate=" + this.dueDate + ", targetElementId=" + this.targetElementId + ", repetitions=" + this.repetitions + "}";
    }

    public static ImmutableTimerRecordValue copyOf(TimerRecordValue instance) {
        if (instance instanceof ImmutableTimerRecordValue) {
            return (ImmutableTimerRecordValue)instance;
        }
        return ImmutableTimerRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ImmutableProtocol.Builder
    @Generated(from="TimerRecordValue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private long processDefinitionKey;
        private long elementInstanceKey;
        private long processInstanceKey;
        private long dueDate;
        @Nullable
        private String targetElementId;
        private int repetitions;

        private Builder() {
        }

        public final Builder from(ProcessInstanceRelated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TimerRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ProcessInstanceRelated instance;
            long bits = 0L;
            if (object instanceof ProcessInstanceRelated) {
                instance = (ProcessInstanceRelated)object;
                if ((bits & 1L) == 0L) {
                    this.withProcessInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
            }
            if (object instanceof TimerRecordValue) {
                instance = (TimerRecordValue)object;
                if ((bits & 1L) == 0L) {
                    this.withProcessInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
                this.withElementInstanceKey(instance.getElementInstanceKey());
                String targetElementIdValue = instance.getTargetElementId();
                if (targetElementIdValue != null) {
                    this.withTargetElementId(targetElementIdValue);
                }
                this.withRepetitions(instance.getRepetitions());
                this.withDueDate(instance.getDueDate());
                this.withProcessDefinitionKey(instance.getProcessDefinitionKey());
            }
        }

        public final Builder withProcessDefinitionKey(long processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
            return this;
        }

        public final Builder withElementInstanceKey(long elementInstanceKey) {
            this.elementInstanceKey = elementInstanceKey;
            return this;
        }

        public final Builder withProcessInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            return this;
        }

        public final Builder withDueDate(long dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        public final Builder withTargetElementId(String targetElementId) {
            this.targetElementId = targetElementId;
            return this;
        }

        public final Builder withRepetitions(int repetitions) {
            this.repetitions = repetitions;
            return this;
        }

        public Builder clear() {
            this.processDefinitionKey = 0L;
            this.elementInstanceKey = 0L;
            this.processInstanceKey = 0L;
            this.dueDate = 0L;
            this.targetElementId = null;
            this.repetitions = 0;
            return this;
        }

        public ImmutableTimerRecordValue build() {
            return new ImmutableTimerRecordValue(this.processDefinitionKey, this.elementInstanceKey, this.processInstanceKey, this.dueDate, this.targetElementId, this.repetitions);
        }
    }
}

