/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.RecordValueWithVariables;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import io.camunda.zeebe.protocol.record.value.TenantOwned;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="JobRecordValue", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableJobRecordValue
implements JobRecordValue {
    private final Map<String, Object> variables;
    private final long processInstanceKey;
    private final String tenantId;
    private final String type;
    private final Map<String, String> customHeaders;
    private final String worker;
    private final int retries;
    private final long retryBackoff;
    private final long recurringTime;
    private final long deadline;
    private final String errorMessage;
    private final String errorCode;
    private final String elementId;
    private final long elementInstanceKey;
    private final String bpmnProcessId;
    private final int processDefinitionVersion;
    private final long processDefinitionKey;
    private transient int hashCode;

    private ImmutableJobRecordValue(Map<String, Object> variables, long processInstanceKey, String tenantId, String type, Map<String, String> customHeaders, String worker, int retries, long retryBackoff, long recurringTime, long deadline, String errorMessage, String errorCode, String elementId, long elementInstanceKey, String bpmnProcessId, int processDefinitionVersion, long processDefinitionKey) {
        this.variables = variables;
        this.processInstanceKey = processInstanceKey;
        this.tenantId = tenantId;
        this.type = type;
        this.customHeaders = customHeaders;
        this.worker = worker;
        this.retries = retries;
        this.retryBackoff = retryBackoff;
        this.recurringTime = recurringTime;
        this.deadline = deadline;
        this.errorMessage = errorMessage;
        this.errorCode = errorCode;
        this.elementId = elementId;
        this.elementInstanceKey = elementInstanceKey;
        this.bpmnProcessId = bpmnProcessId;
        this.processDefinitionVersion = processDefinitionVersion;
        this.processDefinitionKey = processDefinitionKey;
    }

    @Override
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    @Override
    public String getWorker() {
        return this.worker;
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    @Override
    public long getRetryBackoff() {
        return this.retryBackoff;
    }

    @Override
    public long getRecurringTime() {
        return this.recurringTime;
    }

    @Override
    public long getDeadline() {
        return this.deadline;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }

    @Override
    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    @Override
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    @Override
    public int getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public final ImmutableJobRecordValue withVariables(Map<String, ? extends Object> entries) {
        if (this.variables == entries) {
            return this;
        }
        Map<String, Object> newValue = ImmutableJobRecordValue.createUnmodifiableMap(false, false, entries);
        return new ImmutableJobRecordValue(newValue, this.processInstanceKey, this.tenantId, this.type, this.customHeaders, this.worker, this.retries, this.retryBackoff, this.recurringTime, this.deadline, this.errorMessage, this.errorCode, this.elementId, this.elementInstanceKey, this.bpmnProcessId, this.processDefinitionVersion, this.processDefinitionKey);
    }

    public final ImmutableJobRecordValue withProcessInstanceKey(long value) {
        if (this.processInstanceKey == value) {
            return this;
        }
        return new ImmutableJobRecordValue(this.variables, value, this.tenantId, this.type, this.customHeaders, this.worker, this.retries, this.retryBackoff, this.recurringTime, this.deadline, this.errorMessage, this.errorCode, this.elementId, this.elementInstanceKey, this.bpmnProcessId, this.processDefinitionVersion, this.processDefinitionKey);
    }

    public final ImmutableJobRecordValue withTenantId(String value) {
        if (Objects.equals(this.tenantId, value)) {
            return this;
        }
        return new ImmutableJobRecordValue(this.variables, this.processInstanceKey, value, this.type, this.customHeaders, this.worker, this.retries, this.retryBackoff, this.recurringTime, this.deadline, this.errorMessage, this.errorCode, this.elementId, this.elementInstanceKey, this.bpmnProcessId, this.processDefinitionVersion, this.processDefinitionKey);
    }

    public final ImmutableJobRecordValue withType(String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return new ImmutableJobRecordValue(this.variables, this.processInstanceKey, this.tenantId, value, this.customHeaders, this.worker, this.retries, this.retryBackoff, this.recurringTime, this.deadline, this.errorMessage, this.errorCode, this.elementId, this.elementInstanceKey, this.bpmnProcessId, this.processDefinitionVersion, this.processDefinitionKey);
    }

    public final ImmutableJobRecordValue withCustomHeaders(Map<String, ? extends String> entries) {
        if (this.customHeaders == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableJobRecordValue.createUnmodifiableMap(false, false, entries);
        return new ImmutableJobRecordValue(this.variables, this.processInstanceKey, this.tenantId, this.type, newValue, this.worker, this.retries, this.retryBackoff, this.recurringTime, this.deadline, this.errorMessage, this.errorCode, this.elementId, this.elementInstanceKey, this.bpmnProcessId, this.processDefinitionVersion, this.processDefinitionKey);
    }

    public final ImmutableJobRecordValue withWorker(String value) {
        if (Objects.equals(this.worker, value)) {
            return this;
        }
        return new ImmutableJobRecordValue(this.variables, this.processInstanceKey, this.tenantId, this.type, this.customHeaders, value, this.retries, this.retryBackoff, this.recurringTime, this.deadline, this.errorMessage, this.errorCode, this.elementId, this.elementInstanceKey, this.bpmnProcessId, this.processDefinitionVersion, this.processDefinitionKey);
    }

    public final ImmutableJobRecordValue withRetries(int value) {
        if (this.retries == value) {
            return this;
        }
        return new ImmutableJobRecordValue(this.variables, this.processInstanceKey, this.tenantId, this.type, this.customHeaders, this.worker, value, this.retryBackoff, this.recurringTime, this.deadline, this.errorMessage, this.errorCode, this.elementId, this.elementInstanceKey, this.bpmnProcessId, this.processDefinitionVersion, this.processDefinitionKey);
    }

    public final ImmutableJobRecordValue withRetryBackoff(long value) {
        if (this.retryBackoff == value) {
            return this;
        }
        return new ImmutableJobRecordValue(this.variables, this.processInstanceKey, this.tenantId, this.type, this.customHeaders, this.worker, this.retries, value, this.recurringTime, this.deadline, this.errorMessage, this.errorCode, this.elementId, this.elementInstanceKey, this.bpmnProcessId, this.processDefinitionVersion, this.processDefinitionKey);
    }

    public final ImmutableJobRecordValue withRecurringTime(long value) {
        if (this.recurringTime == value) {
            return this;
        }
        return new ImmutableJobRecordValue(this.variables, this.processInstanceKey, this.tenantId, this.type, this.customHeaders, this.worker, this.retries, this.retryBackoff, value, this.deadline, this.errorMessage, this.errorCode, this.elementId, this.elementInstanceKey, this.bpmnProcessId, this.processDefinitionVersion, this.processDefinitionKey);
    }

    public final ImmutableJobRecordValue withDeadline(long value) {
        if (this.deadline == value) {
            return this;
        }
        return new ImmutableJobRecordValue(this.variables, this.processInstanceKey, this.tenantId, this.type, this.customHeaders, this.worker, this.retries, this.retryBackoff, this.recurringTime, value, this.errorMessage, this.errorCode, this.elementId, this.elementInstanceKey, this.bpmnProcessId, this.processDefinitionVersion, this.processDefinitionKey);
    }

    public final ImmutableJobRecordValue withErrorMessage(String value) {
        if (Objects.equals(this.errorMessage, value)) {
            return this;
        }
        return new ImmutableJobRecordValue(this.variables, this.processInstanceKey, this.tenantId, this.type, this.customHeaders, this.worker, this.retries, this.retryBackoff, this.recurringTime, this.deadline, value, this.errorCode, this.elementId, this.elementInstanceKey, this.bpmnProcessId, this.processDefinitionVersion, this.processDefinitionKey);
    }

    public final ImmutableJobRecordValue withErrorCode(String value) {
        if (Objects.equals(this.errorCode, value)) {
            return this;
        }
        return new ImmutableJobRecordValue(this.variables, this.processInstanceKey, this.tenantId, this.type, this.customHeaders, this.worker, this.retries, this.retryBackoff, this.recurringTime, this.deadline, this.errorMessage, value, this.elementId, this.elementInstanceKey, this.bpmnProcessId, this.processDefinitionVersion, this.processDefinitionKey);
    }

    public final ImmutableJobRecordValue withElementId(String value) {
        if (Objects.equals(this.elementId, value)) {
            return this;
        }
        return new ImmutableJobRecordValue(this.variables, this.processInstanceKey, this.tenantId, this.type, this.customHeaders, this.worker, this.retries, this.retryBackoff, this.recurringTime, this.deadline, this.errorMessage, this.errorCode, value, this.elementInstanceKey, this.bpmnProcessId, this.processDefinitionVersion, this.processDefinitionKey);
    }

    public final ImmutableJobRecordValue withElementInstanceKey(long value) {
        if (this.elementInstanceKey == value) {
            return this;
        }
        return new ImmutableJobRecordValue(this.variables, this.processInstanceKey, this.tenantId, this.type, this.customHeaders, this.worker, this.retries, this.retryBackoff, this.recurringTime, this.deadline, this.errorMessage, this.errorCode, this.elementId, value, this.bpmnProcessId, this.processDefinitionVersion, this.processDefinitionKey);
    }

    public final ImmutableJobRecordValue withBpmnProcessId(String value) {
        if (Objects.equals(this.bpmnProcessId, value)) {
            return this;
        }
        return new ImmutableJobRecordValue(this.variables, this.processInstanceKey, this.tenantId, this.type, this.customHeaders, this.worker, this.retries, this.retryBackoff, this.recurringTime, this.deadline, this.errorMessage, this.errorCode, this.elementId, this.elementInstanceKey, value, this.processDefinitionVersion, this.processDefinitionKey);
    }

    public final ImmutableJobRecordValue withProcessDefinitionVersion(int value) {
        if (this.processDefinitionVersion == value) {
            return this;
        }
        return new ImmutableJobRecordValue(this.variables, this.processInstanceKey, this.tenantId, this.type, this.customHeaders, this.worker, this.retries, this.retryBackoff, this.recurringTime, this.deadline, this.errorMessage, this.errorCode, this.elementId, this.elementInstanceKey, this.bpmnProcessId, value, this.processDefinitionKey);
    }

    public final ImmutableJobRecordValue withProcessDefinitionKey(long value) {
        if (this.processDefinitionKey == value) {
            return this;
        }
        return new ImmutableJobRecordValue(this.variables, this.processInstanceKey, this.tenantId, this.type, this.customHeaders, this.worker, this.retries, this.retryBackoff, this.recurringTime, this.deadline, this.errorMessage, this.errorCode, this.elementId, this.elementInstanceKey, this.bpmnProcessId, this.processDefinitionVersion, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJobRecordValue && this.equalTo(0, (ImmutableJobRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableJobRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.variables.equals(another.variables) && this.processInstanceKey == another.processInstanceKey && Objects.equals(this.tenantId, another.tenantId) && Objects.equals(this.type, another.type) && this.customHeaders.equals(another.customHeaders) && Objects.equals(this.worker, another.worker) && this.retries == another.retries && this.retryBackoff == another.retryBackoff && this.recurringTime == another.recurringTime && this.deadline == another.deadline && Objects.equals(this.errorMessage, another.errorMessage) && Objects.equals(this.errorCode, another.errorCode) && Objects.equals(this.elementId, another.elementId) && this.elementInstanceKey == another.elementInstanceKey && Objects.equals(this.bpmnProcessId, another.bpmnProcessId) && this.processDefinitionVersion == another.processDefinitionVersion && this.processDefinitionKey == another.processDefinitionKey;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.variables.hashCode();
        h += (h << 5) + Long.hashCode(this.processInstanceKey);
        h += (h << 5) + Objects.hashCode(this.tenantId);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + this.customHeaders.hashCode();
        h += (h << 5) + Objects.hashCode(this.worker);
        h += (h << 5) + this.retries;
        h += (h << 5) + Long.hashCode(this.retryBackoff);
        h += (h << 5) + Long.hashCode(this.recurringTime);
        h += (h << 5) + Long.hashCode(this.deadline);
        h += (h << 5) + Objects.hashCode(this.errorMessage);
        h += (h << 5) + Objects.hashCode(this.errorCode);
        h += (h << 5) + Objects.hashCode(this.elementId);
        h += (h << 5) + Long.hashCode(this.elementInstanceKey);
        h += (h << 5) + Objects.hashCode(this.bpmnProcessId);
        h += (h << 5) + this.processDefinitionVersion;
        h += (h << 5) + Long.hashCode(this.processDefinitionKey);
        return h;
    }

    public String toString() {
        return "JobRecordValue{variables=" + this.variables + ", processInstanceKey=" + this.processInstanceKey + ", tenantId=" + this.tenantId + ", type=" + this.type + ", customHeaders=" + this.customHeaders + ", worker=" + this.worker + ", retries=" + this.retries + ", retryBackoff=" + this.retryBackoff + ", recurringTime=" + this.recurringTime + ", deadline=" + this.deadline + ", errorMessage=" + this.errorMessage + ", errorCode=" + this.errorCode + ", elementId=" + this.elementId + ", elementInstanceKey=" + this.elementInstanceKey + ", bpmnProcessId=" + this.bpmnProcessId + ", processDefinitionVersion=" + this.processDefinitionVersion + ", processDefinitionKey=" + this.processDefinitionKey + "}";
    }

    public static ImmutableJobRecordValue copyOf(JobRecordValue instance) {
        if (instance instanceof ImmutableJobRecordValue) {
            return (ImmutableJobRecordValue)instance;
        }
        return ImmutableJobRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @ImmutableProtocol.Builder
    @Generated(from="JobRecordValue", generator="Immutables")
    public static final class Builder {
        private Map<String, Object> variables = new LinkedHashMap<String, Object>();
        private long processInstanceKey;
        private String tenantId;
        private String type;
        private Map<String, String> customHeaders = new LinkedHashMap<String, String>();
        private String worker;
        private int retries;
        private long retryBackoff;
        private long recurringTime;
        private long deadline;
        private String errorMessage;
        private String errorCode;
        private String elementId;
        private long elementInstanceKey;
        private String bpmnProcessId;
        private int processDefinitionVersion;
        private long processDefinitionKey;

        private Builder() {
        }

        public final Builder from(ProcessInstanceRelated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JobRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TenantOwned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RecordValueWithVariables instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof ProcessInstanceRelated) {
                instance = (ProcessInstanceRelated)object;
                if ((bits & 1L) == 0L) {
                    this.withProcessInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
            }
            if (object instanceof JobRecordValue) {
                String workerValue;
                String bpmnProcessIdValue;
                String errorCodeValue;
                String errorMessageValue;
                instance = (JobRecordValue)object;
                String elementIdValue = instance.getElementId();
                if (elementIdValue != null) {
                    this.withElementId(elementIdValue);
                }
                if ((bits & 1L) == 0L) {
                    this.withProcessInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.putAllVariables(instance.getVariables());
                    bits |= 2L;
                }
                if ((errorMessageValue = instance.getErrorMessage()) != null) {
                    this.withErrorMessage(errorMessageValue);
                }
                if ((errorCodeValue = instance.getErrorCode()) != null) {
                    this.withErrorCode(errorCodeValue);
                }
                this.withRetryBackoff(instance.getRetryBackoff());
                String typeValue = instance.getType();
                if (typeValue != null) {
                    this.withType(typeValue);
                }
                this.withRecurringTime(instance.getRecurringTime());
                this.withProcessDefinitionKey(instance.getProcessDefinitionKey());
                this.withRetries(instance.getRetries());
                this.withElementInstanceKey(instance.getElementInstanceKey());
                if ((bits & 4L) == 0L) {
                    String tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 4L;
                }
                if ((bpmnProcessIdValue = instance.getBpmnProcessId()) != null) {
                    this.withBpmnProcessId(bpmnProcessIdValue);
                }
                if ((workerValue = instance.getWorker()) != null) {
                    this.withWorker(workerValue);
                }
                this.withDeadline(instance.getDeadline());
                this.putAllCustomHeaders(instance.getCustomHeaders());
                this.withProcessDefinitionVersion(instance.getProcessDefinitionVersion());
            }
            if (object instanceof TenantOwned) {
                instance = (TenantOwned)object;
                if ((bits & 4L) == 0L) {
                    String tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 4L;
                }
            }
            if (object instanceof RecordValueWithVariables) {
                instance = (RecordValueWithVariables)object;
                if ((bits & 2L) == 0L) {
                    this.putAllVariables(instance.getVariables());
                    bits |= 2L;
                }
            }
        }

        public final Builder putVariable(String key, Object value) {
            this.variables.put(key, value);
            return this;
        }

        public final Builder putVariable(Map.Entry<String, ? extends Object> entry) {
            String k = entry.getKey();
            Object v = entry.getValue();
            this.variables.put(k, v);
            return this;
        }

        public final Builder withVariables(Map<String, ? extends Object> entries) {
            this.variables.clear();
            return this.putAllVariables(entries);
        }

        public final Builder putAllVariables(Map<String, ? extends Object> entries) {
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.variables.put(k, v);
            }
            return this;
        }

        public final Builder withProcessInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            return this;
        }

        public final Builder withTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final Builder withType(String type) {
            this.type = type;
            return this;
        }

        public final Builder putCustomHeader(String key, String value) {
            this.customHeaders.put(key, value);
            return this;
        }

        public final Builder putCustomHeader(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.customHeaders.put(k, v);
            return this;
        }

        public final Builder withCustomHeaders(Map<String, ? extends String> entries) {
            this.customHeaders.clear();
            return this.putAllCustomHeaders(entries);
        }

        public final Builder putAllCustomHeaders(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.customHeaders.put(k, v);
            }
            return this;
        }

        public final Builder withWorker(String worker) {
            this.worker = worker;
            return this;
        }

        public final Builder withRetries(int retries) {
            this.retries = retries;
            return this;
        }

        public final Builder withRetryBackoff(long retryBackoff) {
            this.retryBackoff = retryBackoff;
            return this;
        }

        public final Builder withRecurringTime(long recurringTime) {
            this.recurringTime = recurringTime;
            return this;
        }

        public final Builder withDeadline(long deadline) {
            this.deadline = deadline;
            return this;
        }

        public final Builder withErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Builder withErrorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final Builder withElementId(String elementId) {
            this.elementId = elementId;
            return this;
        }

        public final Builder withElementInstanceKey(long elementInstanceKey) {
            this.elementInstanceKey = elementInstanceKey;
            return this;
        }

        public final Builder withBpmnProcessId(String bpmnProcessId) {
            this.bpmnProcessId = bpmnProcessId;
            return this;
        }

        public final Builder withProcessDefinitionVersion(int processDefinitionVersion) {
            this.processDefinitionVersion = processDefinitionVersion;
            return this;
        }

        public final Builder withProcessDefinitionKey(long processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
            return this;
        }

        public Builder clear() {
            this.variables.clear();
            this.processInstanceKey = 0L;
            this.tenantId = null;
            this.type = null;
            this.customHeaders.clear();
            this.worker = null;
            this.retries = 0;
            this.retryBackoff = 0L;
            this.recurringTime = 0L;
            this.deadline = 0L;
            this.errorMessage = null;
            this.errorCode = null;
            this.elementId = null;
            this.elementInstanceKey = 0L;
            this.bpmnProcessId = null;
            this.processDefinitionVersion = 0;
            this.processDefinitionKey = 0L;
            return this;
        }

        public ImmutableJobRecordValue build() {
            return new ImmutableJobRecordValue(ImmutableJobRecordValue.createUnmodifiableMap(false, false, this.variables), this.processInstanceKey, this.tenantId, this.type, ImmutableJobRecordValue.createUnmodifiableMap(false, false, this.customHeaders), this.worker, this.retries, this.retryBackoff, this.recurringTime, this.deadline, this.errorMessage, this.errorCode, this.elementId, this.elementInstanceKey, this.bpmnProcessId, this.processDefinitionVersion, this.processDefinitionKey);
        }
    }
}

