/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value.deployment;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.value.TenantOwned;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import java.util.Arrays;
import java.util.Objects;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="ProcessMetadataValue", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableProcessMetadataValue
implements ProcessMetadataValue {
    private final String tenantId;
    private final String bpmnProcessId;
    private final int version;
    private final long processDefinitionKey;
    private final String resourceName;
    private final byte[] checksum;
    private final boolean duplicate;
    private transient int hashCode;

    private ImmutableProcessMetadataValue(String tenantId, String bpmnProcessId, int version, long processDefinitionKey, String resourceName, byte[] checksum, boolean duplicate) {
        this.tenantId = tenantId;
        this.bpmnProcessId = bpmnProcessId;
        this.version = version;
        this.processDefinitionKey = processDefinitionKey;
        this.resourceName = resourceName;
        this.checksum = checksum;
        this.duplicate = duplicate;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public byte[] getChecksum() {
        return this.checksum;
    }

    @Override
    public boolean isDuplicate() {
        return this.duplicate;
    }

    public final ImmutableProcessMetadataValue withTenantId(String value) {
        if (Objects.equals(this.tenantId, value)) {
            return this;
        }
        return new ImmutableProcessMetadataValue(value, this.bpmnProcessId, this.version, this.processDefinitionKey, this.resourceName, this.checksum, this.duplicate);
    }

    public final ImmutableProcessMetadataValue withBpmnProcessId(String value) {
        if (Objects.equals(this.bpmnProcessId, value)) {
            return this;
        }
        return new ImmutableProcessMetadataValue(this.tenantId, value, this.version, this.processDefinitionKey, this.resourceName, this.checksum, this.duplicate);
    }

    public final ImmutableProcessMetadataValue withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableProcessMetadataValue(this.tenantId, this.bpmnProcessId, value, this.processDefinitionKey, this.resourceName, this.checksum, this.duplicate);
    }

    public final ImmutableProcessMetadataValue withProcessDefinitionKey(long value) {
        if (this.processDefinitionKey == value) {
            return this;
        }
        return new ImmutableProcessMetadataValue(this.tenantId, this.bpmnProcessId, this.version, value, this.resourceName, this.checksum, this.duplicate);
    }

    public final ImmutableProcessMetadataValue withResourceName(String value) {
        if (Objects.equals(this.resourceName, value)) {
            return this;
        }
        return new ImmutableProcessMetadataValue(this.tenantId, this.bpmnProcessId, this.version, this.processDefinitionKey, value, this.checksum, this.duplicate);
    }

    public final ImmutableProcessMetadataValue withChecksum(byte ... elements) {
        byte[] newValue = elements == null ? null : (byte[])elements.clone();
        return new ImmutableProcessMetadataValue(this.tenantId, this.bpmnProcessId, this.version, this.processDefinitionKey, this.resourceName, newValue, this.duplicate);
    }

    public final ImmutableProcessMetadataValue withDuplicate(boolean value) {
        if (this.duplicate == value) {
            return this;
        }
        return new ImmutableProcessMetadataValue(this.tenantId, this.bpmnProcessId, this.version, this.processDefinitionKey, this.resourceName, this.checksum, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProcessMetadataValue && this.equalTo(0, (ImmutableProcessMetadataValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableProcessMetadataValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.tenantId, another.tenantId) && Objects.equals(this.bpmnProcessId, another.bpmnProcessId) && this.version == another.version && this.processDefinitionKey == another.processDefinitionKey && Objects.equals(this.resourceName, another.resourceName) && Arrays.equals(this.checksum, another.checksum) && this.duplicate == another.duplicate;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.tenantId);
        h += (h << 5) + Objects.hashCode(this.bpmnProcessId);
        h += (h << 5) + this.version;
        h += (h << 5) + Long.hashCode(this.processDefinitionKey);
        h += (h << 5) + Objects.hashCode(this.resourceName);
        h += (h << 5) + Arrays.hashCode(this.checksum);
        h += (h << 5) + Boolean.hashCode(this.duplicate);
        return h;
    }

    public String toString() {
        return "ProcessMetadataValue{tenantId=" + this.tenantId + ", bpmnProcessId=" + this.bpmnProcessId + ", version=" + this.version + ", processDefinitionKey=" + this.processDefinitionKey + ", resourceName=" + this.resourceName + ", checksum=" + Arrays.toString(this.checksum) + ", duplicate=" + this.duplicate + "}";
    }

    public static ImmutableProcessMetadataValue copyOf(ProcessMetadataValue instance) {
        if (instance instanceof ImmutableProcessMetadataValue) {
            return (ImmutableProcessMetadataValue)instance;
        }
        return ImmutableProcessMetadataValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ImmutableProtocol.Builder
    @Generated(from="ProcessMetadataValue", generator="Immutables")
    public static final class Builder {
        private String tenantId;
        private String bpmnProcessId;
        private int version;
        private long processDefinitionKey;
        private String resourceName;
        private byte[] checksum;
        private boolean duplicate;

        private Builder() {
        }

        public final Builder from(ProcessMetadataValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TenantOwned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String tenantIdValue;
            TenantOwned instance;
            long bits = 0L;
            if (object instanceof ProcessMetadataValue) {
                String bpmnProcessIdValue;
                String resourceNameValue;
                byte[] checksumValue;
                instance = (ProcessMetadataValue)object;
                if ((bits & 1L) == 0L) {
                    tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 1L;
                }
                if ((checksumValue = instance.getChecksum()) != null) {
                    this.withChecksum(checksumValue);
                }
                if ((resourceNameValue = instance.getResourceName()) != null) {
                    this.withResourceName(resourceNameValue);
                }
                if ((bpmnProcessIdValue = instance.getBpmnProcessId()) != null) {
                    this.withBpmnProcessId(bpmnProcessIdValue);
                }
                this.withDuplicate(instance.isDuplicate());
                this.withVersion(instance.getVersion());
                this.withProcessDefinitionKey(instance.getProcessDefinitionKey());
            }
            if (object instanceof TenantOwned) {
                instance = (TenantOwned)object;
                if ((bits & 1L) == 0L) {
                    tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 1L;
                }
            }
        }

        public final Builder withTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final Builder withBpmnProcessId(String bpmnProcessId) {
            this.bpmnProcessId = bpmnProcessId;
            return this;
        }

        public final Builder withVersion(int version) {
            this.version = version;
            return this;
        }

        public final Builder withProcessDefinitionKey(long processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
            return this;
        }

        public final Builder withResourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final Builder withChecksum(byte ... checksum) {
            this.checksum = checksum;
            return this;
        }

        public final Builder withDuplicate(boolean duplicate) {
            this.duplicate = duplicate;
            return this;
        }

        public Builder clear() {
            this.tenantId = null;
            this.bpmnProcessId = null;
            this.version = 0;
            this.processDefinitionKey = 0L;
            this.resourceName = null;
            this.checksum = null;
            this.duplicate = false;
            return this;
        }

        public ImmutableProcessMetadataValue build() {
            return new ImmutableProcessMetadataValue(this.tenantId, this.bpmnProcessId, this.version, this.processDefinitionKey, this.resourceName, this.checksum, this.duplicate);
        }
    }
}

