package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link EscalationRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEscalationRecordValue.builder()}.
 */
@Generated(from = "EscalationRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableEscalationRecordValue.Builder.class)
public final class ImmutableEscalationRecordValue
    implements EscalationRecordValue {
  private final String tenantId;
  private final long processInstanceKey;
  private final String escalationCode;
  private final String throwElementId;
  private final String catchElementId;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableEscalationRecordValue(
      String tenantId,
      long processInstanceKey,
      String escalationCode,
      String throwElementId,
      String catchElementId) {
    this.tenantId = tenantId;
    this.processInstanceKey = processInstanceKey;
    this.escalationCode = escalationCode;
    this.throwElementId = throwElementId;
    this.catchElementId = catchElementId;
  }

  /**
   *Returns the identifier of the tenant that owns this entity. 
   */
  @Override
  public String getTenantId() {
    return tenantId;
  }

  /**
   * @return the key of the process instance
   */
  @Override
  public long getProcessInstanceKey() {
    return processInstanceKey;
  }

  /**
   * @return the code of the escalation
   */
  @Override
  public String getEscalationCode() {
    return escalationCode;
  }

  /**
   * @return the id of the escalation throw event
   */
  @Override
  public String getThrowElementId() {
    return throwElementId;
  }

  /**
   * @return the id of the escalation catch event
   */
  @Override
  public String getCatchElementId() {
    return catchElementId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EscalationRecordValue#getTenantId() tenantId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenantId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEscalationRecordValue withTenantId(String value) {
    if (Objects.equals(this.tenantId, value)) return this;
    return new ImmutableEscalationRecordValue(value, this.processInstanceKey, this.escalationCode, this.throwElementId, this.catchElementId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EscalationRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEscalationRecordValue withProcessInstanceKey(long value) {
    if (this.processInstanceKey == value) return this;
    return new ImmutableEscalationRecordValue(this.tenantId, value, this.escalationCode, this.throwElementId, this.catchElementId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EscalationRecordValue#getEscalationCode() escalationCode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for escalationCode (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEscalationRecordValue withEscalationCode(String value) {
    if (Objects.equals(this.escalationCode, value)) return this;
    return new ImmutableEscalationRecordValue(this.tenantId, this.processInstanceKey, value, this.throwElementId, this.catchElementId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EscalationRecordValue#getThrowElementId() throwElementId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for throwElementId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEscalationRecordValue withThrowElementId(String value) {
    if (Objects.equals(this.throwElementId, value)) return this;
    return new ImmutableEscalationRecordValue(this.tenantId, this.processInstanceKey, this.escalationCode, value, this.catchElementId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EscalationRecordValue#getCatchElementId() catchElementId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for catchElementId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEscalationRecordValue withCatchElementId(String value) {
    if (Objects.equals(this.catchElementId, value)) return this;
    return new ImmutableEscalationRecordValue(this.tenantId, this.processInstanceKey, this.escalationCode, this.throwElementId, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEscalationRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEscalationRecordValue
        && equalTo(0, (ImmutableEscalationRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableEscalationRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(tenantId, another.tenantId)
        && processInstanceKey == another.processInstanceKey
        && Objects.equals(escalationCode, another.escalationCode)
        && Objects.equals(throwElementId, another.throwElementId)
        && Objects.equals(catchElementId, another.catchElementId);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code tenantId}, {@code processInstanceKey}, {@code escalationCode}, {@code throwElementId}, {@code catchElementId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(tenantId);
    h += (h << 5) + Long.hashCode(processInstanceKey);
    h += (h << 5) + Objects.hashCode(escalationCode);
    h += (h << 5) + Objects.hashCode(throwElementId);
    h += (h << 5) + Objects.hashCode(catchElementId);
    return h;
  }

  /**
   * Prints the immutable value {@code EscalationRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "EscalationRecordValue{"
        + "tenantId=" + tenantId
        + ", processInstanceKey=" + processInstanceKey
        + ", escalationCode=" + escalationCode
        + ", throwElementId=" + throwElementId
        + ", catchElementId=" + catchElementId
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link EscalationRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EscalationRecordValue instance
   */
  public static ImmutableEscalationRecordValue copyOf(EscalationRecordValue instance) {
    if (instance instanceof ImmutableEscalationRecordValue) {
      return (ImmutableEscalationRecordValue) instance;
    }
    return ImmutableEscalationRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEscalationRecordValue ImmutableEscalationRecordValue}.
   * <pre>
   * ImmutableEscalationRecordValue.builder()
   *    .withTenantId(String | null) // nullable {@link EscalationRecordValue#getTenantId() tenantId}
   *    .withProcessInstanceKey(long) // optional {@link EscalationRecordValue#getProcessInstanceKey() processInstanceKey}
   *    .withEscalationCode(String | null) // nullable {@link EscalationRecordValue#getEscalationCode() escalationCode}
   *    .withThrowElementId(String | null) // nullable {@link EscalationRecordValue#getThrowElementId() throwElementId}
   *    .withCatchElementId(String | null) // nullable {@link EscalationRecordValue#getCatchElementId() catchElementId}
   *    .build();
   * </pre>
   * @return A new ImmutableEscalationRecordValue builder
   */
  public static ImmutableEscalationRecordValue.Builder builder() {
    return new ImmutableEscalationRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEscalationRecordValue ImmutableEscalationRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "EscalationRecordValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private String tenantId;
    private long processInstanceKey;
    private String escalationCode;
    private String throwElementId;
    private String catchElementId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.TenantOwned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TenantOwned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.EscalationRecordValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(EscalationRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof TenantOwned) {
        TenantOwned instance = (TenantOwned) object;
        if ((bits & 0x1L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x1L;
        }
      }
      if (object instanceof EscalationRecordValue) {
        EscalationRecordValue instance = (EscalationRecordValue) object;
        if ((bits & 0x1L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x1L;
        }
        withProcessInstanceKey(instance.getProcessInstanceKey());
        String catchElementIdValue = instance.getCatchElementId();
        if (catchElementIdValue != null) {
          withCatchElementId(catchElementIdValue);
        }
        String escalationCodeValue = instance.getEscalationCode();
        if (escalationCodeValue != null) {
          withEscalationCode(escalationCodeValue);
        }
        String throwElementIdValue = instance.getThrowElementId();
        if (throwElementIdValue != null) {
          withThrowElementId(throwElementIdValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link EscalationRecordValue#getTenantId() tenantId} attribute.
     * @param tenantId The value for tenantId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTenantId(String tenantId) {
      this.tenantId = tenantId;
      return this;
    }

    /**
     * Initializes the value for the {@link EscalationRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
     * @param processInstanceKey The value for processInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessInstanceKey(long processInstanceKey) {
      this.processInstanceKey = processInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link EscalationRecordValue#getEscalationCode() escalationCode} attribute.
     * @param escalationCode The value for escalationCode (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withEscalationCode(String escalationCode) {
      this.escalationCode = escalationCode;
      return this;
    }

    /**
     * Initializes the value for the {@link EscalationRecordValue#getThrowElementId() throwElementId} attribute.
     * @param throwElementId The value for throwElementId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withThrowElementId(String throwElementId) {
      this.throwElementId = throwElementId;
      return this;
    }

    /**
     * Initializes the value for the {@link EscalationRecordValue#getCatchElementId() catchElementId} attribute.
     * @param catchElementId The value for catchElementId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withCatchElementId(String catchElementId) {
      this.catchElementId = catchElementId;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.tenantId = null;
      this.processInstanceKey = 0;
      this.escalationCode = null;
      this.throwElementId = null;
      this.catchElementId = null;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEscalationRecordValue ImmutableEscalationRecordValue}.
     * @return An immutable instance of EscalationRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEscalationRecordValue build() {
      return new ImmutableEscalationRecordValue(tenantId, processInstanceKey, escalationCode, throwElementId, catchElementId);
    }



  }



}
