package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MessageBatchRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMessageBatchRecordValue.builder()}.
 */
@Generated(from = "MessageBatchRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableMessageBatchRecordValue.Builder.class)
public final class ImmutableMessageBatchRecordValue
    implements MessageBatchRecordValue {
  private final List<Long> messageKeys;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableMessageBatchRecordValue(List<Long> messageKeys) {
    this.messageKeys = messageKeys;
  }

  /**
   * @return list of the keys from the messages assigned to this batch
   */
  @Override
  public List<Long> getMessageKeys() {
    return messageKeys;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MessageBatchRecordValue#getMessageKeys() messageKeys}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMessageBatchRecordValue withMessageKeys(Long... elements) {
    List<Long> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableMessageBatchRecordValue(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MessageBatchRecordValue#getMessageKeys() messageKeys}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of messageKeys elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMessageBatchRecordValue withMessageKeys(Iterable<? extends Long> elements) {
    if (this.messageKeys == elements) return this;
    List<Long> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableMessageBatchRecordValue(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMessageBatchRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMessageBatchRecordValue
        && equalTo(0, (ImmutableMessageBatchRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableMessageBatchRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return messageKeys.equals(another.messageKeys);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code messageKeys}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + messageKeys.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MessageBatchRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MessageBatchRecordValue{"
        + "messageKeys=" + messageKeys
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link MessageBatchRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MessageBatchRecordValue instance
   */
  public static ImmutableMessageBatchRecordValue copyOf(MessageBatchRecordValue instance) {
    if (instance instanceof ImmutableMessageBatchRecordValue) {
      return (ImmutableMessageBatchRecordValue) instance;
    }
    return ImmutableMessageBatchRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMessageBatchRecordValue ImmutableMessageBatchRecordValue}.
   * <pre>
   * ImmutableMessageBatchRecordValue.builder()
   *    .addMessageKey|addAllMessageKeys(Long) // {@link MessageBatchRecordValue#getMessageKeys() messageKeys} elements
   *    .build();
   * </pre>
   * @return A new ImmutableMessageBatchRecordValue builder
   */
  public static ImmutableMessageBatchRecordValue.Builder builder() {
    return new ImmutableMessageBatchRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMessageBatchRecordValue ImmutableMessageBatchRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MessageBatchRecordValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private List<Long> messageKeys = new ArrayList<Long>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MessageBatchRecordValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MessageBatchRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      addAllMessageKeys(instance.getMessageKeys());
      return this;
    }

    /**
     * Adds one element to {@link MessageBatchRecordValue#getMessageKeys() messageKeys} list.
     * @param element A messageKeys element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMessageKey(Long element) {
      this.messageKeys.add(element);
      return this;
    }

    /**
     * Adds elements to {@link MessageBatchRecordValue#getMessageKeys() messageKeys} list.
     * @param elements An array of messageKeys elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMessageKeys(Long... elements) {
      for (Long element : elements) {
        this.messageKeys.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MessageBatchRecordValue#getMessageKeys() messageKeys} list.
     * @param elements An iterable of messageKeys elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withMessageKeys(Iterable<? extends Long> elements) {
      this.messageKeys.clear();
      return addAllMessageKeys(elements);
    }

    /**
     * Adds elements to {@link MessageBatchRecordValue#getMessageKeys() messageKeys} list.
     * @param elements An iterable of messageKeys elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMessageKeys(Iterable<? extends Long> elements) {
      for (Long element : elements) {
        this.messageKeys.add(element);
      }
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.messageKeys.clear();
      return this;
    }

    /**
     * Builds a new {@link ImmutableMessageBatchRecordValue ImmutableMessageBatchRecordValue}.
     * @return An immutable instance of MessageBatchRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMessageBatchRecordValue build() {
      return new ImmutableMessageBatchRecordValue(createUnmodifiableList(true, messageKeys));
    }



  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }



}
