package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.RecordValueWithVariables;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MessageSubscriptionRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMessageSubscriptionRecordValue.builder()}.
 */
@Generated(from = "MessageSubscriptionRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableMessageSubscriptionRecordValue.Builder.class)
public final class ImmutableMessageSubscriptionRecordValue
    implements MessageSubscriptionRecordValue {
  private final Map<String, Object> variables;
  private final String tenantId;
  private final long processInstanceKey;
  private final long elementInstanceKey;
  private final String bpmnProcessId;
  private final String messageName;
  private final String correlationKey;
  private final long messageKey;
  private final boolean interrupting;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableMessageSubscriptionRecordValue(
      Map<String, Object> variables,
      String tenantId,
      long processInstanceKey,
      long elementInstanceKey,
      String bpmnProcessId,
      String messageName,
      String correlationKey,
      long messageKey,
      boolean interrupting) {
    this.variables = variables;
    this.tenantId = tenantId;
    this.processInstanceKey = processInstanceKey;
    this.elementInstanceKey = elementInstanceKey;
    this.bpmnProcessId = bpmnProcessId;
    this.messageName = messageName;
    this.correlationKey = correlationKey;
    this.messageKey = messageKey;
    this.interrupting = interrupting;
  }

  /**
   * @return the variables of this record. Can be empty.
   */
  @Override
  public Map<String, Object> getVariables() {
    return variables;
  }

  /**
   *Returns the identifier of the tenant that owns this entity. 
   */
  @Override
  public String getTenantId() {
    return tenantId;
  }

  /**
   * @return the process instance key tied to the subscription
   */
  @Override
  public long getProcessInstanceKey() {
    return processInstanceKey;
  }

  /**
   * @return the element instance key tied to the subscription
   */
  @Override
  public long getElementInstanceKey() {
    return elementInstanceKey;
  }

  /**
   * @return the BPMN process id tied to the subscription
   */
  @Override
  public String getBpmnProcessId() {
    return bpmnProcessId;
  }

  /**
   * @return the name of the message
   */
  @Override
  public String getMessageName() {
    return messageName;
  }

  /**
   * @return the correlation key
   */
  @Override
  public String getCorrelationKey() {
    return correlationKey;
  }

  /**
   * @return the key of the correlated message
   */
  @Override
  public long getMessageKey() {
    return messageKey;
  }

  /**
   * @return {@code true} if the event tied to the subscription is interrupting. Otherwise, it
   *     returns {@code false} if the event is non-interrupting.
   */
  @Override
  public boolean isInterrupting() {
    return interrupting;
  }

  /**
   * Copy the current immutable object by replacing the {@link MessageSubscriptionRecordValue#getVariables() variables} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the variables map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMessageSubscriptionRecordValue withVariables(Map<String, ? extends Object> entries) {
    if (this.variables == entries) return this;
    Map<String, Object> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableMessageSubscriptionRecordValue(
        newValue,
        this.tenantId,
        this.processInstanceKey,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.messageName,
        this.correlationKey,
        this.messageKey,
        this.interrupting);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageSubscriptionRecordValue#getTenantId() tenantId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenantId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageSubscriptionRecordValue withTenantId(String value) {
    if (Objects.equals(this.tenantId, value)) return this;
    return new ImmutableMessageSubscriptionRecordValue(
        this.variables,
        value,
        this.processInstanceKey,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.messageName,
        this.correlationKey,
        this.messageKey,
        this.interrupting);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageSubscriptionRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageSubscriptionRecordValue withProcessInstanceKey(long value) {
    if (this.processInstanceKey == value) return this;
    return new ImmutableMessageSubscriptionRecordValue(
        this.variables,
        this.tenantId,
        value,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.messageName,
        this.correlationKey,
        this.messageKey,
        this.interrupting);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageSubscriptionRecordValue#getElementInstanceKey() elementInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for elementInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageSubscriptionRecordValue withElementInstanceKey(long value) {
    if (this.elementInstanceKey == value) return this;
    return new ImmutableMessageSubscriptionRecordValue(
        this.variables,
        this.tenantId,
        this.processInstanceKey,
        value,
        this.bpmnProcessId,
        this.messageName,
        this.correlationKey,
        this.messageKey,
        this.interrupting);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageSubscriptionRecordValue#getBpmnProcessId() bpmnProcessId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bpmnProcessId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageSubscriptionRecordValue withBpmnProcessId(String value) {
    if (Objects.equals(this.bpmnProcessId, value)) return this;
    return new ImmutableMessageSubscriptionRecordValue(
        this.variables,
        this.tenantId,
        this.processInstanceKey,
        this.elementInstanceKey,
        value,
        this.messageName,
        this.correlationKey,
        this.messageKey,
        this.interrupting);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageSubscriptionRecordValue#getMessageName() messageName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for messageName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageSubscriptionRecordValue withMessageName(String value) {
    if (Objects.equals(this.messageName, value)) return this;
    return new ImmutableMessageSubscriptionRecordValue(
        this.variables,
        this.tenantId,
        this.processInstanceKey,
        this.elementInstanceKey,
        this.bpmnProcessId,
        value,
        this.correlationKey,
        this.messageKey,
        this.interrupting);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageSubscriptionRecordValue#getCorrelationKey() correlationKey} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for correlationKey (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageSubscriptionRecordValue withCorrelationKey(String value) {
    if (Objects.equals(this.correlationKey, value)) return this;
    return new ImmutableMessageSubscriptionRecordValue(
        this.variables,
        this.tenantId,
        this.processInstanceKey,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.messageName,
        value,
        this.messageKey,
        this.interrupting);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageSubscriptionRecordValue#getMessageKey() messageKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for messageKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageSubscriptionRecordValue withMessageKey(long value) {
    if (this.messageKey == value) return this;
    return new ImmutableMessageSubscriptionRecordValue(
        this.variables,
        this.tenantId,
        this.processInstanceKey,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.messageName,
        this.correlationKey,
        value,
        this.interrupting);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageSubscriptionRecordValue#isInterrupting() interrupting} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for interrupting
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageSubscriptionRecordValue withInterrupting(boolean value) {
    if (this.interrupting == value) return this;
    return new ImmutableMessageSubscriptionRecordValue(
        this.variables,
        this.tenantId,
        this.processInstanceKey,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.messageName,
        this.correlationKey,
        this.messageKey,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMessageSubscriptionRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMessageSubscriptionRecordValue
        && equalTo(0, (ImmutableMessageSubscriptionRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableMessageSubscriptionRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return variables.equals(another.variables)
        && Objects.equals(tenantId, another.tenantId)
        && processInstanceKey == another.processInstanceKey
        && elementInstanceKey == another.elementInstanceKey
        && Objects.equals(bpmnProcessId, another.bpmnProcessId)
        && Objects.equals(messageName, another.messageName)
        && Objects.equals(correlationKey, another.correlationKey)
        && messageKey == another.messageKey
        && interrupting == another.interrupting;
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code variables}, {@code tenantId}, {@code processInstanceKey}, {@code elementInstanceKey}, {@code bpmnProcessId}, {@code messageName}, {@code correlationKey}, {@code messageKey}, {@code interrupting}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + variables.hashCode();
    h += (h << 5) + Objects.hashCode(tenantId);
    h += (h << 5) + Long.hashCode(processInstanceKey);
    h += (h << 5) + Long.hashCode(elementInstanceKey);
    h += (h << 5) + Objects.hashCode(bpmnProcessId);
    h += (h << 5) + Objects.hashCode(messageName);
    h += (h << 5) + Objects.hashCode(correlationKey);
    h += (h << 5) + Long.hashCode(messageKey);
    h += (h << 5) + Boolean.hashCode(interrupting);
    return h;
  }

  /**
   * Prints the immutable value {@code MessageSubscriptionRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MessageSubscriptionRecordValue{"
        + "variables=" + variables
        + ", tenantId=" + tenantId
        + ", processInstanceKey=" + processInstanceKey
        + ", elementInstanceKey=" + elementInstanceKey
        + ", bpmnProcessId=" + bpmnProcessId
        + ", messageName=" + messageName
        + ", correlationKey=" + correlationKey
        + ", messageKey=" + messageKey
        + ", interrupting=" + interrupting
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link MessageSubscriptionRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MessageSubscriptionRecordValue instance
   */
  public static ImmutableMessageSubscriptionRecordValue copyOf(MessageSubscriptionRecordValue instance) {
    if (instance instanceof ImmutableMessageSubscriptionRecordValue) {
      return (ImmutableMessageSubscriptionRecordValue) instance;
    }
    return ImmutableMessageSubscriptionRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMessageSubscriptionRecordValue ImmutableMessageSubscriptionRecordValue}.
   * <pre>
   * ImmutableMessageSubscriptionRecordValue.builder()
   *    .putVariable|putAllVariables(String =&gt; Object) // {@link MessageSubscriptionRecordValue#getVariables() variables} mappings
   *    .withTenantId(String | null) // nullable {@link MessageSubscriptionRecordValue#getTenantId() tenantId}
   *    .withProcessInstanceKey(long) // optional {@link MessageSubscriptionRecordValue#getProcessInstanceKey() processInstanceKey}
   *    .withElementInstanceKey(long) // optional {@link MessageSubscriptionRecordValue#getElementInstanceKey() elementInstanceKey}
   *    .withBpmnProcessId(String | null) // nullable {@link MessageSubscriptionRecordValue#getBpmnProcessId() bpmnProcessId}
   *    .withMessageName(String | null) // nullable {@link MessageSubscriptionRecordValue#getMessageName() messageName}
   *    .withCorrelationKey(String | null) // nullable {@link MessageSubscriptionRecordValue#getCorrelationKey() correlationKey}
   *    .withMessageKey(long) // optional {@link MessageSubscriptionRecordValue#getMessageKey() messageKey}
   *    .withInterrupting(boolean) // optional {@link MessageSubscriptionRecordValue#isInterrupting() interrupting}
   *    .build();
   * </pre>
   * @return A new ImmutableMessageSubscriptionRecordValue builder
   */
  public static ImmutableMessageSubscriptionRecordValue.Builder builder() {
    return new ImmutableMessageSubscriptionRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMessageSubscriptionRecordValue ImmutableMessageSubscriptionRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MessageSubscriptionRecordValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private Map<String, Object> variables = new LinkedHashMap<String, Object>();
    private String tenantId;
    private long processInstanceKey;
    private long elementInstanceKey;
    private String bpmnProcessId;
    private String messageName;
    private String correlationKey;
    private long messageKey;
    private boolean interrupting;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessInstanceRelated instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.TenantOwned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TenantOwned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.RecordValueWithVariables} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RecordValueWithVariables instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.MessageSubscriptionRecordValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MessageSubscriptionRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof ProcessInstanceRelated) {
        ProcessInstanceRelated instance = (ProcessInstanceRelated) object;
        if ((bits & 0x1L) == 0) {
          withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
      }
      if (object instanceof TenantOwned) {
        TenantOwned instance = (TenantOwned) object;
        if ((bits & 0x4L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x4L;
        }
      }
      if (object instanceof RecordValueWithVariables) {
        RecordValueWithVariables instance = (RecordValueWithVariables) object;
        if ((bits & 0x2L) == 0) {
          putAllVariables(instance.getVariables());
          bits |= 0x2L;
        }
      }
      if (object instanceof MessageSubscriptionRecordValue) {
        MessageSubscriptionRecordValue instance = (MessageSubscriptionRecordValue) object;
        String messageNameValue = instance.getMessageName();
        if (messageNameValue != null) {
          withMessageName(messageNameValue);
        }
        if ((bits & 0x1L) == 0) {
          withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
        withMessageKey(instance.getMessageKey());
        if ((bits & 0x2L) == 0) {
          putAllVariables(instance.getVariables());
          bits |= 0x2L;
        }
        withElementInstanceKey(instance.getElementInstanceKey());
        withInterrupting(instance.isInterrupting());
        if ((bits & 0x4L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x4L;
        }
        String bpmnProcessIdValue = instance.getBpmnProcessId();
        if (bpmnProcessIdValue != null) {
          withBpmnProcessId(bpmnProcessIdValue);
        }
        String correlationKeyValue = instance.getCorrelationKey();
        if (correlationKeyValue != null) {
          withCorrelationKey(correlationKeyValue);
        }
      }
    }

    /**
     * Put one entry to the {@link MessageSubscriptionRecordValue#getVariables() variables} map.
     * @param key The key in the variables map
     * @param value The associated value in the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(String key, Object value) {
      this.variables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link MessageSubscriptionRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.variables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link MessageSubscriptionRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVariables(Map<String, ? extends Object> entries) {
      this.variables.clear();
      return putAllVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link MessageSubscriptionRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllVariables(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.variables.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link MessageSubscriptionRecordValue#getTenantId() tenantId} attribute.
     * @param tenantId The value for tenantId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTenantId(String tenantId) {
      this.tenantId = tenantId;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageSubscriptionRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
     * @param processInstanceKey The value for processInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessInstanceKey(long processInstanceKey) {
      this.processInstanceKey = processInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageSubscriptionRecordValue#getElementInstanceKey() elementInstanceKey} attribute.
     * @param elementInstanceKey The value for elementInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withElementInstanceKey(long elementInstanceKey) {
      this.elementInstanceKey = elementInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageSubscriptionRecordValue#getBpmnProcessId() bpmnProcessId} attribute.
     * @param bpmnProcessId The value for bpmnProcessId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withBpmnProcessId(String bpmnProcessId) {
      this.bpmnProcessId = bpmnProcessId;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageSubscriptionRecordValue#getMessageName() messageName} attribute.
     * @param messageName The value for messageName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withMessageName(String messageName) {
      this.messageName = messageName;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageSubscriptionRecordValue#getCorrelationKey() correlationKey} attribute.
     * @param correlationKey The value for correlationKey (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withCorrelationKey(String correlationKey) {
      this.correlationKey = correlationKey;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageSubscriptionRecordValue#getMessageKey() messageKey} attribute.
     * @param messageKey The value for messageKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withMessageKey(long messageKey) {
      this.messageKey = messageKey;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageSubscriptionRecordValue#isInterrupting() interrupting} attribute.
     * @param interrupting The value for interrupting 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withInterrupting(boolean interrupting) {
      this.interrupting = interrupting;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.variables.clear();
      this.tenantId = null;
      this.processInstanceKey = 0;
      this.elementInstanceKey = 0;
      this.bpmnProcessId = null;
      this.messageName = null;
      this.correlationKey = null;
      this.messageKey = 0;
      this.interrupting = false;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMessageSubscriptionRecordValue ImmutableMessageSubscriptionRecordValue}.
     * @return An immutable instance of MessageSubscriptionRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMessageSubscriptionRecordValue build() {
      return new ImmutableMessageSubscriptionRecordValue(
          createUnmodifiableMap(false, false, variables),
          tenantId,
          processInstanceKey,
          elementInstanceKey,
          bpmnProcessId,
          messageName,
          correlationKey,
          messageKey,
          interrupting);
    }



  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }



}
