package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ProcessInstanceModificationRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProcessInstanceModificationRecordValue.builder()}.
 */
@Generated(from = "ProcessInstanceModificationRecordValue", generator = "Immutables")
@SuppressWarnings({"all", "deprecation", "removal"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableProcessInstanceModificationRecordValue.Builder.class)
public final class ImmutableProcessInstanceModificationRecordValue
    implements ProcessInstanceModificationRecordValue {
  private final long processInstanceKey;
  private final String tenantId;
  private final List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue> terminateInstructions;
  private final List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> activateInstructions;
  private final Set<Long> ancestorScopeKeys;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableProcessInstanceModificationRecordValue(
      long processInstanceKey,
      String tenantId,
      List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue> terminateInstructions,
      List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> activateInstructions,
      Set<Long> ancestorScopeKeys) {
    this.processInstanceKey = processInstanceKey;
    this.tenantId = tenantId;
    this.terminateInstructions = terminateInstructions;
    this.activateInstructions = activateInstructions;
    this.ancestorScopeKeys = ancestorScopeKeys;
  }

  /**
   * @return the key of the corresponding process instance
   */
  @Override
  public long getProcessInstanceKey() {
    return processInstanceKey;
  }

  /**
   *Returns the identifier of the tenant that owns this entity. 
   */
  @Override
  public String getTenantId() {
    return tenantId;
  }

  /**
   *Returns a list of terminate instructions (if available), or an empty list. 
   */
  @Override
  public List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue> getTerminateInstructions() {
    return terminateInstructions;
  }

  /**
   *Returns a list of activate instructions (if available), or an empty list. 
   */
  @Override
  public List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> getActivateInstructions() {
    return activateInstructions;
  }

  /**
   * Returns a list of all ancestor keys of all activate instructions. The property is set in the
   * event only after the modification is applied.
   * @deprecated since 8.1.3, replaced by {@link
   *     ProcessInstanceModificationActivateInstructionValue#getAncestorScopeKeys()}
   */
  @Deprecated
  @Override
  public Set<Long> getAncestorScopeKeys() {
    return ancestorScopeKeys;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceModificationRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceModificationRecordValue withProcessInstanceKey(long value) {
    if (this.processInstanceKey == value) return this;
    return new ImmutableProcessInstanceModificationRecordValue(
        value,
        this.tenantId,
        this.terminateInstructions,
        this.activateInstructions,
        this.ancestorScopeKeys);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceModificationRecordValue#getTenantId() tenantId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenantId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceModificationRecordValue withTenantId(String value) {
    if (Objects.equals(this.tenantId, value)) return this;
    return new ImmutableProcessInstanceModificationRecordValue(
        this.processInstanceKey,
        value,
        this.terminateInstructions,
        this.activateInstructions,
        this.ancestorScopeKeys);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ProcessInstanceModificationRecordValue#getTerminateInstructions() terminateInstructions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProcessInstanceModificationRecordValue withTerminateInstructions(ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue... elements) {
    List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableProcessInstanceModificationRecordValue(
        this.processInstanceKey,
        this.tenantId,
        newValue,
        this.activateInstructions,
        this.ancestorScopeKeys);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ProcessInstanceModificationRecordValue#getTerminateInstructions() terminateInstructions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of terminateInstructions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProcessInstanceModificationRecordValue withTerminateInstructions(Iterable<? extends ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue> elements) {
    if (this.terminateInstructions == elements) return this;
    List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableProcessInstanceModificationRecordValue(
        this.processInstanceKey,
        this.tenantId,
        newValue,
        this.activateInstructions,
        this.ancestorScopeKeys);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ProcessInstanceModificationRecordValue#getActivateInstructions() activateInstructions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProcessInstanceModificationRecordValue withActivateInstructions(ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue... elements) {
    List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableProcessInstanceModificationRecordValue(
        this.processInstanceKey,
        this.tenantId,
        this.terminateInstructions,
        newValue,
        this.ancestorScopeKeys);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ProcessInstanceModificationRecordValue#getActivateInstructions() activateInstructions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of activateInstructions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProcessInstanceModificationRecordValue withActivateInstructions(Iterable<? extends ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> elements) {
    if (this.activateInstructions == elements) return this;
    List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableProcessInstanceModificationRecordValue(
        this.processInstanceKey,
        this.tenantId,
        this.terminateInstructions,
        newValue,
        this.ancestorScopeKeys);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ProcessInstanceModificationRecordValue#getAncestorScopeKeys() ancestorScopeKeys}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @Deprecated
  public final ImmutableProcessInstanceModificationRecordValue withAncestorScopeKeys(Long... elements) {
    Set<Long> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableProcessInstanceModificationRecordValue(
        this.processInstanceKey,
        this.tenantId,
        this.terminateInstructions,
        this.activateInstructions,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ProcessInstanceModificationRecordValue#getAncestorScopeKeys() ancestorScopeKeys}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of ancestorScopeKeys elements to set
   * @return A modified copy of {@code this} object
   */
  @Deprecated
  public final ImmutableProcessInstanceModificationRecordValue withAncestorScopeKeys(Iterable<? extends Long> elements) {
    if (this.ancestorScopeKeys == elements) return this;
    Set<Long> newValue = createUnmodifiableSet(createSafeList(elements, false, false));
    return new ImmutableProcessInstanceModificationRecordValue(
        this.processInstanceKey,
        this.tenantId,
        this.terminateInstructions,
        this.activateInstructions,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProcessInstanceModificationRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProcessInstanceModificationRecordValue
        && equalTo(0, (ImmutableProcessInstanceModificationRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableProcessInstanceModificationRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return processInstanceKey == another.processInstanceKey
        && Objects.equals(tenantId, another.tenantId)
        && terminateInstructions.equals(another.terminateInstructions)
        && activateInstructions.equals(another.activateInstructions)
        && ancestorScopeKeys.equals(another.ancestorScopeKeys);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code processInstanceKey}, {@code tenantId}, {@code terminateInstructions}, {@code activateInstructions}, {@code ancestorScopeKeys}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Long.hashCode(processInstanceKey);
    h += (h << 5) + Objects.hashCode(tenantId);
    h += (h << 5) + terminateInstructions.hashCode();
    h += (h << 5) + activateInstructions.hashCode();
    h += (h << 5) + ancestorScopeKeys.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ProcessInstanceModificationRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProcessInstanceModificationRecordValue{"
        + "processInstanceKey=" + processInstanceKey
        + ", tenantId=" + tenantId
        + ", terminateInstructions=" + terminateInstructions
        + ", activateInstructions=" + activateInstructions
        + ", ancestorScopeKeys=" + ancestorScopeKeys
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ProcessInstanceModificationRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProcessInstanceModificationRecordValue instance
   */
  public static ImmutableProcessInstanceModificationRecordValue copyOf(ProcessInstanceModificationRecordValue instance) {
    if (instance instanceof ImmutableProcessInstanceModificationRecordValue) {
      return (ImmutableProcessInstanceModificationRecordValue) instance;
    }
    return ImmutableProcessInstanceModificationRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProcessInstanceModificationRecordValue ImmutableProcessInstanceModificationRecordValue}.
   * <pre>
   * ImmutableProcessInstanceModificationRecordValue.builder()
   *    .withProcessInstanceKey(long) // optional {@link ProcessInstanceModificationRecordValue#getProcessInstanceKey() processInstanceKey}
   *    .withTenantId(String | null) // nullable {@link ProcessInstanceModificationRecordValue#getTenantId() tenantId}
   *    .addTerminateInstruction|addAllTerminateInstructions(io.camunda.zeebe.protocol.record.value.ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue) // {@link ProcessInstanceModificationRecordValue#getTerminateInstructions() terminateInstructions} elements
   *    .addActivateInstruction|addAllActivateInstructions(io.camunda.zeebe.protocol.record.value.ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue) // {@link ProcessInstanceModificationRecordValue#getActivateInstructions() activateInstructions} elements
   *    .addAncestorScopeKey|addAllAncestorScopeKeys(Long) // {@link ProcessInstanceModificationRecordValue#getAncestorScopeKeys() ancestorScopeKeys} elements
   *    .build();
   * </pre>
   * @return A new ImmutableProcessInstanceModificationRecordValue builder
   */
  public static ImmutableProcessInstanceModificationRecordValue.Builder builder() {
    return new ImmutableProcessInstanceModificationRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProcessInstanceModificationRecordValue ImmutableProcessInstanceModificationRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProcessInstanceModificationRecordValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private long processInstanceKey;
    private String tenantId;
    private List<ImmutableProcessInstanceModificationTerminateInstructionValue.Builder> terminateInstructions = new ArrayList<ImmutableProcessInstanceModificationTerminateInstructionValue.Builder>();
    private List<ImmutableProcessInstanceModificationActivateInstructionValue.Builder> activateInstructions = new ArrayList<ImmutableProcessInstanceModificationActivateInstructionValue.Builder>();
    private List<Long> ancestorScopeKeys = new ArrayList<Long>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessInstanceRelated instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.ProcessInstanceModificationRecordValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessInstanceModificationRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.TenantOwned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TenantOwned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof ProcessInstanceRelated) {
        ProcessInstanceRelated instance = (ProcessInstanceRelated) object;
        if ((bits & 0x1L) == 0) {
          withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
      }
      if (object instanceof ProcessInstanceModificationRecordValue) {
        ProcessInstanceModificationRecordValue instance = (ProcessInstanceModificationRecordValue) object;
        if ((bits & 0x2L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x1L) == 0) {
          withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
        addAllAncestorScopeKeys(instance.getAncestorScopeKeys());
        addAllActivateInstructions(instance.getActivateInstructions());
        addAllTerminateInstructions(instance.getTerminateInstructions());
      }
      if (object instanceof TenantOwned) {
        TenantOwned instance = (TenantOwned) object;
        if ((bits & 0x2L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x2L;
        }
      }
    }

    /**
     * Initializes the value for the {@link ProcessInstanceModificationRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
     * @param processInstanceKey The value for processInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessInstanceKey(long processInstanceKey) {
      this.processInstanceKey = processInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceModificationRecordValue#getTenantId() tenantId} attribute.
     * @param tenantId The value for tenantId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTenantId(String tenantId) {
      this.tenantId = tenantId;
      return this;
    }

    /**
     * Adds one element to {@link ProcessInstanceModificationRecordValue#getTerminateInstructions() terminateInstructions} list.
     * @param element A terminateInstructions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addTerminateInstruction(ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue element) {
      if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationTerminateInstructionValue(element);
      this.terminateInstructions.add(ImmutableProcessInstanceModificationTerminateInstructionValue.builder().from(element));
      return this;
    }

    /**
     * Adds elements to {@link ProcessInstanceModificationRecordValue#getTerminateInstructions() terminateInstructions} list.
     * @param elements An array of terminateInstructions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addTerminateInstructions(ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue... elements) {
      for (ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationTerminateInstructionValue(element);
        this.terminateInstructions.add(ImmutableProcessInstanceModificationTerminateInstructionValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds a new builder to the {@link ProcessInstanceModificationRecordValue#getTerminateInstructions() terminateInstructions} list and returns
     * the builder.
     */
    public final ImmutableProcessInstanceModificationTerminateInstructionValue.Builder addTerminateInstructionBuilder() {
      ImmutableProcessInstanceModificationTerminateInstructionValue.Builder builder = ImmutableProcessInstanceModificationTerminateInstructionValue.builder();
      this.terminateInstructions.add(builder);
      return builder;
    }

    /**
     * Adds elements to {@link ProcessInstanceModificationRecordValue#getTerminateInstructions() terminateInstructions} list.
     * @param elements An array of terminateInstructions builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTerminateInstructionBuilders(ImmutableProcessInstanceModificationTerminateInstructionValue.Builder... elements) {
      for (ImmutableProcessInstanceModificationTerminateInstructionValue.Builder element : elements) {
        this.terminateInstructions.add(element);
      }
      return this;
    }

    /**
     * Gets the builder elements to {@link ProcessInstanceModificationRecordValue#getTerminateInstructions() terminateInstructions} list.
     * @return {@code this} unmodifiable list of modifiable builders.
     */
    public final List<ImmutableProcessInstanceModificationTerminateInstructionValue.Builder> terminateInstructionBuilders() {
      return createUnmodifiableList(false, this.terminateInstructions);
    }

    /**
     * Sets or replaces all elements for {@link ProcessInstanceModificationRecordValue#getTerminateInstructions() terminateInstructions} list.
     * @param elements An iterable of terminateInstructions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTerminateInstructions(Iterable<? extends ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue> elements) {
      this.terminateInstructions.clear();
      return addAllTerminateInstructions(elements);
    }

    /**
     * Adds elements to {@link ProcessInstanceModificationRecordValue#getTerminateInstructions() terminateInstructions} list.
     * @param elements An iterable of terminateInstructions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTerminateInstructions(Iterable<? extends ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue> elements) {
      for (ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationTerminateInstructionValue(element);
        this.terminateInstructions.add(ImmutableProcessInstanceModificationTerminateInstructionValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds elements to {@link ProcessInstanceModificationRecordValue#getTerminateInstructions() terminateInstructions} list.
     * @param elements An iterable of terminateInstructions builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTerminateInstructionBuilders(Iterable<ImmutableProcessInstanceModificationTerminateInstructionValue.Builder> elements) {
      for (ImmutableProcessInstanceModificationTerminateInstructionValue.Builder element : elements) {
        this.terminateInstructions.add(element);
      }
      return this;
    }

    /**
     * Adds one element to {@link ProcessInstanceModificationRecordValue#getActivateInstructions() activateInstructions} list.
     * @param element A activateInstructions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addActivateInstruction(ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue element) {
      if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationActivateInstructionValue(element);
      this.activateInstructions.add(ImmutableProcessInstanceModificationActivateInstructionValue.builder().from(element));
      return this;
    }

    /**
     * Adds elements to {@link ProcessInstanceModificationRecordValue#getActivateInstructions() activateInstructions} list.
     * @param elements An array of activateInstructions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addActivateInstructions(ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue... elements) {
      for (ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationActivateInstructionValue(element);
        this.activateInstructions.add(ImmutableProcessInstanceModificationActivateInstructionValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds a new builder to the {@link ProcessInstanceModificationRecordValue#getActivateInstructions() activateInstructions} list and returns
     * the builder.
     */
    public final ImmutableProcessInstanceModificationActivateInstructionValue.Builder addActivateInstructionBuilder() {
      ImmutableProcessInstanceModificationActivateInstructionValue.Builder builder = ImmutableProcessInstanceModificationActivateInstructionValue.builder();
      this.activateInstructions.add(builder);
      return builder;
    }

    /**
     * Adds elements to {@link ProcessInstanceModificationRecordValue#getActivateInstructions() activateInstructions} list.
     * @param elements An array of activateInstructions builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllActivateInstructionBuilders(ImmutableProcessInstanceModificationActivateInstructionValue.Builder... elements) {
      for (ImmutableProcessInstanceModificationActivateInstructionValue.Builder element : elements) {
        this.activateInstructions.add(element);
      }
      return this;
    }

    /**
     * Gets the builder elements to {@link ProcessInstanceModificationRecordValue#getActivateInstructions() activateInstructions} list.
     * @return {@code this} unmodifiable list of modifiable builders.
     */
    public final List<ImmutableProcessInstanceModificationActivateInstructionValue.Builder> activateInstructionBuilders() {
      return createUnmodifiableList(false, this.activateInstructions);
    }

    /**
     * Sets or replaces all elements for {@link ProcessInstanceModificationRecordValue#getActivateInstructions() activateInstructions} list.
     * @param elements An iterable of activateInstructions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withActivateInstructions(Iterable<? extends ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> elements) {
      this.activateInstructions.clear();
      return addAllActivateInstructions(elements);
    }

    /**
     * Adds elements to {@link ProcessInstanceModificationRecordValue#getActivateInstructions() activateInstructions} list.
     * @param elements An iterable of activateInstructions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllActivateInstructions(Iterable<? extends ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> elements) {
      for (ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationActivateInstructionValue(element);
        this.activateInstructions.add(ImmutableProcessInstanceModificationActivateInstructionValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds elements to {@link ProcessInstanceModificationRecordValue#getActivateInstructions() activateInstructions} list.
     * @param elements An iterable of activateInstructions builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllActivateInstructionBuilders(Iterable<ImmutableProcessInstanceModificationActivateInstructionValue.Builder> elements) {
      for (ImmutableProcessInstanceModificationActivateInstructionValue.Builder element : elements) {
        this.activateInstructions.add(element);
      }
      return this;
    }

    /**
     * Adds one element to {@link ProcessInstanceModificationRecordValue#getAncestorScopeKeys() ancestorScopeKeys} set.
     * @param element A ancestorScopeKeys element
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder addAncestorScopeKey(Long element) {
      this.ancestorScopeKeys.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ProcessInstanceModificationRecordValue#getAncestorScopeKeys() ancestorScopeKeys} set.
     * @param elements An array of ancestorScopeKeys elements
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder addAncestorScopeKeys(Long... elements) {
      for (Long element : elements) {
        this.ancestorScopeKeys.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ProcessInstanceModificationRecordValue#getAncestorScopeKeys() ancestorScopeKeys} set.
     * @param elements An iterable of ancestorScopeKeys elements
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder withAncestorScopeKeys(Iterable<? extends Long> elements) {
      this.ancestorScopeKeys.clear();
      return addAllAncestorScopeKeys(elements);
    }

    /**
     * Adds elements to {@link ProcessInstanceModificationRecordValue#getAncestorScopeKeys() ancestorScopeKeys} set.
     * @param elements An iterable of ancestorScopeKeys elements
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder addAllAncestorScopeKeys(Iterable<? extends Long> elements) {
      for (Long element : elements) {
        this.ancestorScopeKeys.add(element);
      }
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.processInstanceKey = 0;
      this.tenantId = null;
      this.terminateInstructions.clear();
      this.activateInstructions.clear();
      this.ancestorScopeKeys.clear();
      return this;
    }

    /**
     * Builds a new {@link ImmutableProcessInstanceModificationRecordValue ImmutableProcessInstanceModificationRecordValue}.
     * @return An immutable instance of ProcessInstanceModificationRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProcessInstanceModificationRecordValue build() {
      return new ImmutableProcessInstanceModificationRecordValue(
          processInstanceKey,
          tenantId,
          createUnmodifiableList(true, convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationTerminateInstructionValue(terminateInstructions)),
          createUnmodifiableList(true, convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationActivateInstructionValue(activateInstructions)),
          createUnmodifiableSet(ancestorScopeKeys));
    }



    
    private static ImmutableProcessInstanceModificationTerminateInstructionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationTerminateInstructionValue( ImmutableProcessInstanceModificationTerminateInstructionValue.Builder builder) {
      if (builder == null) return null;
      return builder.build();
    }

    
    private static ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationTerminateInstructionValue( ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue value) {
      if (value == null) return null;
      return ImmutableProcessInstanceModificationTerminateInstructionValue.builder().from(value).build();
    }

    
    private static ImmutableProcessInstanceModificationTerminateInstructionValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationTerminateInstructionValue( ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue value) {
      if (value == null) return null;
      return ImmutableProcessInstanceModificationTerminateInstructionValue.builder().from(value);
    }

    
    private static ImmutableProcessInstanceModificationActivateInstructionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationActivateInstructionValue( ImmutableProcessInstanceModificationActivateInstructionValue.Builder builder) {
      if (builder == null) return null;
      return builder.build();
    }

    
    private static ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationActivateInstructionValue( ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue value) {
      if (value == null) return null;
      return ImmutableProcessInstanceModificationActivateInstructionValue.builder().from(value).build();
    }

    
    private static ImmutableProcessInstanceModificationActivateInstructionValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationActivateInstructionValue( ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue value) {
      if (value == null) return null;
      return ImmutableProcessInstanceModificationActivateInstructionValue.builder().from(value);
    }

    private static List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationTerminateInstructionValue(Iterable<? extends ImmutableProcessInstanceModificationTerminateInstructionValue.Builder> builderList) {
      ArrayList<ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue> list;
      if (builderList instanceof Collection<?>) {
        int size = ((Collection<?>) builderList).size();
        if (size == 0) return Collections.emptyList();
      }
      list = new ArrayList<>();
      for (ImmutableProcessInstanceModificationTerminateInstructionValue.Builder element : builderList) {
        list.add(element.build());
      }
      return list;
    }

    private static List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationTerminateInstructionValue(ImmutableProcessInstanceModificationTerminateInstructionValue.Builder... builderArray) {
      ArrayList<ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue> list;
      if (builderArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>();
      for (ImmutableProcessInstanceModificationTerminateInstructionValue.Builder element : builderArray) {
        list.add(element.build());
      }
      return list;
    }

    private static List<ImmutableProcessInstanceModificationTerminateInstructionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationTerminateInstructionValue(Iterable<? extends ImmutableProcessInstanceModificationTerminateInstructionValue> valueList) {
      ArrayList<ImmutableProcessInstanceModificationTerminateInstructionValue.Builder> list;
      if (valueList instanceof Collection<?>) {
        int size = ((Collection<?>) valueList).size();
        if (size == 0) return Collections.emptyList();
      }
      list = new ArrayList<>();
      for (ImmutableProcessInstanceModificationTerminateInstructionValue element : valueList) {
        list.add(ImmutableProcessInstanceModificationTerminateInstructionValue.builder().from(element));
      }
      return list;
    }

    private static List<ImmutableProcessInstanceModificationTerminateInstructionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationTerminateInstructionValue(ImmutableProcessInstanceModificationTerminateInstructionValue... valueArray) {
      ArrayList<ImmutableProcessInstanceModificationTerminateInstructionValue.Builder> list;
      if (valueArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>();
      for (ImmutableProcessInstanceModificationTerminateInstructionValue element : valueArray) {
        list.add(ImmutableProcessInstanceModificationTerminateInstructionValue.builder().from(element));
      }
      return list;
    }
    private static List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationActivateInstructionValue(Iterable<? extends ImmutableProcessInstanceModificationActivateInstructionValue.Builder> builderList) {
      ArrayList<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> list;
      if (builderList instanceof Collection<?>) {
        int size = ((Collection<?>) builderList).size();
        if (size == 0) return Collections.emptyList();
      }
      list = new ArrayList<>();
      for (ImmutableProcessInstanceModificationActivateInstructionValue.Builder element : builderList) {
        list.add(element.build());
      }
      return list;
    }

    private static List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationActivateInstructionValue(ImmutableProcessInstanceModificationActivateInstructionValue.Builder... builderArray) {
      ArrayList<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> list;
      if (builderArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>();
      for (ImmutableProcessInstanceModificationActivateInstructionValue.Builder element : builderArray) {
        list.add(element.build());
      }
      return list;
    }

    private static List<ImmutableProcessInstanceModificationActivateInstructionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationActivateInstructionValue(Iterable<? extends ImmutableProcessInstanceModificationActivateInstructionValue> valueList) {
      ArrayList<ImmutableProcessInstanceModificationActivateInstructionValue.Builder> list;
      if (valueList instanceof Collection<?>) {
        int size = ((Collection<?>) valueList).size();
        if (size == 0) return Collections.emptyList();
      }
      list = new ArrayList<>();
      for (ImmutableProcessInstanceModificationActivateInstructionValue element : valueList) {
        list.add(ImmutableProcessInstanceModificationActivateInstructionValue.builder().from(element));
      }
      return list;
    }

    private static List<ImmutableProcessInstanceModificationActivateInstructionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationActivateInstructionValue(ImmutableProcessInstanceModificationActivateInstructionValue... valueArray) {
      ArrayList<ImmutableProcessInstanceModificationActivateInstructionValue.Builder> list;
      if (valueArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>();
      for (ImmutableProcessInstanceModificationActivateInstructionValue element : valueArray) {
        list.add(ImmutableProcessInstanceModificationActivateInstructionValue.builder().from(element));
      }
      return list;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size());
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }



  
  private static ImmutableProcessInstanceModificationTerminateInstructionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationTerminateInstructionValue( ImmutableProcessInstanceModificationTerminateInstructionValue.Builder builder) {
    if (builder == null) return null;
    return builder.build();
  }

  
  private static ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationTerminateInstructionValue( ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue value) {
    if (value == null) return null;
    return ImmutableProcessInstanceModificationTerminateInstructionValue.builder().from(value).build();
  }

  
  private static ImmutableProcessInstanceModificationTerminateInstructionValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationTerminateInstructionValue( ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue value) {
    if (value == null) return null;
    return ImmutableProcessInstanceModificationTerminateInstructionValue.builder().from(value);
  }

  
  private static ImmutableProcessInstanceModificationActivateInstructionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationActivateInstructionValue( ImmutableProcessInstanceModificationActivateInstructionValue.Builder builder) {
    if (builder == null) return null;
    return builder.build();
  }

  
  private static ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationActivateInstructionValue( ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue value) {
    if (value == null) return null;
    return ImmutableProcessInstanceModificationActivateInstructionValue.builder().from(value).build();
  }

  
  private static ImmutableProcessInstanceModificationActivateInstructionValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationActivateInstructionValue( ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue value) {
    if (value == null) return null;
    return ImmutableProcessInstanceModificationActivateInstructionValue.builder().from(value);
  }

  private static List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationTerminateInstructionValue(Iterable<? extends ImmutableProcessInstanceModificationTerminateInstructionValue.Builder> builderList) {
    ArrayList<ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue> list;
    if (builderList instanceof Collection<?>) {
      int size = ((Collection<?>) builderList).size();
      if (size == 0) return Collections.emptyList();
    }
    list = new ArrayList<>();
    for (ImmutableProcessInstanceModificationTerminateInstructionValue.Builder element : builderList) {
      list.add(element.build());
    }
    return list;
  }

  private static List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationTerminateInstructionValue(ImmutableProcessInstanceModificationTerminateInstructionValue.Builder... builderArray) {
    ArrayList<ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue> list;
    if (builderArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>();
    for (ImmutableProcessInstanceModificationTerminateInstructionValue.Builder element : builderArray) {
      list.add(element.build());
    }
    return list;
  }

  private static List<ImmutableProcessInstanceModificationTerminateInstructionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationTerminateInstructionValue(Iterable<? extends ImmutableProcessInstanceModificationTerminateInstructionValue> valueList) {
    ArrayList<ImmutableProcessInstanceModificationTerminateInstructionValue.Builder> list;
    if (valueList instanceof Collection<?>) {
      int size = ((Collection<?>) valueList).size();
      if (size == 0) return Collections.emptyList();
    }
    list = new ArrayList<>();
    for (ImmutableProcessInstanceModificationTerminateInstructionValue element : valueList) {
      list.add(ImmutableProcessInstanceModificationTerminateInstructionValue.builder().from(element));
    }
    return list;
  }

  private static List<ImmutableProcessInstanceModificationTerminateInstructionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationTerminateInstructionValue(ImmutableProcessInstanceModificationTerminateInstructionValue... valueArray) {
    ArrayList<ImmutableProcessInstanceModificationTerminateInstructionValue.Builder> list;
    if (valueArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>();
    for (ImmutableProcessInstanceModificationTerminateInstructionValue element : valueArray) {
      list.add(ImmutableProcessInstanceModificationTerminateInstructionValue.builder().from(element));
    }
    return list;
  }
  private static List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationActivateInstructionValue(Iterable<? extends ImmutableProcessInstanceModificationActivateInstructionValue.Builder> builderList) {
    ArrayList<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> list;
    if (builderList instanceof Collection<?>) {
      int size = ((Collection<?>) builderList).size();
      if (size == 0) return Collections.emptyList();
    }
    list = new ArrayList<>();
    for (ImmutableProcessInstanceModificationActivateInstructionValue.Builder element : builderList) {
      list.add(element.build());
    }
    return list;
  }

  private static List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationActivateInstructionValue(ImmutableProcessInstanceModificationActivateInstructionValue.Builder... builderArray) {
    ArrayList<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> list;
    if (builderArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>();
    for (ImmutableProcessInstanceModificationActivateInstructionValue.Builder element : builderArray) {
      list.add(element.build());
    }
    return list;
  }

  private static List<ImmutableProcessInstanceModificationActivateInstructionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationActivateInstructionValue(Iterable<? extends ImmutableProcessInstanceModificationActivateInstructionValue> valueList) {
    ArrayList<ImmutableProcessInstanceModificationActivateInstructionValue.Builder> list;
    if (valueList instanceof Collection<?>) {
      int size = ((Collection<?>) valueList).size();
      if (size == 0) return Collections.emptyList();
    }
    list = new ArrayList<>();
    for (ImmutableProcessInstanceModificationActivateInstructionValue element : valueList) {
      list.add(ImmutableProcessInstanceModificationActivateInstructionValue.builder().from(element));
    }
    return list;
  }

  private static List<ImmutableProcessInstanceModificationActivateInstructionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationActivateInstructionValue(ImmutableProcessInstanceModificationActivateInstructionValue... valueArray) {
    ArrayList<ImmutableProcessInstanceModificationActivateInstructionValue.Builder> list;
    if (valueArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>();
    for (ImmutableProcessInstanceModificationActivateInstructionValue element : valueArray) {
      list.add(ImmutableProcessInstanceModificationActivateInstructionValue.builder().from(element));
    }
    return list;
  }
}
