package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SignalSubscriptionRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSignalSubscriptionRecordValue.builder()}.
 */
@Generated(from = "SignalSubscriptionRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableSignalSubscriptionRecordValue.Builder.class)
public final class ImmutableSignalSubscriptionRecordValue
    implements SignalSubscriptionRecordValue {
  private final String tenantId;
  private final long processDefinitionKey;
  private final String bpmnProcessId;
  private final String catchEventId;
  private final long catchEventInstanceKey;
  private final String signalName;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableSignalSubscriptionRecordValue(
      String tenantId,
      long processDefinitionKey,
      String bpmnProcessId,
      String catchEventId,
      long catchEventInstanceKey,
      String signalName) {
    this.tenantId = tenantId;
    this.processDefinitionKey = processDefinitionKey;
    this.bpmnProcessId = bpmnProcessId;
    this.catchEventId = catchEventId;
    this.catchEventInstanceKey = catchEventInstanceKey;
    this.signalName = signalName;
  }

  /**
   *Returns the identifier of the tenant that owns this entity. 
   */
  @Override
  public String getTenantId() {
    return tenantId;
  }

  /**
   * @return the process key tied to the subscription
   */
  @Override
  public long getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  /**
   * @return the BPMN process id tied to the subscription
   */
  @Override
  public String getBpmnProcessId() {
    return bpmnProcessId;
  }

  /**
   * @return the id of the catch event tied to the subscription
   */
  @Override
  public String getCatchEventId() {
    return catchEventId;
  }

  /**
   * @return the key of the catch event instance key tied to the subscription
   */
  @Override
  public long getCatchEventInstanceKey() {
    return catchEventInstanceKey;
  }

  /**
   * @return the name of the signal
   */
  @Override
  public String getSignalName() {
    return signalName;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SignalSubscriptionRecordValue#getTenantId() tenantId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenantId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSignalSubscriptionRecordValue withTenantId(String value) {
    if (Objects.equals(this.tenantId, value)) return this;
    return new ImmutableSignalSubscriptionRecordValue(
        value,
        this.processDefinitionKey,
        this.bpmnProcessId,
        this.catchEventId,
        this.catchEventInstanceKey,
        this.signalName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SignalSubscriptionRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processDefinitionKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSignalSubscriptionRecordValue withProcessDefinitionKey(long value) {
    if (this.processDefinitionKey == value) return this;
    return new ImmutableSignalSubscriptionRecordValue(
        this.tenantId,
        value,
        this.bpmnProcessId,
        this.catchEventId,
        this.catchEventInstanceKey,
        this.signalName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SignalSubscriptionRecordValue#getBpmnProcessId() bpmnProcessId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bpmnProcessId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSignalSubscriptionRecordValue withBpmnProcessId(String value) {
    if (Objects.equals(this.bpmnProcessId, value)) return this;
    return new ImmutableSignalSubscriptionRecordValue(
        this.tenantId,
        this.processDefinitionKey,
        value,
        this.catchEventId,
        this.catchEventInstanceKey,
        this.signalName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SignalSubscriptionRecordValue#getCatchEventId() catchEventId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for catchEventId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSignalSubscriptionRecordValue withCatchEventId(String value) {
    if (Objects.equals(this.catchEventId, value)) return this;
    return new ImmutableSignalSubscriptionRecordValue(
        this.tenantId,
        this.processDefinitionKey,
        this.bpmnProcessId,
        value,
        this.catchEventInstanceKey,
        this.signalName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SignalSubscriptionRecordValue#getCatchEventInstanceKey() catchEventInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for catchEventInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSignalSubscriptionRecordValue withCatchEventInstanceKey(long value) {
    if (this.catchEventInstanceKey == value) return this;
    return new ImmutableSignalSubscriptionRecordValue(
        this.tenantId,
        this.processDefinitionKey,
        this.bpmnProcessId,
        this.catchEventId,
        value,
        this.signalName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SignalSubscriptionRecordValue#getSignalName() signalName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for signalName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSignalSubscriptionRecordValue withSignalName(String value) {
    if (Objects.equals(this.signalName, value)) return this;
    return new ImmutableSignalSubscriptionRecordValue(
        this.tenantId,
        this.processDefinitionKey,
        this.bpmnProcessId,
        this.catchEventId,
        this.catchEventInstanceKey,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSignalSubscriptionRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSignalSubscriptionRecordValue
        && equalTo(0, (ImmutableSignalSubscriptionRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableSignalSubscriptionRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(tenantId, another.tenantId)
        && processDefinitionKey == another.processDefinitionKey
        && Objects.equals(bpmnProcessId, another.bpmnProcessId)
        && Objects.equals(catchEventId, another.catchEventId)
        && catchEventInstanceKey == another.catchEventInstanceKey
        && Objects.equals(signalName, another.signalName);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code tenantId}, {@code processDefinitionKey}, {@code bpmnProcessId}, {@code catchEventId}, {@code catchEventInstanceKey}, {@code signalName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(tenantId);
    h += (h << 5) + Long.hashCode(processDefinitionKey);
    h += (h << 5) + Objects.hashCode(bpmnProcessId);
    h += (h << 5) + Objects.hashCode(catchEventId);
    h += (h << 5) + Long.hashCode(catchEventInstanceKey);
    h += (h << 5) + Objects.hashCode(signalName);
    return h;
  }

  /**
   * Prints the immutable value {@code SignalSubscriptionRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SignalSubscriptionRecordValue{"
        + "tenantId=" + tenantId
        + ", processDefinitionKey=" + processDefinitionKey
        + ", bpmnProcessId=" + bpmnProcessId
        + ", catchEventId=" + catchEventId
        + ", catchEventInstanceKey=" + catchEventInstanceKey
        + ", signalName=" + signalName
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link SignalSubscriptionRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SignalSubscriptionRecordValue instance
   */
  public static ImmutableSignalSubscriptionRecordValue copyOf(SignalSubscriptionRecordValue instance) {
    if (instance instanceof ImmutableSignalSubscriptionRecordValue) {
      return (ImmutableSignalSubscriptionRecordValue) instance;
    }
    return ImmutableSignalSubscriptionRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSignalSubscriptionRecordValue ImmutableSignalSubscriptionRecordValue}.
   * <pre>
   * ImmutableSignalSubscriptionRecordValue.builder()
   *    .withTenantId(String | null) // nullable {@link SignalSubscriptionRecordValue#getTenantId() tenantId}
   *    .withProcessDefinitionKey(long) // optional {@link SignalSubscriptionRecordValue#getProcessDefinitionKey() processDefinitionKey}
   *    .withBpmnProcessId(String | null) // nullable {@link SignalSubscriptionRecordValue#getBpmnProcessId() bpmnProcessId}
   *    .withCatchEventId(String | null) // nullable {@link SignalSubscriptionRecordValue#getCatchEventId() catchEventId}
   *    .withCatchEventInstanceKey(long) // optional {@link SignalSubscriptionRecordValue#getCatchEventInstanceKey() catchEventInstanceKey}
   *    .withSignalName(String | null) // nullable {@link SignalSubscriptionRecordValue#getSignalName() signalName}
   *    .build();
   * </pre>
   * @return A new ImmutableSignalSubscriptionRecordValue builder
   */
  public static ImmutableSignalSubscriptionRecordValue.Builder builder() {
    return new ImmutableSignalSubscriptionRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSignalSubscriptionRecordValue ImmutableSignalSubscriptionRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SignalSubscriptionRecordValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private String tenantId;
    private long processDefinitionKey;
    private String bpmnProcessId;
    private String catchEventId;
    private long catchEventInstanceKey;
    private String signalName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.SignalSubscriptionRecordValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SignalSubscriptionRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.TenantOwned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TenantOwned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof SignalSubscriptionRecordValue) {
        SignalSubscriptionRecordValue instance = (SignalSubscriptionRecordValue) object;
        if ((bits & 0x1L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x1L;
        }
        String signalNameValue = instance.getSignalName();
        if (signalNameValue != null) {
          withSignalName(signalNameValue);
        }
        withCatchEventInstanceKey(instance.getCatchEventInstanceKey());
        String bpmnProcessIdValue = instance.getBpmnProcessId();
        if (bpmnProcessIdValue != null) {
          withBpmnProcessId(bpmnProcessIdValue);
        }
        String catchEventIdValue = instance.getCatchEventId();
        if (catchEventIdValue != null) {
          withCatchEventId(catchEventIdValue);
        }
        withProcessDefinitionKey(instance.getProcessDefinitionKey());
      }
      if (object instanceof TenantOwned) {
        TenantOwned instance = (TenantOwned) object;
        if ((bits & 0x1L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link SignalSubscriptionRecordValue#getTenantId() tenantId} attribute.
     * @param tenantId The value for tenantId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTenantId(String tenantId) {
      this.tenantId = tenantId;
      return this;
    }

    /**
     * Initializes the value for the {@link SignalSubscriptionRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
     * @param processDefinitionKey The value for processDefinitionKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessDefinitionKey(long processDefinitionKey) {
      this.processDefinitionKey = processDefinitionKey;
      return this;
    }

    /**
     * Initializes the value for the {@link SignalSubscriptionRecordValue#getBpmnProcessId() bpmnProcessId} attribute.
     * @param bpmnProcessId The value for bpmnProcessId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withBpmnProcessId(String bpmnProcessId) {
      this.bpmnProcessId = bpmnProcessId;
      return this;
    }

    /**
     * Initializes the value for the {@link SignalSubscriptionRecordValue#getCatchEventId() catchEventId} attribute.
     * @param catchEventId The value for catchEventId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withCatchEventId(String catchEventId) {
      this.catchEventId = catchEventId;
      return this;
    }

    /**
     * Initializes the value for the {@link SignalSubscriptionRecordValue#getCatchEventInstanceKey() catchEventInstanceKey} attribute.
     * @param catchEventInstanceKey The value for catchEventInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withCatchEventInstanceKey(long catchEventInstanceKey) {
      this.catchEventInstanceKey = catchEventInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link SignalSubscriptionRecordValue#getSignalName() signalName} attribute.
     * @param signalName The value for signalName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withSignalName(String signalName) {
      this.signalName = signalName;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.tenantId = null;
      this.processDefinitionKey = 0;
      this.bpmnProcessId = null;
      this.catchEventId = null;
      this.catchEventInstanceKey = 0;
      this.signalName = null;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSignalSubscriptionRecordValue ImmutableSignalSubscriptionRecordValue}.
     * @return An immutable instance of SignalSubscriptionRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSignalSubscriptionRecordValue build() {
      return new ImmutableSignalSubscriptionRecordValue(
          tenantId,
          processDefinitionKey,
          bpmnProcessId,
          catchEventId,
          catchEventInstanceKey,
          signalName);
    }



  }



}
