/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.management;

import io.camunda.zeebe.protocol.management.LargeGroupSizeEncodingDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.CompositeEncoderFlyweight;

public final class LargeGroupSizeEncodingEncoder
implements CompositeEncoderFlyweight {
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final String SEMANTIC_VERSION = "8.4.13";
    public static final int ENCODED_LENGTH = 8;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private int offset;
    private MutableDirectBuffer buffer;

    public LargeGroupSizeEncodingEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        return this;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public int encodedLength() {
        return 8;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public static int blockLengthEncodingOffset() {
        return 0;
    }

    public static int blockLengthEncodingLength() {
        return 2;
    }

    public static int blockLengthNullValue() {
        return 65535;
    }

    public static int blockLengthMinValue() {
        return 0;
    }

    public static int blockLengthMaxValue() {
        return 65534;
    }

    public LargeGroupSizeEncodingEncoder blockLength(int value) {
        this.buffer.putShort(this.offset + 0, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int numInGroupEncodingOffset() {
        return 2;
    }

    public static int numInGroupEncodingLength() {
        return 2;
    }

    public static int numInGroupNullValue() {
        return 65535;
    }

    public static int numInGroupMinValue() {
        return 0;
    }

    public static int numInGroupMaxValue() {
        return 65534;
    }

    public LargeGroupSizeEncodingEncoder numInGroup(int value) {
        this.buffer.putShort(this.offset + 2, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int numGroupsEncodingOffset() {
        return 4;
    }

    public static int numGroupsEncodingLength() {
        return 2;
    }

    public static int numGroupsNullValue() {
        return 65535;
    }

    public static int numGroupsMinValue() {
        return 0;
    }

    public static int numGroupsMaxValue() {
        return 65534;
    }

    public LargeGroupSizeEncodingEncoder numGroups(int value) {
        this.buffer.putShort(this.offset + 4, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int numVarDataFieldsEncodingOffset() {
        return 6;
    }

    public static int numVarDataFieldsEncodingLength() {
        return 2;
    }

    public static int numVarDataFieldsNullValue() {
        return 65535;
    }

    public static int numVarDataFieldsMinValue() {
        return 0;
    }

    public static int numVarDataFieldsMaxValue() {
        return 65534;
    }

    public LargeGroupSizeEncodingEncoder numVarDataFields(int value) {
        this.buffer.putShort(this.offset + 6, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        LargeGroupSizeEncodingDecoder decoder = new LargeGroupSizeEncodingDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset);
        return decoder.appendTo(builder);
    }
}

