/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record;

import io.camunda.zeebe.protocol.record.MessageHeaderDecoder;
import io.camunda.zeebe.protocol.record.MetaAttribute;
import io.camunda.zeebe.protocol.record.PartitionHealthStatus;
import io.camunda.zeebe.protocol.record.PartitionRole;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class BrokerInfoDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 16;
    public static final int TEMPLATE_ID = 201;
    public static final int SCHEMA_ID = 0;
    public static final int SCHEMA_VERSION = 4;
    public static final String SEMANTIC_VERSION = "8.4.9";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final BrokerInfoDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private final AddressesDecoder addresses = new AddressesDecoder(this);
    private final PartitionRolesDecoder partitionRoles = new PartitionRolesDecoder(this);
    private final PartitionLeaderTermsDecoder partitionLeaderTerms = new PartitionLeaderTermsDecoder(this);
    private final PartitionHealthDecoder partitionHealth = new PartitionHealthDecoder(this);

    public int sbeBlockLength() {
        return 16;
    }

    public int sbeTemplateId() {
        return 201;
    }

    public int sbeSchemaId() {
        return 0;
    }

    public int sbeSchemaVersion() {
        return 4;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public BrokerInfoDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public BrokerInfoDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (201 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public BrokerInfoDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int nodeIdId() {
        return 1;
    }

    public static int nodeIdSinceVersion() {
        return 0;
    }

    public static int nodeIdEncodingOffset() {
        return 0;
    }

    public static int nodeIdEncodingLength() {
        return 4;
    }

    public static String nodeIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int nodeIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int nodeIdMinValue() {
        return -2147483647;
    }

    public static int nodeIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int nodeId() {
        return this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int partitionsCountId() {
        return 2;
    }

    public static int partitionsCountSinceVersion() {
        return 0;
    }

    public static int partitionsCountEncodingOffset() {
        return 4;
    }

    public static int partitionsCountEncodingLength() {
        return 4;
    }

    public static String partitionsCountMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int partitionsCountNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int partitionsCountMinValue() {
        return -2147483647;
    }

    public static int partitionsCountMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int partitionsCount() {
        return this.buffer.getInt(this.offset + 4, ByteOrder.LITTLE_ENDIAN);
    }

    public static int clusterSizeId() {
        return 3;
    }

    public static int clusterSizeSinceVersion() {
        return 0;
    }

    public static int clusterSizeEncodingOffset() {
        return 8;
    }

    public static int clusterSizeEncodingLength() {
        return 4;
    }

    public static String clusterSizeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int clusterSizeNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int clusterSizeMinValue() {
        return -2147483647;
    }

    public static int clusterSizeMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int clusterSize() {
        return this.buffer.getInt(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int replicationFactorId() {
        return 4;
    }

    public static int replicationFactorSinceVersion() {
        return 0;
    }

    public static int replicationFactorEncodingOffset() {
        return 12;
    }

    public static int replicationFactorEncodingLength() {
        return 4;
    }

    public static String replicationFactorMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int replicationFactorNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int replicationFactorMinValue() {
        return -2147483647;
    }

    public static int replicationFactorMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int replicationFactor() {
        return this.buffer.getInt(this.offset + 12, ByteOrder.LITTLE_ENDIAN);
    }

    public static long addressesDecoderId() {
        return 5L;
    }

    public static int addressesDecoderSinceVersion() {
        return 0;
    }

    public AddressesDecoder addresses() {
        this.addresses.wrap(this.buffer);
        return this.addresses;
    }

    public static long partitionRolesDecoderId() {
        return 8L;
    }

    public static int partitionRolesDecoderSinceVersion() {
        return 0;
    }

    public PartitionRolesDecoder partitionRoles() {
        this.partitionRoles.wrap(this.buffer);
        return this.partitionRoles;
    }

    public static long partitionLeaderTermsDecoderId() {
        return 11L;
    }

    public static int partitionLeaderTermsDecoderSinceVersion() {
        return 0;
    }

    public PartitionLeaderTermsDecoder partitionLeaderTerms() {
        this.partitionLeaderTerms.wrap(this.buffer);
        return this.partitionLeaderTerms;
    }

    public static long partitionHealthDecoderId() {
        return 15L;
    }

    public static int partitionHealthDecoderSinceVersion() {
        return 3;
    }

    public PartitionHealthDecoder partitionHealth() {
        if (this.parentMessage.actingVersion < 3) {
            this.partitionHealth.count = 0;
            this.partitionHealth.index = 0;
            return this.partitionHealth;
        }
        this.partitionHealth.wrap(this.buffer);
        return this.partitionHealth;
    }

    public static int versionId() {
        return 14;
    }

    public static int versionSinceVersion() {
        return 0;
    }

    public static String versionCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String versionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int versionHeaderLength() {
        return 4;
    }

    public int versionLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipVersion() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getVersion(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getVersion(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapVersion(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String version() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        BrokerInfoDecoder decoder = new BrokerInfoDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[BrokerInfo](sbeTemplateId=");
        builder.append(201);
        builder.append("|sbeSchemaId=");
        builder.append(0);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 4) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(4);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 16) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(16);
        builder.append("):");
        builder.append("nodeId=");
        builder.append(this.nodeId());
        builder.append('|');
        builder.append("partitionsCount=");
        builder.append(this.partitionsCount());
        builder.append('|');
        builder.append("clusterSize=");
        builder.append(this.clusterSize());
        builder.append('|');
        builder.append("replicationFactor=");
        builder.append(this.replicationFactor());
        builder.append('|');
        builder.append("addresses=[");
        int addressesOriginalOffset = this.addresses.offset;
        int addressesOriginalIndex = this.addresses.index;
        AddressesDecoder addresses = this.addresses();
        if (addresses.count() > 0) {
            while (addresses.hasNext()) {
                addresses.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        addresses.offset = addressesOriginalOffset;
        addresses.index = addressesOriginalIndex;
        builder.append(']');
        builder.append('|');
        builder.append("partitionRoles=[");
        int partitionRolesOriginalOffset = this.partitionRoles.offset;
        int partitionRolesOriginalIndex = this.partitionRoles.index;
        PartitionRolesDecoder partitionRoles = this.partitionRoles();
        if (partitionRoles.count() > 0) {
            while (partitionRoles.hasNext()) {
                partitionRoles.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        partitionRoles.offset = partitionRolesOriginalOffset;
        partitionRoles.index = partitionRolesOriginalIndex;
        builder.append(']');
        builder.append('|');
        builder.append("partitionLeaderTerms=[");
        int partitionLeaderTermsOriginalOffset = this.partitionLeaderTerms.offset;
        int partitionLeaderTermsOriginalIndex = this.partitionLeaderTerms.index;
        PartitionLeaderTermsDecoder partitionLeaderTerms = this.partitionLeaderTerms();
        if (partitionLeaderTerms.count() > 0) {
            while (partitionLeaderTerms.hasNext()) {
                partitionLeaderTerms.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        partitionLeaderTerms.offset = partitionLeaderTermsOriginalOffset;
        partitionLeaderTerms.index = partitionLeaderTermsOriginalIndex;
        builder.append(']');
        builder.append('|');
        builder.append("partitionHealth=[");
        int partitionHealthOriginalOffset = this.partitionHealth.offset;
        int partitionHealthOriginalIndex = this.partitionHealth.index;
        PartitionHealthDecoder partitionHealth = this.partitionHealth();
        if (partitionHealth.count() > 0) {
            while (partitionHealth.hasNext()) {
                partitionHealth.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        partitionHealth.offset = partitionHealthOriginalOffset;
        partitionHealth.index = partitionHealthOriginalIndex;
        builder.append(']');
        builder.append('|');
        builder.append("version=");
        builder.append('\'').append(this.version()).append('\'');
        this.limit(originalLimit);
        return builder;
    }

    public BrokerInfoDecoder sbeSkip() {
        PartitionHealthDecoder partitionHealth;
        PartitionLeaderTermsDecoder partitionLeaderTerms;
        PartitionRolesDecoder partitionRoles;
        this.sbeRewind();
        AddressesDecoder addresses = this.addresses();
        if (addresses.count() > 0) {
            while (addresses.hasNext()) {
                addresses.next();
                addresses.sbeSkip();
            }
        }
        if ((partitionRoles = this.partitionRoles()).count() > 0) {
            while (partitionRoles.hasNext()) {
                partitionRoles.next();
                partitionRoles.sbeSkip();
            }
        }
        if ((partitionLeaderTerms = this.partitionLeaderTerms()).count() > 0) {
            while (partitionLeaderTerms.hasNext()) {
                partitionLeaderTerms.next();
                partitionLeaderTerms.sbeSkip();
            }
        }
        if ((partitionHealth = this.partitionHealth()).count() > 0) {
            while (partitionHealth.hasNext()) {
                partitionHealth.next();
                partitionHealth.sbeSkip();
            }
        }
        this.skipVersion();
        return this;
    }

    public static final class AddressesDecoder
    implements Iterable<AddressesDecoder>,
    Iterator<AddressesDecoder> {
        public static final int HEADER_SIZE = 3;
        private final BrokerInfoDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        AddressesDecoder(BrokerInfoDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            this.blockLength = buffer.getShort(limit + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.count = (short)(buffer.getByte(limit + 2) & 0xFF);
        }

        @Override
        public AddressesDecoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 0;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<AddressesDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public static int apiNameId() {
            return 6;
        }

        public static int apiNameSinceVersion() {
            return 0;
        }

        public static String apiNameCharacterEncoding() {
            return StandardCharsets.UTF_8.name();
        }

        public static String apiNameMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int apiNameHeaderLength() {
            return 4;
        }

        public int apiNameLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        }

        public int skipApiName() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getApiName(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getApiName(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapApiName(DirectBuffer wrapBuffer) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
        }

        public String apiName() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            return new String(tmp, StandardCharsets.UTF_8);
        }

        public static int addressId() {
            return 7;
        }

        public static int addressSinceVersion() {
            return 0;
        }

        public static String addressCharacterEncoding() {
            return StandardCharsets.UTF_8.name();
        }

        public static String addressMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int addressHeaderLength() {
            return 4;
        }

        public int addressLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        }

        public int skipAddress() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getAddress(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getAddress(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapAddress(DirectBuffer wrapBuffer) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
        }

        public String address() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            return new String(tmp, StandardCharsets.UTF_8);
        }

        public StringBuilder appendTo(StringBuilder builder) {
            if (null == this.buffer) {
                return builder;
            }
            builder.append('(');
            builder.append("apiName=");
            builder.append('\'').append(this.apiName()).append('\'');
            builder.append('|');
            builder.append("address=");
            builder.append('\'').append(this.address()).append('\'');
            builder.append(')');
            return builder;
        }

        public AddressesDecoder sbeSkip() {
            this.skipApiName();
            this.skipAddress();
            return this;
        }
    }

    public static final class PartitionRolesDecoder
    implements Iterable<PartitionRolesDecoder>,
    Iterator<PartitionRolesDecoder> {
        public static final int HEADER_SIZE = 3;
        private final BrokerInfoDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        PartitionRolesDecoder(BrokerInfoDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            this.blockLength = buffer.getShort(limit + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.count = (short)(buffer.getByte(limit + 2) & 0xFF);
        }

        @Override
        public PartitionRolesDecoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 5;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<PartitionRolesDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public static int partitionIdId() {
            return 9;
        }

        public static int partitionIdSinceVersion() {
            return 0;
        }

        public static int partitionIdEncodingOffset() {
            return 0;
        }

        public static int partitionIdEncodingLength() {
            return 4;
        }

        public static String partitionIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int partitionIdNullValue() {
            return Integer.MIN_VALUE;
        }

        public static int partitionIdMinValue() {
            return -2147483647;
        }

        public static int partitionIdMaxValue() {
            return Integer.MAX_VALUE;
        }

        public int partitionId() {
            return this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
        }

        public static int roleId() {
            return 10;
        }

        public static int roleSinceVersion() {
            return 0;
        }

        public static int roleEncodingOffset() {
            return 4;
        }

        public static int roleEncodingLength() {
            return 1;
        }

        public static String roleMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public short roleRaw() {
            return (short)(this.buffer.getByte(this.offset + 4) & 0xFF);
        }

        public PartitionRole role() {
            return PartitionRole.get((short)(this.buffer.getByte(this.offset + 4) & 0xFF));
        }

        public StringBuilder appendTo(StringBuilder builder) {
            if (null == this.buffer) {
                return builder;
            }
            builder.append('(');
            builder.append("partitionId=");
            builder.append(this.partitionId());
            builder.append('|');
            builder.append("role=");
            builder.append((Object)this.role());
            builder.append(')');
            return builder;
        }

        public PartitionRolesDecoder sbeSkip() {
            return this;
        }
    }

    public static final class PartitionLeaderTermsDecoder
    implements Iterable<PartitionLeaderTermsDecoder>,
    Iterator<PartitionLeaderTermsDecoder> {
        public static final int HEADER_SIZE = 3;
        private final BrokerInfoDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        PartitionLeaderTermsDecoder(BrokerInfoDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            this.blockLength = buffer.getShort(limit + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.count = (short)(buffer.getByte(limit + 2) & 0xFF);
        }

        @Override
        public PartitionLeaderTermsDecoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 12;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<PartitionLeaderTermsDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public static int partitionIdId() {
            return 12;
        }

        public static int partitionIdSinceVersion() {
            return 0;
        }

        public static int partitionIdEncodingOffset() {
            return 0;
        }

        public static int partitionIdEncodingLength() {
            return 4;
        }

        public static String partitionIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int partitionIdNullValue() {
            return Integer.MIN_VALUE;
        }

        public static int partitionIdMinValue() {
            return -2147483647;
        }

        public static int partitionIdMaxValue() {
            return Integer.MAX_VALUE;
        }

        public int partitionId() {
            return this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
        }

        public static int termId() {
            return 13;
        }

        public static int termSinceVersion() {
            return 0;
        }

        public static int termEncodingOffset() {
            return 4;
        }

        public static int termEncodingLength() {
            return 8;
        }

        public static String termMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long termNullValue() {
            return Long.MIN_VALUE;
        }

        public static long termMinValue() {
            return -9223372036854775807L;
        }

        public static long termMaxValue() {
            return Long.MAX_VALUE;
        }

        public long term() {
            return this.buffer.getLong(this.offset + 4, ByteOrder.LITTLE_ENDIAN);
        }

        public StringBuilder appendTo(StringBuilder builder) {
            if (null == this.buffer) {
                return builder;
            }
            builder.append('(');
            builder.append("partitionId=");
            builder.append(this.partitionId());
            builder.append('|');
            builder.append("term=");
            builder.append(this.term());
            builder.append(')');
            return builder;
        }

        public PartitionLeaderTermsDecoder sbeSkip() {
            return this;
        }
    }

    public static final class PartitionHealthDecoder
    implements Iterable<PartitionHealthDecoder>,
    Iterator<PartitionHealthDecoder> {
        public static final int HEADER_SIZE = 3;
        private final BrokerInfoDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        PartitionHealthDecoder(BrokerInfoDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            this.blockLength = buffer.getShort(limit + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.count = (short)(buffer.getByte(limit + 2) & 0xFF);
        }

        @Override
        public PartitionHealthDecoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 5;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<PartitionHealthDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public static int partitionIdId() {
            return 16;
        }

        public static int partitionIdSinceVersion() {
            return 0;
        }

        public static int partitionIdEncodingOffset() {
            return 0;
        }

        public static int partitionIdEncodingLength() {
            return 4;
        }

        public static String partitionIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int partitionIdNullValue() {
            return Integer.MIN_VALUE;
        }

        public static int partitionIdMinValue() {
            return -2147483647;
        }

        public static int partitionIdMaxValue() {
            return Integer.MAX_VALUE;
        }

        public int partitionId() {
            return this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
        }

        public static int healthStatusId() {
            return 17;
        }

        public static int healthStatusSinceVersion() {
            return 0;
        }

        public static int healthStatusEncodingOffset() {
            return 4;
        }

        public static int healthStatusEncodingLength() {
            return 1;
        }

        public static String healthStatusMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public short healthStatusRaw() {
            return (short)(this.buffer.getByte(this.offset + 4) & 0xFF);
        }

        public PartitionHealthStatus healthStatus() {
            return PartitionHealthStatus.get((short)(this.buffer.getByte(this.offset + 4) & 0xFF));
        }

        public StringBuilder appendTo(StringBuilder builder) {
            if (null == this.buffer) {
                return builder;
            }
            builder.append('(');
            builder.append("partitionId=");
            builder.append(this.partitionId());
            builder.append('|');
            builder.append("healthStatus=");
            builder.append((Object)this.healthStatus());
            builder.append(')');
            return builder;
        }

        public PartitionHealthDecoder sbeSkip() {
            return this;
        }
    }
}

