/* Generated SBE (Simple Binary Encoding) message codec. */
package io.camunda.zeebe.protocol.record;


/**
 * The type of a record value
 */
@SuppressWarnings("all")
public enum ValueType
{
    JOB((short)0),

    DEPLOYMENT((short)4),

    PROCESS_INSTANCE((short)5),

    INCIDENT((short)6),

    MESSAGE((short)10),

    MESSAGE_SUBSCRIPTION((short)11),

    PROCESS_MESSAGE_SUBSCRIPTION((short)12),

    JOB_BATCH((short)14),

    TIMER((short)15),

    MESSAGE_START_EVENT_SUBSCRIPTION((short)16),

    VARIABLE((short)17),

    VARIABLE_DOCUMENT((short)18),

    PROCESS_INSTANCE_CREATION((short)19),

    ERROR((short)20),

    PROCESS_INSTANCE_RESULT((short)21),

    PROCESS((short)22),

    DEPLOYMENT_DISTRIBUTION((short)23),

    PROCESS_EVENT((short)24),

    DECISION((short)25),

    DECISION_REQUIREMENTS((short)26),

    DECISION_EVALUATION((short)27),

    PROCESS_INSTANCE_MODIFICATION((short)28),

    ESCALATION((short)29),

    SIGNAL_SUBSCRIPTION((short)30),

    SIGNAL((short)31),

    RESOURCE_DELETION((short)32),

    COMMAND_DISTRIBUTION((short)33),

    PROCESS_INSTANCE_BATCH((short)34),

    MESSAGE_BATCH((short)35),

    FORM((short)36),

    USER_TASK((short)37),

    PROCESS_INSTANCE_MIGRATION((short)38),

    COMPENSATION_SUBSCRIPTION((short)39),

    CHECKPOINT((short)254),

    /**
     * To be used to represent an unknown value from a later version.
     */
    SBE_UNKNOWN((short)255),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL((short)255);

    private final short value;

    ValueType(final short value)
    {
        this.value = value;
    }

    /**
     * The raw encoded value in the Java type representation.
     *
     * @return the raw value encoded.
     */
    public short value()
    {
        return value;
    }

    /**
     * Lookup the enum value representing the value.
     *
     * @param value encoded to be looked up.
     * @return the enum value representing the value.
     */
    public static ValueType get(final short value)
    {
        switch (value)
        {
            case 0: return JOB;
            case 4: return DEPLOYMENT;
            case 5: return PROCESS_INSTANCE;
            case 6: return INCIDENT;
            case 10: return MESSAGE;
            case 11: return MESSAGE_SUBSCRIPTION;
            case 12: return PROCESS_MESSAGE_SUBSCRIPTION;
            case 14: return JOB_BATCH;
            case 15: return TIMER;
            case 16: return MESSAGE_START_EVENT_SUBSCRIPTION;
            case 17: return VARIABLE;
            case 18: return VARIABLE_DOCUMENT;
            case 19: return PROCESS_INSTANCE_CREATION;
            case 20: return ERROR;
            case 21: return PROCESS_INSTANCE_RESULT;
            case 22: return PROCESS;
            case 23: return DEPLOYMENT_DISTRIBUTION;
            case 24: return PROCESS_EVENT;
            case 25: return DECISION;
            case 26: return DECISION_REQUIREMENTS;
            case 27: return DECISION_EVALUATION;
            case 28: return PROCESS_INSTANCE_MODIFICATION;
            case 29: return ESCALATION;
            case 30: return SIGNAL_SUBSCRIPTION;
            case 31: return SIGNAL;
            case 32: return RESOURCE_DELETION;
            case 33: return COMMAND_DISTRIBUTION;
            case 34: return PROCESS_INSTANCE_BATCH;
            case 35: return MESSAGE_BATCH;
            case 36: return FORM;
            case 37: return USER_TASK;
            case 38: return PROCESS_INSTANCE_MIGRATION;
            case 39: return COMPENSATION_SUBSCRIPTION;
            case 254: return CHECKPOINT;
            case 255: return NULL_VAL;
        }

        return SBE_UNKNOWN;
    }
}
