package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.RecordValueWithVariables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UserTaskRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUserTaskRecordValue.builder()}.
 */
@Generated(from = "UserTaskRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableUserTaskRecordValue.Builder.class)
public final class ImmutableUserTaskRecordValue
    implements UserTaskRecordValue {
  private final Map<String, Object> variables;
  private final long processInstanceKey;
  private final String tenantId;
  private final long userTaskKey;
  private final String assignee;
  private final List<String> candidateGroupsList;
  private final List<String> candidateUsersList;
  private final String dueDate;
  private final String followUpDate;
  private final long formKey;
  private final List<String> changedAttributes;
  private final String action;
  private final String externalFormReference;
  private final Map<String, String> customHeaders;
  private final long creationTimestamp;
  private final String elementId;
  private final long elementInstanceKey;
  private final String bpmnProcessId;
  private final int processDefinitionVersion;
  private final long processDefinitionKey;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableUserTaskRecordValue(
      Map<String, Object> variables,
      long processInstanceKey,
      String tenantId,
      long userTaskKey,
      String assignee,
      List<String> candidateGroupsList,
      List<String> candidateUsersList,
      String dueDate,
      String followUpDate,
      long formKey,
      List<String> changedAttributes,
      String action,
      String externalFormReference,
      Map<String, String> customHeaders,
      long creationTimestamp,
      String elementId,
      long elementInstanceKey,
      String bpmnProcessId,
      int processDefinitionVersion,
      long processDefinitionKey) {
    this.variables = variables;
    this.processInstanceKey = processInstanceKey;
    this.tenantId = tenantId;
    this.userTaskKey = userTaskKey;
    this.assignee = assignee;
    this.candidateGroupsList = candidateGroupsList;
    this.candidateUsersList = candidateUsersList;
    this.dueDate = dueDate;
    this.followUpDate = followUpDate;
    this.formKey = formKey;
    this.changedAttributes = changedAttributes;
    this.action = action;
    this.externalFormReference = externalFormReference;
    this.customHeaders = customHeaders;
    this.creationTimestamp = creationTimestamp;
    this.elementId = elementId;
    this.elementInstanceKey = elementInstanceKey;
    this.bpmnProcessId = bpmnProcessId;
    this.processDefinitionVersion = processDefinitionVersion;
    this.processDefinitionKey = processDefinitionKey;
  }

  /**
   * @return the variables of this record. Can be empty.
   */
  @Override
  public Map<String, Object> getVariables() {
    return variables;
  }

  /**
   * @return the key of the corresponding process instance
   */
  @Override
  public long getProcessInstanceKey() {
    return processInstanceKey;
  }

  /**
   *Returns the identifier of the tenant that owns this entity. 
   */
  @Override
  public String getTenantId() {
    return tenantId;
  }

  /**
   * @return The value of the {@code userTaskKey} attribute
   */
  @Override
  public long getUserTaskKey() {
    return userTaskKey;
  }

  /**
   * @return The value of the {@code assignee} attribute
   */
  @Override
  public String getAssignee() {
    return assignee;
  }

  /**
   * @return The value of the {@code candidateGroupsList} attribute
   */
  @Override
  public List<String> getCandidateGroupsList() {
    return candidateGroupsList;
  }

  /**
   * @return The value of the {@code candidateUsersList} attribute
   */
  @Override
  public List<String> getCandidateUsersList() {
    return candidateUsersList;
  }

  /**
   * @return The value of the {@code dueDate} attribute
   */
  @Override
  public String getDueDate() {
    return dueDate;
  }

  /**
   * @return The value of the {@code followUpDate} attribute
   */
  @Override
  public String getFollowUpDate() {
    return followUpDate;
  }

  /**
   * @return The value of the {@code formKey} attribute
   */
  @Override
  public long getFormKey() {
    return formKey;
  }

  /**
   * @return The value of the {@code changedAttributes} attribute
   */
  @Override
  public List<String> getChangedAttributes() {
    return changedAttributes;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @Override
  public String getAction() {
    return action;
  }

  /**
   * @return The value of the {@code externalFormReference} attribute
   */
  @Override
  public String getExternalFormReference() {
    return externalFormReference;
  }

  /**
   * @return The value of the {@code customHeaders} attribute
   */
  @Override
  public Map<String, String> getCustomHeaders() {
    return customHeaders;
  }

  /**
   * @return The value of the {@code creationTimestamp} attribute
   */
  @Override
  public long getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * @return the element id of the corresponding user task
   */
  @Override
  public String getElementId() {
    return elementId;
  }

  /**
   * @return the element instance key of the corresponding user task
   */
  @Override
  public long getElementInstanceKey() {
    return elementInstanceKey;
  }

  /**
   * @return the bpmn process id of the corresponding process definition
   */
  @Override
  public String getBpmnProcessId() {
    return bpmnProcessId;
  }

  /**
   * @return the version of the corresponding process definition
   */
  @Override
  public int getProcessDefinitionVersion() {
    return processDefinitionVersion;
  }

  /**
   * @return the process key of the corresponding process definition
   */
  @Override
  public long getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  /**
   * Copy the current immutable object by replacing the {@link UserTaskRecordValue#getVariables() variables} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the variables map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUserTaskRecordValue withVariables(Map<String, ? extends Object> entries) {
    if (this.variables == entries) return this;
    Map<String, Object> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableUserTaskRecordValue(
        newValue,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroupsList,
        this.candidateUsersList,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.changedAttributes,
        this.action,
        this.externalFormReference,
        this.customHeaders,
        this.creationTimestamp,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withProcessInstanceKey(long value) {
    if (this.processInstanceKey == value) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        value,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroupsList,
        this.candidateUsersList,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.changedAttributes,
        this.action,
        this.externalFormReference,
        this.customHeaders,
        this.creationTimestamp,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getTenantId() tenantId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenantId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withTenantId(String value) {
    if (Objects.equals(this.tenantId, value)) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        value,
        this.userTaskKey,
        this.assignee,
        this.candidateGroupsList,
        this.candidateUsersList,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.changedAttributes,
        this.action,
        this.externalFormReference,
        this.customHeaders,
        this.creationTimestamp,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getUserTaskKey() userTaskKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for userTaskKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withUserTaskKey(long value) {
    if (this.userTaskKey == value) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        value,
        this.assignee,
        this.candidateGroupsList,
        this.candidateUsersList,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.changedAttributes,
        this.action,
        this.externalFormReference,
        this.customHeaders,
        this.creationTimestamp,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getAssignee() assignee} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for assignee (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withAssignee(String value) {
    if (Objects.equals(this.assignee, value)) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        value,
        this.candidateGroupsList,
        this.candidateUsersList,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.changedAttributes,
        this.action,
        this.externalFormReference,
        this.customHeaders,
        this.creationTimestamp,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UserTaskRecordValue#getCandidateGroupsList() candidateGroupsList}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUserTaskRecordValue withCandidateGroupsList(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        newValue,
        this.candidateUsersList,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.changedAttributes,
        this.action,
        this.externalFormReference,
        this.customHeaders,
        this.creationTimestamp,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UserTaskRecordValue#getCandidateGroupsList() candidateGroupsList}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of candidateGroupsList elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUserTaskRecordValue withCandidateGroupsList(Iterable<String> elements) {
    if (this.candidateGroupsList == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        newValue,
        this.candidateUsersList,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.changedAttributes,
        this.action,
        this.externalFormReference,
        this.customHeaders,
        this.creationTimestamp,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UserTaskRecordValue#getCandidateUsersList() candidateUsersList}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUserTaskRecordValue withCandidateUsersList(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroupsList,
        newValue,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.changedAttributes,
        this.action,
        this.externalFormReference,
        this.customHeaders,
        this.creationTimestamp,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UserTaskRecordValue#getCandidateUsersList() candidateUsersList}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of candidateUsersList elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUserTaskRecordValue withCandidateUsersList(Iterable<String> elements) {
    if (this.candidateUsersList == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroupsList,
        newValue,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.changedAttributes,
        this.action,
        this.externalFormReference,
        this.customHeaders,
        this.creationTimestamp,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getDueDate() dueDate} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dueDate (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withDueDate(String value) {
    if (Objects.equals(this.dueDate, value)) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroupsList,
        this.candidateUsersList,
        value,
        this.followUpDate,
        this.formKey,
        this.changedAttributes,
        this.action,
        this.externalFormReference,
        this.customHeaders,
        this.creationTimestamp,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getFollowUpDate() followUpDate} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for followUpDate (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withFollowUpDate(String value) {
    if (Objects.equals(this.followUpDate, value)) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroupsList,
        this.candidateUsersList,
        this.dueDate,
        value,
        this.formKey,
        this.changedAttributes,
        this.action,
        this.externalFormReference,
        this.customHeaders,
        this.creationTimestamp,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getFormKey() formKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for formKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withFormKey(long value) {
    if (this.formKey == value) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroupsList,
        this.candidateUsersList,
        this.dueDate,
        this.followUpDate,
        value,
        this.changedAttributes,
        this.action,
        this.externalFormReference,
        this.customHeaders,
        this.creationTimestamp,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UserTaskRecordValue#getChangedAttributes() changedAttributes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUserTaskRecordValue withChangedAttributes(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroupsList,
        this.candidateUsersList,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        newValue,
        this.action,
        this.externalFormReference,
        this.customHeaders,
        this.creationTimestamp,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UserTaskRecordValue#getChangedAttributes() changedAttributes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of changedAttributes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUserTaskRecordValue withChangedAttributes(Iterable<String> elements) {
    if (this.changedAttributes == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroupsList,
        this.candidateUsersList,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        newValue,
        this.action,
        this.externalFormReference,
        this.customHeaders,
        this.creationTimestamp,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getAction() action} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withAction(String value) {
    if (Objects.equals(this.action, value)) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroupsList,
        this.candidateUsersList,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.changedAttributes,
        value,
        this.externalFormReference,
        this.customHeaders,
        this.creationTimestamp,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getExternalFormReference() externalFormReference} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for externalFormReference (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withExternalFormReference(String value) {
    if (Objects.equals(this.externalFormReference, value)) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroupsList,
        this.candidateUsersList,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.changedAttributes,
        this.action,
        value,
        this.customHeaders,
        this.creationTimestamp,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by replacing the {@link UserTaskRecordValue#getCustomHeaders() customHeaders} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customHeaders map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUserTaskRecordValue withCustomHeaders(Map<String, ? extends String> entries) {
    if (this.customHeaders == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroupsList,
        this.candidateUsersList,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.changedAttributes,
        this.action,
        this.externalFormReference,
        newValue,
        this.creationTimestamp,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getCreationTimestamp() creationTimestamp} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for creationTimestamp
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withCreationTimestamp(long value) {
    if (this.creationTimestamp == value) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroupsList,
        this.candidateUsersList,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.changedAttributes,
        this.action,
        this.externalFormReference,
        this.customHeaders,
        value,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getElementId() elementId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for elementId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withElementId(String value) {
    if (Objects.equals(this.elementId, value)) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroupsList,
        this.candidateUsersList,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.changedAttributes,
        this.action,
        this.externalFormReference,
        this.customHeaders,
        this.creationTimestamp,
        value,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getElementInstanceKey() elementInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for elementInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withElementInstanceKey(long value) {
    if (this.elementInstanceKey == value) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroupsList,
        this.candidateUsersList,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.changedAttributes,
        this.action,
        this.externalFormReference,
        this.customHeaders,
        this.creationTimestamp,
        this.elementId,
        value,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getBpmnProcessId() bpmnProcessId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bpmnProcessId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withBpmnProcessId(String value) {
    if (Objects.equals(this.bpmnProcessId, value)) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroupsList,
        this.candidateUsersList,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.changedAttributes,
        this.action,
        this.externalFormReference,
        this.customHeaders,
        this.creationTimestamp,
        this.elementId,
        this.elementInstanceKey,
        value,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getProcessDefinitionVersion() processDefinitionVersion} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processDefinitionVersion
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withProcessDefinitionVersion(int value) {
    if (this.processDefinitionVersion == value) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroupsList,
        this.candidateUsersList,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.changedAttributes,
        this.action,
        this.externalFormReference,
        this.customHeaders,
        this.creationTimestamp,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        value,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processDefinitionKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withProcessDefinitionKey(long value) {
    if (this.processDefinitionKey == value) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroupsList,
        this.candidateUsersList,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.changedAttributes,
        this.action,
        this.externalFormReference,
        this.customHeaders,
        this.creationTimestamp,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUserTaskRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUserTaskRecordValue
        && equalTo(0, (ImmutableUserTaskRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableUserTaskRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return variables.equals(another.variables)
        && processInstanceKey == another.processInstanceKey
        && Objects.equals(tenantId, another.tenantId)
        && userTaskKey == another.userTaskKey
        && Objects.equals(assignee, another.assignee)
        && candidateGroupsList.equals(another.candidateGroupsList)
        && candidateUsersList.equals(another.candidateUsersList)
        && Objects.equals(dueDate, another.dueDate)
        && Objects.equals(followUpDate, another.followUpDate)
        && formKey == another.formKey
        && changedAttributes.equals(another.changedAttributes)
        && Objects.equals(action, another.action)
        && Objects.equals(externalFormReference, another.externalFormReference)
        && customHeaders.equals(another.customHeaders)
        && creationTimestamp == another.creationTimestamp
        && Objects.equals(elementId, another.elementId)
        && elementInstanceKey == another.elementInstanceKey
        && Objects.equals(bpmnProcessId, another.bpmnProcessId)
        && processDefinitionVersion == another.processDefinitionVersion
        && processDefinitionKey == another.processDefinitionKey;
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code variables}, {@code processInstanceKey}, {@code tenantId}, {@code userTaskKey}, {@code assignee}, {@code candidateGroupsList}, {@code candidateUsersList}, {@code dueDate}, {@code followUpDate}, {@code formKey}, {@code changedAttributes}, {@code action}, {@code externalFormReference}, {@code customHeaders}, {@code creationTimestamp}, {@code elementId}, {@code elementInstanceKey}, {@code bpmnProcessId}, {@code processDefinitionVersion}, {@code processDefinitionKey}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + variables.hashCode();
    h += (h << 5) + Long.hashCode(processInstanceKey);
    h += (h << 5) + Objects.hashCode(tenantId);
    h += (h << 5) + Long.hashCode(userTaskKey);
    h += (h << 5) + Objects.hashCode(assignee);
    h += (h << 5) + candidateGroupsList.hashCode();
    h += (h << 5) + candidateUsersList.hashCode();
    h += (h << 5) + Objects.hashCode(dueDate);
    h += (h << 5) + Objects.hashCode(followUpDate);
    h += (h << 5) + Long.hashCode(formKey);
    h += (h << 5) + changedAttributes.hashCode();
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(externalFormReference);
    h += (h << 5) + customHeaders.hashCode();
    h += (h << 5) + Long.hashCode(creationTimestamp);
    h += (h << 5) + Objects.hashCode(elementId);
    h += (h << 5) + Long.hashCode(elementInstanceKey);
    h += (h << 5) + Objects.hashCode(bpmnProcessId);
    h += (h << 5) + processDefinitionVersion;
    h += (h << 5) + Long.hashCode(processDefinitionKey);
    return h;
  }

  /**
   * Prints the immutable value {@code UserTaskRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UserTaskRecordValue{"
        + "variables=" + variables
        + ", processInstanceKey=" + processInstanceKey
        + ", tenantId=" + tenantId
        + ", userTaskKey=" + userTaskKey
        + ", assignee=" + assignee
        + ", candidateGroupsList=" + candidateGroupsList
        + ", candidateUsersList=" + candidateUsersList
        + ", dueDate=" + dueDate
        + ", followUpDate=" + followUpDate
        + ", formKey=" + formKey
        + ", changedAttributes=" + changedAttributes
        + ", action=" + action
        + ", externalFormReference=" + externalFormReference
        + ", customHeaders=" + customHeaders
        + ", creationTimestamp=" + creationTimestamp
        + ", elementId=" + elementId
        + ", elementInstanceKey=" + elementInstanceKey
        + ", bpmnProcessId=" + bpmnProcessId
        + ", processDefinitionVersion=" + processDefinitionVersion
        + ", processDefinitionKey=" + processDefinitionKey
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link UserTaskRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UserTaskRecordValue instance
   */
  public static ImmutableUserTaskRecordValue copyOf(UserTaskRecordValue instance) {
    if (instance instanceof ImmutableUserTaskRecordValue) {
      return (ImmutableUserTaskRecordValue) instance;
    }
    return ImmutableUserTaskRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUserTaskRecordValue ImmutableUserTaskRecordValue}.
   * <pre>
   * ImmutableUserTaskRecordValue.builder()
   *    .putVariable|putAllVariables(String =&gt; Object) // {@link UserTaskRecordValue#getVariables() variables} mappings
   *    .withProcessInstanceKey(long) // optional {@link UserTaskRecordValue#getProcessInstanceKey() processInstanceKey}
   *    .withTenantId(String | null) // nullable {@link UserTaskRecordValue#getTenantId() tenantId}
   *    .withUserTaskKey(long) // optional {@link UserTaskRecordValue#getUserTaskKey() userTaskKey}
   *    .withAssignee(String | null) // nullable {@link UserTaskRecordValue#getAssignee() assignee}
   *    .addCandidateGroupsList|addAllCandidateGroupsList(String) // {@link UserTaskRecordValue#getCandidateGroupsList() candidateGroupsList} elements
   *    .addCandidateUsersList|addAllCandidateUsersList(String) // {@link UserTaskRecordValue#getCandidateUsersList() candidateUsersList} elements
   *    .withDueDate(String | null) // nullable {@link UserTaskRecordValue#getDueDate() dueDate}
   *    .withFollowUpDate(String | null) // nullable {@link UserTaskRecordValue#getFollowUpDate() followUpDate}
   *    .withFormKey(long) // optional {@link UserTaskRecordValue#getFormKey() formKey}
   *    .addChangedAttribute|addAllChangedAttributes(String) // {@link UserTaskRecordValue#getChangedAttributes() changedAttributes} elements
   *    .withAction(String | null) // nullable {@link UserTaskRecordValue#getAction() action}
   *    .withExternalFormReference(String | null) // nullable {@link UserTaskRecordValue#getExternalFormReference() externalFormReference}
   *    .putCustomHeader|putAllCustomHeaders(String =&gt; String) // {@link UserTaskRecordValue#getCustomHeaders() customHeaders} mappings
   *    .withCreationTimestamp(long) // optional {@link UserTaskRecordValue#getCreationTimestamp() creationTimestamp}
   *    .withElementId(String | null) // nullable {@link UserTaskRecordValue#getElementId() elementId}
   *    .withElementInstanceKey(long) // optional {@link UserTaskRecordValue#getElementInstanceKey() elementInstanceKey}
   *    .withBpmnProcessId(String | null) // nullable {@link UserTaskRecordValue#getBpmnProcessId() bpmnProcessId}
   *    .withProcessDefinitionVersion(int) // optional {@link UserTaskRecordValue#getProcessDefinitionVersion() processDefinitionVersion}
   *    .withProcessDefinitionKey(long) // optional {@link UserTaskRecordValue#getProcessDefinitionKey() processDefinitionKey}
   *    .build();
   * </pre>
   * @return A new ImmutableUserTaskRecordValue builder
   */
  public static ImmutableUserTaskRecordValue.Builder builder() {
    return new ImmutableUserTaskRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUserTaskRecordValue ImmutableUserTaskRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UserTaskRecordValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private Map<String, Object> variables = new LinkedHashMap<String, Object>();
    private long processInstanceKey;
    private String tenantId;
    private long userTaskKey;
    private String assignee;
    private List<String> candidateGroupsList = new ArrayList<String>();
    private List<String> candidateUsersList = new ArrayList<String>();
    private String dueDate;
    private String followUpDate;
    private long formKey;
    private List<String> changedAttributes = new ArrayList<String>();
    private String action;
    private String externalFormReference;
    private Map<String, String> customHeaders = new LinkedHashMap<String, String>();
    private long creationTimestamp;
    private String elementId;
    private long elementInstanceKey;
    private String bpmnProcessId;
    private int processDefinitionVersion;
    private long processDefinitionKey;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.UserTaskRecordValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UserTaskRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessInstanceRelated instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.TenantOwned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TenantOwned instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.RecordValueWithVariables} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RecordValueWithVariables instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof UserTaskRecordValue) {
        UserTaskRecordValue instance = (UserTaskRecordValue) object;
        String elementIdValue = instance.getElementId();
        if (elementIdValue != null) {
          withElementId(elementIdValue);
        }
        if ((bits & 0x1L) == 0) {
          this.withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          putAllVariables(instance.getVariables());
          bits |= 0x2L;
        }
        this.withFormKey(instance.getFormKey());
        String dueDateValue = instance.getDueDate();
        if (dueDateValue != null) {
          withDueDate(dueDateValue);
        }
        addAllChangedAttributes(instance.getChangedAttributes());
        this.withUserTaskKey(instance.getUserTaskKey());
        this.withProcessDefinitionKey(instance.getProcessDefinitionKey());
        String followUpDateValue = instance.getFollowUpDate();
        if (followUpDateValue != null) {
          withFollowUpDate(followUpDateValue);
        }
        addAllCandidateUsersList(instance.getCandidateUsersList());
        this.withElementInstanceKey(instance.getElementInstanceKey());
        if ((bits & 0x4L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x4L;
        }
        addAllCandidateGroupsList(instance.getCandidateGroupsList());
        this.withCreationTimestamp(instance.getCreationTimestamp());
        String actionValue = instance.getAction();
        if (actionValue != null) {
          withAction(actionValue);
        }
        String assigneeValue = instance.getAssignee();
        if (assigneeValue != null) {
          withAssignee(assigneeValue);
        }
        String bpmnProcessIdValue = instance.getBpmnProcessId();
        if (bpmnProcessIdValue != null) {
          withBpmnProcessId(bpmnProcessIdValue);
        }
        String externalFormReferenceValue = instance.getExternalFormReference();
        if (externalFormReferenceValue != null) {
          withExternalFormReference(externalFormReferenceValue);
        }
        putAllCustomHeaders(instance.getCustomHeaders());
        this.withProcessDefinitionVersion(instance.getProcessDefinitionVersion());
      }
      if (object instanceof ProcessInstanceRelated) {
        ProcessInstanceRelated instance = (ProcessInstanceRelated) object;
        if ((bits & 0x1L) == 0) {
          this.withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
      }
      if (object instanceof TenantOwned) {
        TenantOwned instance = (TenantOwned) object;
        if ((bits & 0x4L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x4L;
        }
      }
      if (object instanceof RecordValueWithVariables) {
        RecordValueWithVariables instance = (RecordValueWithVariables) object;
        if ((bits & 0x2L) == 0) {
          putAllVariables(instance.getVariables());
          bits |= 0x2L;
        }
      }
    }

    /**
     * Put one entry to the {@link UserTaskRecordValue#getVariables() variables} map.
     * @param key The key in the variables map
     * @param value The associated value in the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(String key, Object value) {
      this.variables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link UserTaskRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.variables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link UserTaskRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVariables(Map<String, ? extends Object> entries) {
      this.variables.clear();
      return putAllVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link UserTaskRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllVariables(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.variables.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
     * @param processInstanceKey The value for processInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessInstanceKey(long processInstanceKey) {
      this.processInstanceKey = processInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getTenantId() tenantId} attribute.
     * @param tenantId The value for tenantId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTenantId(String tenantId) {
      this.tenantId = tenantId;
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getUserTaskKey() userTaskKey} attribute.
     * @param userTaskKey The value for userTaskKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withUserTaskKey(long userTaskKey) {
      this.userTaskKey = userTaskKey;
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getAssignee() assignee} attribute.
     * @param assignee The value for assignee (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withAssignee(String assignee) {
      this.assignee = assignee;
      return this;
    }

    /**
     * Adds one element to {@link UserTaskRecordValue#getCandidateGroupsList() candidateGroupsList} list.
     * @param element A candidateGroupsList element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addCandidateGroupsList(String element) {
      this.candidateGroupsList.add(element);
      return this;
    }

    /**
     * Adds elements to {@link UserTaskRecordValue#getCandidateGroupsList() candidateGroupsList} list.
     * @param elements An array of candidateGroupsList elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addCandidateGroupsList(String... elements) {
      for (String element : elements) {
        this.candidateGroupsList.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UserTaskRecordValue#getCandidateGroupsList() candidateGroupsList} list.
     * @param elements An iterable of candidateGroupsList elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withCandidateGroupsList(Iterable<String> elements) {
      this.candidateGroupsList.clear();
      return addAllCandidateGroupsList(elements);
    }

    /**
     * Adds elements to {@link UserTaskRecordValue#getCandidateGroupsList() candidateGroupsList} list.
     * @param elements An iterable of candidateGroupsList elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllCandidateGroupsList(Iterable<String> elements) {
      for (String element : elements) {
        this.candidateGroupsList.add(element);
      }
      return this;
    }

    /**
     * Adds one element to {@link UserTaskRecordValue#getCandidateUsersList() candidateUsersList} list.
     * @param element A candidateUsersList element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addCandidateUsersList(String element) {
      this.candidateUsersList.add(element);
      return this;
    }

    /**
     * Adds elements to {@link UserTaskRecordValue#getCandidateUsersList() candidateUsersList} list.
     * @param elements An array of candidateUsersList elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addCandidateUsersList(String... elements) {
      for (String element : elements) {
        this.candidateUsersList.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UserTaskRecordValue#getCandidateUsersList() candidateUsersList} list.
     * @param elements An iterable of candidateUsersList elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withCandidateUsersList(Iterable<String> elements) {
      this.candidateUsersList.clear();
      return addAllCandidateUsersList(elements);
    }

    /**
     * Adds elements to {@link UserTaskRecordValue#getCandidateUsersList() candidateUsersList} list.
     * @param elements An iterable of candidateUsersList elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllCandidateUsersList(Iterable<String> elements) {
      for (String element : elements) {
        this.candidateUsersList.add(element);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getDueDate() dueDate} attribute.
     * @param dueDate The value for dueDate (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDueDate(String dueDate) {
      this.dueDate = dueDate;
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getFollowUpDate() followUpDate} attribute.
     * @param followUpDate The value for followUpDate (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withFollowUpDate(String followUpDate) {
      this.followUpDate = followUpDate;
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getFormKey() formKey} attribute.
     * @param formKey The value for formKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withFormKey(long formKey) {
      this.formKey = formKey;
      return this;
    }

    /**
     * Adds one element to {@link UserTaskRecordValue#getChangedAttributes() changedAttributes} list.
     * @param element A changedAttributes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChangedAttribute(String element) {
      this.changedAttributes.add(element);
      return this;
    }

    /**
     * Adds elements to {@link UserTaskRecordValue#getChangedAttributes() changedAttributes} list.
     * @param elements An array of changedAttributes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChangedAttributes(String... elements) {
      for (String element : elements) {
        this.changedAttributes.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UserTaskRecordValue#getChangedAttributes() changedAttributes} list.
     * @param elements An iterable of changedAttributes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withChangedAttributes(Iterable<String> elements) {
      this.changedAttributes.clear();
      return addAllChangedAttributes(elements);
    }

    /**
     * Adds elements to {@link UserTaskRecordValue#getChangedAttributes() changedAttributes} list.
     * @param elements An iterable of changedAttributes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllChangedAttributes(Iterable<String> elements) {
      for (String element : elements) {
        this.changedAttributes.add(element);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withAction(String action) {
      this.action = action;
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getExternalFormReference() externalFormReference} attribute.
     * @param externalFormReference The value for externalFormReference (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withExternalFormReference(String externalFormReference) {
      this.externalFormReference = externalFormReference;
      return this;
    }

    /**
     * Put one entry to the {@link UserTaskRecordValue#getCustomHeaders() customHeaders} map.
     * @param key The key in the customHeaders map
     * @param value The associated value in the customHeaders map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putCustomHeader(String key, String value) {
      this.customHeaders.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link UserTaskRecordValue#getCustomHeaders() customHeaders} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putCustomHeader(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.customHeaders.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link UserTaskRecordValue#getCustomHeaders() customHeaders} map. Nulls are not permitted
     * @param entries The entries that will be added to the customHeaders map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withCustomHeaders(Map<String, ? extends String> entries) {
      this.customHeaders.clear();
      return putAllCustomHeaders(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link UserTaskRecordValue#getCustomHeaders() customHeaders} map. Nulls are not permitted
     * @param entries The entries that will be added to the customHeaders map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllCustomHeaders(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.customHeaders.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getCreationTimestamp() creationTimestamp} attribute.
     * @param creationTimestamp The value for creationTimestamp 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withCreationTimestamp(long creationTimestamp) {
      this.creationTimestamp = creationTimestamp;
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getElementId() elementId} attribute.
     * @param elementId The value for elementId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withElementId(String elementId) {
      this.elementId = elementId;
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getElementInstanceKey() elementInstanceKey} attribute.
     * @param elementInstanceKey The value for elementInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withElementInstanceKey(long elementInstanceKey) {
      this.elementInstanceKey = elementInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getBpmnProcessId() bpmnProcessId} attribute.
     * @param bpmnProcessId The value for bpmnProcessId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withBpmnProcessId(String bpmnProcessId) {
      this.bpmnProcessId = bpmnProcessId;
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getProcessDefinitionVersion() processDefinitionVersion} attribute.
     * @param processDefinitionVersion The value for processDefinitionVersion 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessDefinitionVersion(int processDefinitionVersion) {
      this.processDefinitionVersion = processDefinitionVersion;
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
     * @param processDefinitionKey The value for processDefinitionKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessDefinitionKey(long processDefinitionKey) {
      this.processDefinitionKey = processDefinitionKey;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.variables.clear();
      this.processInstanceKey = 0;
      this.tenantId = null;
      this.userTaskKey = 0;
      this.assignee = null;
      this.candidateGroupsList.clear();
      this.candidateUsersList.clear();
      this.dueDate = null;
      this.followUpDate = null;
      this.formKey = 0;
      this.changedAttributes.clear();
      this.action = null;
      this.externalFormReference = null;
      this.customHeaders.clear();
      this.creationTimestamp = 0;
      this.elementId = null;
      this.elementInstanceKey = 0;
      this.bpmnProcessId = null;
      this.processDefinitionVersion = 0;
      this.processDefinitionKey = 0;
      return this;
    }

    /**
     * Builds a new {@link ImmutableUserTaskRecordValue ImmutableUserTaskRecordValue}.
     * @return An immutable instance of UserTaskRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUserTaskRecordValue build() {
      return new ImmutableUserTaskRecordValue(
          createUnmodifiableMap(false, false, variables),
          processInstanceKey,
          tenantId,
          userTaskKey,
          assignee,
          createUnmodifiableList(true, candidateGroupsList),
          createUnmodifiableList(true, candidateUsersList),
          dueDate,
          followUpDate,
          formKey,
          createUnmodifiableList(true, changedAttributes),
          action,
          externalFormReference,
          createUnmodifiableMap(false, false, customHeaders),
          creationTimestamp,
          elementId,
          elementInstanceKey,
          bpmnProcessId,
          processDefinitionVersion,
          processDefinitionKey);
    }



  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }



}
