/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record;

import io.camunda.zeebe.protocol.record.ErrorCode;
import io.camunda.zeebe.protocol.record.MessageHeaderDecoder;
import io.camunda.zeebe.protocol.record.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class ErrorResponseDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 1;
    public static final int TEMPLATE_ID = 10;
    public static final int SCHEMA_ID = 0;
    public static final int SCHEMA_VERSION = 4;
    public static final String SEMANTIC_VERSION = "8.5.10";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ErrorResponseDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 1;
    }

    public int sbeTemplateId() {
        return 10;
    }

    public int sbeSchemaId() {
        return 0;
    }

    public int sbeSchemaVersion() {
        return 4;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public ErrorResponseDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public ErrorResponseDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (10 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public ErrorResponseDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int errorCodeId() {
        return 1;
    }

    public static int errorCodeSinceVersion() {
        return 0;
    }

    public static int errorCodeEncodingOffset() {
        return 0;
    }

    public static int errorCodeEncodingLength() {
        return 1;
    }

    public static String errorCodeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short errorCodeRaw() {
        return (short)(this.buffer.getByte(this.offset + 0) & 0xFF);
    }

    public ErrorCode errorCode() {
        return ErrorCode.get((short)(this.buffer.getByte(this.offset + 0) & 0xFF));
    }

    public static int errorDataId() {
        return 2;
    }

    public static int errorDataSinceVersion() {
        return 0;
    }

    public static String errorDataCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String errorDataMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int errorDataHeaderLength() {
        return 4;
    }

    public int errorDataLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipErrorData() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getErrorData(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getErrorData(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapErrorData(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String errorData() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        ErrorResponseDecoder decoder = new ErrorResponseDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[ErrorResponse](sbeTemplateId=");
        builder.append(10);
        builder.append("|sbeSchemaId=");
        builder.append(0);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 4) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(4);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 1) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(1);
        builder.append("):");
        builder.append("errorCode=");
        builder.append((Object)this.errorCode());
        builder.append('|');
        builder.append("errorData=");
        builder.append('\'').append(this.errorData()).append('\'');
        this.limit(originalLimit);
        return builder;
    }

    public ErrorResponseDecoder sbeSkip() {
        this.sbeRewind();
        this.skipErrorData();
        return this;
    }
}

