/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record;

import io.camunda.zeebe.protocol.record.MessageHeaderDecoder;
import io.camunda.zeebe.protocol.record.MetaAttribute;
import io.camunda.zeebe.protocol.record.ValueType;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class ExecuteQueryRequestDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 11;
    public static final int TEMPLATE_ID = 30;
    public static final int SCHEMA_ID = 0;
    public static final int SCHEMA_VERSION = 4;
    public static final String SEMANTIC_VERSION = "8.5.7";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ExecuteQueryRequestDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 11;
    }

    public int sbeTemplateId() {
        return 30;
    }

    public int sbeSchemaId() {
        return 0;
    }

    public int sbeSchemaVersion() {
        return 4;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public ExecuteQueryRequestDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public ExecuteQueryRequestDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (30 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public ExecuteQueryRequestDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int partitionIdId() {
        return 1;
    }

    public static int partitionIdSinceVersion() {
        return 0;
    }

    public static int partitionIdEncodingOffset() {
        return 0;
    }

    public static int partitionIdEncodingLength() {
        return 2;
    }

    public static String partitionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int partitionIdNullValue() {
        return 65535;
    }

    public static int partitionIdMinValue() {
        return 0;
    }

    public static int partitionIdMaxValue() {
        return 65534;
    }

    public int partitionId() {
        return this.buffer.getShort(this.offset + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public static int keyId() {
        return 2;
    }

    public static int keySinceVersion() {
        return 0;
    }

    public static int keyEncodingOffset() {
        return 2;
    }

    public static int keyEncodingLength() {
        return 8;
    }

    public static String keyMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long keyNullValue() {
        return -1L;
    }

    public static long keyMinValue() {
        return 0L;
    }

    public static long keyMaxValue() {
        return -2L;
    }

    public long key() {
        return this.buffer.getLong(this.offset + 2, ByteOrder.LITTLE_ENDIAN);
    }

    public static int valueTypeId() {
        return 3;
    }

    public static int valueTypeSinceVersion() {
        return 0;
    }

    public static int valueTypeEncodingOffset() {
        return 10;
    }

    public static int valueTypeEncodingLength() {
        return 1;
    }

    public static String valueTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short valueTypeRaw() {
        return (short)(this.buffer.getByte(this.offset + 10) & 0xFF);
    }

    public ValueType valueType() {
        return ValueType.get((short)(this.buffer.getByte(this.offset + 10) & 0xFF));
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        ExecuteQueryRequestDecoder decoder = new ExecuteQueryRequestDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[ExecuteQueryRequest](sbeTemplateId=");
        builder.append(30);
        builder.append("|sbeSchemaId=");
        builder.append(0);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 4) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(4);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 11) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(11);
        builder.append("):");
        builder.append("partitionId=");
        builder.append(this.partitionId());
        builder.append('|');
        builder.append("key=");
        builder.append(this.key());
        builder.append('|');
        builder.append("valueType=");
        builder.append((Object)this.valueType());
        this.limit(originalLimit);
        return builder;
    }

    public ExecuteQueryRequestDecoder sbeSkip() {
        this.sbeRewind();
        return this;
    }
}

