/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record;

import io.camunda.zeebe.protocol.record.VersionDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.CompositeEncoderFlyweight;

public final class VersionEncoder
implements CompositeEncoderFlyweight {
    public static final int SCHEMA_ID = 0;
    public static final int SCHEMA_VERSION = 4;
    public static final String SEMANTIC_VERSION = "8.5.9";
    public static final int ENCODED_LENGTH = 12;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private int offset;
    private MutableDirectBuffer buffer;

    public VersionEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        return this;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public int encodedLength() {
        return 12;
    }

    public int sbeSchemaId() {
        return 0;
    }

    public int sbeSchemaVersion() {
        return 4;
    }

    public static int majorVersionEncodingOffset() {
        return 0;
    }

    public static int majorVersionEncodingLength() {
        return 4;
    }

    public static int majorVersionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int majorVersionMinValue() {
        return -2147483647;
    }

    public static int majorVersionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public VersionEncoder majorVersion(int value) {
        this.buffer.putInt(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int minorVersionEncodingOffset() {
        return 4;
    }

    public static int minorVersionEncodingLength() {
        return 4;
    }

    public static int minorVersionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int minorVersionMinValue() {
        return -2147483647;
    }

    public static int minorVersionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public VersionEncoder minorVersion(int value) {
        this.buffer.putInt(this.offset + 4, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int patchVersionEncodingOffset() {
        return 8;
    }

    public static int patchVersionEncodingLength() {
        return 4;
    }

    public static int patchVersionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int patchVersionMinValue() {
        return -2147483647;
    }

    public static int patchVersionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public VersionEncoder patchVersion(int value) {
        this.buffer.putInt(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        VersionDecoder decoder = new VersionDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset);
        return decoder.appendTo(builder);
    }
}

