/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.intent;

import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceRelatedIntent;
import java.util.EnumSet;
import java.util.Set;

public enum ProcessInstanceIntent implements ProcessInstanceRelatedIntent
{
    CANCEL(0, false),
    SEQUENCE_FLOW_TAKEN(1),
    ELEMENT_ACTIVATING(2),
    ELEMENT_ACTIVATED(3),
    ELEMENT_COMPLETING(4),
    ELEMENT_COMPLETED(5),
    ELEMENT_TERMINATING(6),
    ELEMENT_TERMINATED(7),
    ACTIVATE_ELEMENT(8),
    COMPLETE_ELEMENT(9),
    TERMINATE_ELEMENT(10),
    ELEMENT_MIGRATED(11),
    COMPLETE_EXECUTION_LISTENER(12);

    private static final Set<ProcessInstanceIntent> PROCESS_INSTANCE_COMMANDS;
    private static final Set<ProcessInstanceIntent> BPMN_ELEMENT_COMMANDS;
    private final short value;
    private final boolean shouldBanInstance;

    private ProcessInstanceIntent(short value) {
        this(value, true);
    }

    private ProcessInstanceIntent(short value, boolean shouldBanInstance) {
        this.value = value;
        this.shouldBanInstance = shouldBanInstance;
    }

    public short getIntent() {
        return this.value;
    }

    public static Intent from(short value) {
        switch (value) {
            case 0: {
                return CANCEL;
            }
            case 1: {
                return SEQUENCE_FLOW_TAKEN;
            }
            case 2: {
                return ELEMENT_ACTIVATING;
            }
            case 3: {
                return ELEMENT_ACTIVATED;
            }
            case 4: {
                return ELEMENT_COMPLETING;
            }
            case 5: {
                return ELEMENT_COMPLETED;
            }
            case 6: {
                return ELEMENT_TERMINATING;
            }
            case 7: {
                return ELEMENT_TERMINATED;
            }
            case 8: {
                return ACTIVATE_ELEMENT;
            }
            case 9: {
                return COMPLETE_ELEMENT;
            }
            case 10: {
                return TERMINATE_ELEMENT;
            }
            case 11: {
                return ELEMENT_MIGRATED;
            }
            case 12: {
                return COMPLETE_EXECUTION_LISTENER;
            }
        }
        return Intent.UNKNOWN;
    }

    @Override
    public short value() {
        return this.value;
    }

    @Override
    public boolean isEvent() {
        switch (this.ordinal()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean shouldBanInstanceOnError() {
        return this.shouldBanInstance;
    }

    public static boolean isProcessInstanceCommand(ProcessInstanceIntent intent) {
        return PROCESS_INSTANCE_COMMANDS.contains(intent);
    }

    public static boolean isBpmnElementCommand(ProcessInstanceIntent intent) {
        return BPMN_ELEMENT_COMMANDS.contains(intent);
    }

    public static boolean isBpmnElementEvent(ProcessInstanceIntent intent) {
        return !ProcessInstanceIntent.isProcessInstanceCommand(intent) && !ProcessInstanceIntent.isBpmnElementCommand(intent);
    }

    static {
        PROCESS_INSTANCE_COMMANDS = EnumSet.of(CANCEL);
        BPMN_ELEMENT_COMMANDS = EnumSet.of(ACTIVATE_ELEMENT, COMPLETE_ELEMENT, TERMINATE_ELEMENT, COMPLETE_EXECUTION_LISTENER);
    }
}

