/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.value.AuthorizationOwnerType;
import io.camunda.zeebe.protocol.record.value.AuthorizationRecordValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="AuthorizationRecordValue", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableAuthorizationRecordValue
implements AuthorizationRecordValue {
    private final Long authorizationKey;
    private final String ownerKey;
    private final AuthorizationOwnerType ownerType;
    private final String resourceKey;
    private final String resourceType;
    private final List<String> permissions;
    private transient int hashCode;

    private ImmutableAuthorizationRecordValue(Long authorizationKey, String ownerKey, AuthorizationOwnerType ownerType, String resourceKey, String resourceType, List<String> permissions) {
        this.authorizationKey = authorizationKey;
        this.ownerKey = ownerKey;
        this.ownerType = ownerType;
        this.resourceKey = resourceKey;
        this.resourceType = resourceType;
        this.permissions = permissions;
    }

    @Override
    public Long getAuthorizationKey() {
        return this.authorizationKey;
    }

    @Override
    public String getOwnerKey() {
        return this.ownerKey;
    }

    @Override
    public AuthorizationOwnerType getOwnerType() {
        return this.ownerType;
    }

    @Override
    public String getResourceKey() {
        return this.resourceKey;
    }

    @Override
    public String getResourceType() {
        return this.resourceType;
    }

    @Override
    public List<String> getPermissions() {
        return this.permissions;
    }

    public final ImmutableAuthorizationRecordValue withAuthorizationKey(Long value) {
        if (Objects.equals(this.authorizationKey, value)) {
            return this;
        }
        return new ImmutableAuthorizationRecordValue(value, this.ownerKey, this.ownerType, this.resourceKey, this.resourceType, this.permissions);
    }

    public final ImmutableAuthorizationRecordValue withOwnerKey(String value) {
        if (Objects.equals(this.ownerKey, value)) {
            return this;
        }
        return new ImmutableAuthorizationRecordValue(this.authorizationKey, value, this.ownerType, this.resourceKey, this.resourceType, this.permissions);
    }

    public final ImmutableAuthorizationRecordValue withOwnerType(AuthorizationOwnerType value) {
        if (this.ownerType == value) {
            return this;
        }
        return new ImmutableAuthorizationRecordValue(this.authorizationKey, this.ownerKey, value, this.resourceKey, this.resourceType, this.permissions);
    }

    public final ImmutableAuthorizationRecordValue withResourceKey(String value) {
        if (Objects.equals(this.resourceKey, value)) {
            return this;
        }
        return new ImmutableAuthorizationRecordValue(this.authorizationKey, this.ownerKey, this.ownerType, value, this.resourceType, this.permissions);
    }

    public final ImmutableAuthorizationRecordValue withResourceType(String value) {
        if (Objects.equals(this.resourceType, value)) {
            return this;
        }
        return new ImmutableAuthorizationRecordValue(this.authorizationKey, this.ownerKey, this.ownerType, this.resourceKey, value, this.permissions);
    }

    public final ImmutableAuthorizationRecordValue withPermissions(String ... elements) {
        List<String> newValue = ImmutableAuthorizationRecordValue.createUnmodifiableList(false, ImmutableAuthorizationRecordValue.createSafeList(Arrays.asList(elements), false, false));
        return new ImmutableAuthorizationRecordValue(this.authorizationKey, this.ownerKey, this.ownerType, this.resourceKey, this.resourceType, newValue);
    }

    public final ImmutableAuthorizationRecordValue withPermissions(Iterable<String> elements) {
        if (this.permissions == elements) {
            return this;
        }
        List<String> newValue = ImmutableAuthorizationRecordValue.createUnmodifiableList(false, ImmutableAuthorizationRecordValue.createSafeList(elements, false, false));
        return new ImmutableAuthorizationRecordValue(this.authorizationKey, this.ownerKey, this.ownerType, this.resourceKey, this.resourceType, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAuthorizationRecordValue && this.equalTo(0, (ImmutableAuthorizationRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableAuthorizationRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.authorizationKey, another.authorizationKey) && Objects.equals(this.ownerKey, another.ownerKey) && Objects.equals((Object)this.ownerType, (Object)another.ownerType) && Objects.equals(this.resourceKey, another.resourceKey) && Objects.equals(this.resourceType, another.resourceType) && this.permissions.equals(another.permissions);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.authorizationKey);
        h += (h << 5) + Objects.hashCode(this.ownerKey);
        h += (h << 5) + Objects.hashCode((Object)this.ownerType);
        h += (h << 5) + Objects.hashCode(this.resourceKey);
        h += (h << 5) + Objects.hashCode(this.resourceType);
        h += (h << 5) + this.permissions.hashCode();
        return h;
    }

    public String toString() {
        return "AuthorizationRecordValue{authorizationKey=" + this.authorizationKey + ", ownerKey=" + this.ownerKey + ", ownerType=" + (Object)((Object)this.ownerType) + ", resourceKey=" + this.resourceKey + ", resourceType=" + this.resourceType + ", permissions=" + this.permissions + "}";
    }

    public static ImmutableAuthorizationRecordValue copyOf(AuthorizationRecordValue instance) {
        if (instance instanceof ImmutableAuthorizationRecordValue) {
            return (ImmutableAuthorizationRecordValue)instance;
        }
        return ImmutableAuthorizationRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @ImmutableProtocol.Builder
    @Generated(from="AuthorizationRecordValue", generator="Immutables")
    public static final class Builder {
        private Long authorizationKey;
        private String ownerKey;
        private AuthorizationOwnerType ownerType;
        private String resourceKey;
        private String resourceType;
        private List<String> permissions = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(AuthorizationRecordValue instance) {
            String resourceTypeValue;
            String resourceKeyValue;
            AuthorizationOwnerType ownerTypeValue;
            String ownerKeyValue;
            Objects.requireNonNull(instance, "instance");
            Long authorizationKeyValue = instance.getAuthorizationKey();
            if (authorizationKeyValue != null) {
                this.withAuthorizationKey(authorizationKeyValue);
            }
            if ((ownerKeyValue = instance.getOwnerKey()) != null) {
                this.withOwnerKey(ownerKeyValue);
            }
            if ((ownerTypeValue = instance.getOwnerType()) != null) {
                this.withOwnerType(ownerTypeValue);
            }
            if ((resourceKeyValue = instance.getResourceKey()) != null) {
                this.withResourceKey(resourceKeyValue);
            }
            if ((resourceTypeValue = instance.getResourceType()) != null) {
                this.withResourceType(resourceTypeValue);
            }
            this.addAllPermissions(instance.getPermissions());
            return this;
        }

        public final Builder withAuthorizationKey(Long authorizationKey) {
            this.authorizationKey = authorizationKey;
            return this;
        }

        public final Builder withOwnerKey(String ownerKey) {
            this.ownerKey = ownerKey;
            return this;
        }

        public final Builder withOwnerType(AuthorizationOwnerType ownerType) {
            this.ownerType = ownerType;
            return this;
        }

        public final Builder withResourceKey(String resourceKey) {
            this.resourceKey = resourceKey;
            return this;
        }

        public final Builder withResourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Builder addPermission(String element) {
            this.permissions.add(element);
            return this;
        }

        public final Builder addPermissions(String ... elements) {
            for (String element : elements) {
                this.permissions.add(element);
            }
            return this;
        }

        public final Builder withPermissions(Iterable<String> elements) {
            this.permissions.clear();
            return this.addAllPermissions(elements);
        }

        public final Builder addAllPermissions(Iterable<String> elements) {
            for (String element : elements) {
                this.permissions.add(element);
            }
            return this;
        }

        public Builder clear() {
            this.authorizationKey = null;
            this.ownerKey = null;
            this.ownerType = null;
            this.resourceKey = null;
            this.resourceType = null;
            this.permissions.clear();
            return this;
        }

        public ImmutableAuthorizationRecordValue build() {
            return new ImmutableAuthorizationRecordValue(this.authorizationKey, this.ownerKey, this.ownerType, this.resourceKey, this.resourceType, ImmutableAuthorizationRecordValue.createUnmodifiableList(true, this.permissions));
        }
    }
}

