/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.value.UserRecordValue;
import java.util.Objects;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="UserRecordValue", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableUserRecordValue
implements UserRecordValue {
    private final String username;
    private final String name;
    private final String email;
    private final String password;
    private transient int hashCode;

    private ImmutableUserRecordValue(String username, String name, String email, String password) {
        this.username = username;
        this.name = name;
        this.email = email;
        this.password = password;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public final ImmutableUserRecordValue withUsername(String value) {
        if (Objects.equals(this.username, value)) {
            return this;
        }
        return new ImmutableUserRecordValue(value, this.name, this.email, this.password);
    }

    public final ImmutableUserRecordValue withName(String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableUserRecordValue(this.username, value, this.email, this.password);
    }

    public final ImmutableUserRecordValue withEmail(String value) {
        if (Objects.equals(this.email, value)) {
            return this;
        }
        return new ImmutableUserRecordValue(this.username, this.name, value, this.password);
    }

    public final ImmutableUserRecordValue withPassword(String value) {
        if (Objects.equals(this.password, value)) {
            return this;
        }
        return new ImmutableUserRecordValue(this.username, this.name, this.email, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUserRecordValue && this.equalTo(0, (ImmutableUserRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableUserRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.username, another.username) && Objects.equals(this.name, another.name) && Objects.equals(this.email, another.email) && Objects.equals(this.password, another.password);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.username);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.email);
        h += (h << 5) + Objects.hashCode(this.password);
        return h;
    }

    public String toString() {
        return "UserRecordValue{username=" + this.username + ", name=" + this.name + ", email=" + this.email + ", password=" + this.password + "}";
    }

    public static ImmutableUserRecordValue copyOf(UserRecordValue instance) {
        if (instance instanceof ImmutableUserRecordValue) {
            return (ImmutableUserRecordValue)instance;
        }
        return ImmutableUserRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ImmutableProtocol.Builder
    @Generated(from="UserRecordValue", generator="Immutables")
    public static final class Builder {
        private String username;
        private String name;
        private String email;
        private String password;

        private Builder() {
        }

        public final Builder from(UserRecordValue instance) {
            String passwordValue;
            String emailValue;
            String nameValue;
            Objects.requireNonNull(instance, "instance");
            String usernameValue = instance.getUsername();
            if (usernameValue != null) {
                this.withUsername(usernameValue);
            }
            if ((nameValue = instance.getName()) != null) {
                this.withName(nameValue);
            }
            if ((emailValue = instance.getEmail()) != null) {
                this.withEmail(emailValue);
            }
            if ((passwordValue = instance.getPassword()) != null) {
                this.withPassword(passwordValue);
            }
            return this;
        }

        public final Builder withUsername(String username) {
            this.username = username;
            return this;
        }

        public final Builder withName(String name) {
            this.name = name;
            return this;
        }

        public final Builder withEmail(String email) {
            this.email = email;
            return this;
        }

        public final Builder withPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder clear() {
            this.username = null;
            this.name = null;
            this.email = null;
            this.password = null;
            return this;
        }

        public ImmutableUserRecordValue build() {
            return new ImmutableUserRecordValue(this.username, this.name, this.email, this.password);
        }
    }
}

