/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import io.camunda.zeebe.protocol.record.value.TenantOwned;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="IncidentRecordValue", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableIncidentRecordValue
implements IncidentRecordValue {
    private final String tenantId;
    private final ErrorType errorType;
    private final String errorMessage;
    private final String bpmnProcessId;
    private final long processDefinitionKey;
    private final long processInstanceKey;
    private final String elementId;
    private final long elementInstanceKey;
    private final long jobKey;
    private final long variableScopeKey;
    private final List<List<Long>> elementInstancePath;
    private final List<Long> processDefinitionPath;
    private final List<Integer> callingElementPath;
    private transient int hashCode;

    private ImmutableIncidentRecordValue(String tenantId, ErrorType errorType, String errorMessage, String bpmnProcessId, long processDefinitionKey, long processInstanceKey, String elementId, long elementInstanceKey, long jobKey, long variableScopeKey, List<List<Long>> elementInstancePath, List<Long> processDefinitionPath, List<Integer> callingElementPath) {
        this.tenantId = tenantId;
        this.errorType = errorType;
        this.errorMessage = errorMessage;
        this.bpmnProcessId = bpmnProcessId;
        this.processDefinitionKey = processDefinitionKey;
        this.processInstanceKey = processInstanceKey;
        this.elementId = elementId;
        this.elementInstanceKey = elementInstanceKey;
        this.jobKey = jobKey;
        this.variableScopeKey = variableScopeKey;
        this.elementInstancePath = elementInstancePath;
        this.processDefinitionPath = processDefinitionPath;
        this.callingElementPath = callingElementPath;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public ErrorType getErrorType() {
        return this.errorType;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }

    @Override
    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    @Override
    public long getJobKey() {
        return this.jobKey;
    }

    @Override
    public long getVariableScopeKey() {
        return this.variableScopeKey;
    }

    @Override
    public List<List<Long>> getElementInstancePath() {
        return this.elementInstancePath;
    }

    @Override
    public List<Long> getProcessDefinitionPath() {
        return this.processDefinitionPath;
    }

    @Override
    public List<Integer> getCallingElementPath() {
        return this.callingElementPath;
    }

    public final ImmutableIncidentRecordValue withTenantId(String value) {
        if (Objects.equals(this.tenantId, value)) {
            return this;
        }
        return new ImmutableIncidentRecordValue(value, this.errorType, this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.elementInstanceKey, this.jobKey, this.variableScopeKey, this.elementInstancePath, this.processDefinitionPath, this.callingElementPath);
    }

    public final ImmutableIncidentRecordValue withErrorType(ErrorType value) {
        if (this.errorType == value) {
            return this;
        }
        return new ImmutableIncidentRecordValue(this.tenantId, value, this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.elementInstanceKey, this.jobKey, this.variableScopeKey, this.elementInstancePath, this.processDefinitionPath, this.callingElementPath);
    }

    public final ImmutableIncidentRecordValue withErrorMessage(String value) {
        if (Objects.equals(this.errorMessage, value)) {
            return this;
        }
        return new ImmutableIncidentRecordValue(this.tenantId, this.errorType, value, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.elementInstanceKey, this.jobKey, this.variableScopeKey, this.elementInstancePath, this.processDefinitionPath, this.callingElementPath);
    }

    public final ImmutableIncidentRecordValue withBpmnProcessId(String value) {
        if (Objects.equals(this.bpmnProcessId, value)) {
            return this;
        }
        return new ImmutableIncidentRecordValue(this.tenantId, this.errorType, this.errorMessage, value, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.elementInstanceKey, this.jobKey, this.variableScopeKey, this.elementInstancePath, this.processDefinitionPath, this.callingElementPath);
    }

    public final ImmutableIncidentRecordValue withProcessDefinitionKey(long value) {
        if (this.processDefinitionKey == value) {
            return this;
        }
        return new ImmutableIncidentRecordValue(this.tenantId, this.errorType, this.errorMessage, this.bpmnProcessId, value, this.processInstanceKey, this.elementId, this.elementInstanceKey, this.jobKey, this.variableScopeKey, this.elementInstancePath, this.processDefinitionPath, this.callingElementPath);
    }

    public final ImmutableIncidentRecordValue withProcessInstanceKey(long value) {
        if (this.processInstanceKey == value) {
            return this;
        }
        return new ImmutableIncidentRecordValue(this.tenantId, this.errorType, this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, value, this.elementId, this.elementInstanceKey, this.jobKey, this.variableScopeKey, this.elementInstancePath, this.processDefinitionPath, this.callingElementPath);
    }

    public final ImmutableIncidentRecordValue withElementId(String value) {
        if (Objects.equals(this.elementId, value)) {
            return this;
        }
        return new ImmutableIncidentRecordValue(this.tenantId, this.errorType, this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, value, this.elementInstanceKey, this.jobKey, this.variableScopeKey, this.elementInstancePath, this.processDefinitionPath, this.callingElementPath);
    }

    public final ImmutableIncidentRecordValue withElementInstanceKey(long value) {
        if (this.elementInstanceKey == value) {
            return this;
        }
        return new ImmutableIncidentRecordValue(this.tenantId, this.errorType, this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, this.elementId, value, this.jobKey, this.variableScopeKey, this.elementInstancePath, this.processDefinitionPath, this.callingElementPath);
    }

    public final ImmutableIncidentRecordValue withJobKey(long value) {
        if (this.jobKey == value) {
            return this;
        }
        return new ImmutableIncidentRecordValue(this.tenantId, this.errorType, this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.elementInstanceKey, value, this.variableScopeKey, this.elementInstancePath, this.processDefinitionPath, this.callingElementPath);
    }

    public final ImmutableIncidentRecordValue withVariableScopeKey(long value) {
        if (this.variableScopeKey == value) {
            return this;
        }
        return new ImmutableIncidentRecordValue(this.tenantId, this.errorType, this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.elementInstanceKey, this.jobKey, value, this.elementInstancePath, this.processDefinitionPath, this.callingElementPath);
    }

    @SafeVarargs
    public final ImmutableIncidentRecordValue withElementInstancePath(List<Long> ... elements) {
        List<List<Long>> newValue = ImmutableIncidentRecordValue.createUnmodifiableList(false, ImmutableIncidentRecordValue.createSafeList(Arrays.asList(elements), false, false));
        return new ImmutableIncidentRecordValue(this.tenantId, this.errorType, this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.elementInstanceKey, this.jobKey, this.variableScopeKey, newValue, this.processDefinitionPath, this.callingElementPath);
    }

    public final ImmutableIncidentRecordValue withElementInstancePath(Iterable<? extends List<Long>> elements) {
        if (this.elementInstancePath == elements) {
            return this;
        }
        List<List<Long>> newValue = ImmutableIncidentRecordValue.createUnmodifiableList(false, ImmutableIncidentRecordValue.createSafeList(elements, false, false));
        return new ImmutableIncidentRecordValue(this.tenantId, this.errorType, this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.elementInstanceKey, this.jobKey, this.variableScopeKey, newValue, this.processDefinitionPath, this.callingElementPath);
    }

    public final ImmutableIncidentRecordValue withProcessDefinitionPath(Long ... elements) {
        List<Long> newValue = ImmutableIncidentRecordValue.createUnmodifiableList(false, ImmutableIncidentRecordValue.createSafeList(Arrays.asList(elements), false, false));
        return new ImmutableIncidentRecordValue(this.tenantId, this.errorType, this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.elementInstanceKey, this.jobKey, this.variableScopeKey, this.elementInstancePath, newValue, this.callingElementPath);
    }

    public final ImmutableIncidentRecordValue withProcessDefinitionPath(Iterable<? extends Long> elements) {
        if (this.processDefinitionPath == elements) {
            return this;
        }
        List<Long> newValue = ImmutableIncidentRecordValue.createUnmodifiableList(false, ImmutableIncidentRecordValue.createSafeList(elements, false, false));
        return new ImmutableIncidentRecordValue(this.tenantId, this.errorType, this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.elementInstanceKey, this.jobKey, this.variableScopeKey, this.elementInstancePath, newValue, this.callingElementPath);
    }

    public final ImmutableIncidentRecordValue withCallingElementPath(Integer ... elements) {
        List<Integer> newValue = ImmutableIncidentRecordValue.createUnmodifiableList(false, ImmutableIncidentRecordValue.createSafeList(Arrays.asList(elements), false, false));
        return new ImmutableIncidentRecordValue(this.tenantId, this.errorType, this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.elementInstanceKey, this.jobKey, this.variableScopeKey, this.elementInstancePath, this.processDefinitionPath, newValue);
    }

    public final ImmutableIncidentRecordValue withCallingElementPath(Iterable<? extends Integer> elements) {
        if (this.callingElementPath == elements) {
            return this;
        }
        List<Integer> newValue = ImmutableIncidentRecordValue.createUnmodifiableList(false, ImmutableIncidentRecordValue.createSafeList(elements, false, false));
        return new ImmutableIncidentRecordValue(this.tenantId, this.errorType, this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.elementInstanceKey, this.jobKey, this.variableScopeKey, this.elementInstancePath, this.processDefinitionPath, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIncidentRecordValue && this.equalTo(0, (ImmutableIncidentRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableIncidentRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.tenantId, another.tenantId) && Objects.equals((Object)this.errorType, (Object)another.errorType) && Objects.equals(this.errorMessage, another.errorMessage) && Objects.equals(this.bpmnProcessId, another.bpmnProcessId) && this.processDefinitionKey == another.processDefinitionKey && this.processInstanceKey == another.processInstanceKey && Objects.equals(this.elementId, another.elementId) && this.elementInstanceKey == another.elementInstanceKey && this.jobKey == another.jobKey && this.variableScopeKey == another.variableScopeKey && this.elementInstancePath.equals(another.elementInstancePath) && this.processDefinitionPath.equals(another.processDefinitionPath) && this.callingElementPath.equals(another.callingElementPath);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.tenantId);
        h += (h << 5) + Objects.hashCode((Object)this.errorType);
        h += (h << 5) + Objects.hashCode(this.errorMessage);
        h += (h << 5) + Objects.hashCode(this.bpmnProcessId);
        h += (h << 5) + Long.hashCode(this.processDefinitionKey);
        h += (h << 5) + Long.hashCode(this.processInstanceKey);
        h += (h << 5) + Objects.hashCode(this.elementId);
        h += (h << 5) + Long.hashCode(this.elementInstanceKey);
        h += (h << 5) + Long.hashCode(this.jobKey);
        h += (h << 5) + Long.hashCode(this.variableScopeKey);
        h += (h << 5) + this.elementInstancePath.hashCode();
        h += (h << 5) + this.processDefinitionPath.hashCode();
        h += (h << 5) + this.callingElementPath.hashCode();
        return h;
    }

    public String toString() {
        return "IncidentRecordValue{tenantId=" + this.tenantId + ", errorType=" + (Object)((Object)this.errorType) + ", errorMessage=" + this.errorMessage + ", bpmnProcessId=" + this.bpmnProcessId + ", processDefinitionKey=" + this.processDefinitionKey + ", processInstanceKey=" + this.processInstanceKey + ", elementId=" + this.elementId + ", elementInstanceKey=" + this.elementInstanceKey + ", jobKey=" + this.jobKey + ", variableScopeKey=" + this.variableScopeKey + ", elementInstancePath=" + this.elementInstancePath + ", processDefinitionPath=" + this.processDefinitionPath + ", callingElementPath=" + this.callingElementPath + "}";
    }

    public static ImmutableIncidentRecordValue copyOf(IncidentRecordValue instance) {
        if (instance instanceof ImmutableIncidentRecordValue) {
            return (ImmutableIncidentRecordValue)instance;
        }
        return ImmutableIncidentRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @ImmutableProtocol.Builder
    @Generated(from="IncidentRecordValue", generator="Immutables")
    public static final class Builder {
        private String tenantId;
        private ErrorType errorType;
        private String errorMessage;
        private String bpmnProcessId;
        private long processDefinitionKey;
        private long processInstanceKey;
        private String elementId;
        private long elementInstanceKey;
        private long jobKey;
        private long variableScopeKey;
        private List<List<Long>> elementInstancePath = new ArrayList<List<Long>>();
        private List<Long> processDefinitionPath = new ArrayList<Long>();
        private List<Integer> callingElementPath = new ArrayList<Integer>();

        private Builder() {
        }

        public final Builder from(IncidentRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ProcessInstanceRelated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(TenantOwned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof IncidentRecordValue) {
                String bpmnProcessIdValue;
                instance = (IncidentRecordValue)object;
                String elementIdValue = instance.getElementId();
                if (elementIdValue != null) {
                    this.withElementId(elementIdValue);
                }
                if ((bits & 1L) == 0L) {
                    this.withProcessInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
                this.withVariableScopeKey(instance.getVariableScopeKey());
                ErrorType errorTypeValue = instance.getErrorType();
                if (errorTypeValue != null) {
                    this.withErrorType(errorTypeValue);
                }
                this.addAllElementInstancePath(instance.getElementInstancePath());
                String errorMessageValue = instance.getErrorMessage();
                if (errorMessageValue != null) {
                    this.withErrorMessage(errorMessageValue);
                }
                this.withJobKey(instance.getJobKey());
                this.withProcessDefinitionKey(instance.getProcessDefinitionKey());
                this.addAllProcessDefinitionPath(instance.getProcessDefinitionPath());
                this.addAllCallingElementPath(instance.getCallingElementPath());
                this.withElementInstanceKey(instance.getElementInstanceKey());
                if ((bits & 2L) == 0L) {
                    String tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 2L;
                }
                if ((bpmnProcessIdValue = instance.getBpmnProcessId()) != null) {
                    this.withBpmnProcessId(bpmnProcessIdValue);
                }
            }
            if (object instanceof ProcessInstanceRelated) {
                instance = (ProcessInstanceRelated)object;
                if ((bits & 1L) == 0L) {
                    this.withProcessInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
            }
            if (object instanceof TenantOwned) {
                instance = (TenantOwned)object;
                if ((bits & 2L) == 0L) {
                    String tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 2L;
                }
            }
        }

        public final Builder withTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final Builder withErrorType(ErrorType errorType) {
            this.errorType = errorType;
            return this;
        }

        public final Builder withErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Builder withBpmnProcessId(String bpmnProcessId) {
            this.bpmnProcessId = bpmnProcessId;
            return this;
        }

        public final Builder withProcessDefinitionKey(long processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
            return this;
        }

        public final Builder withProcessInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            return this;
        }

        public final Builder withElementId(String elementId) {
            this.elementId = elementId;
            return this;
        }

        public final Builder withElementInstanceKey(long elementInstanceKey) {
            this.elementInstanceKey = elementInstanceKey;
            return this;
        }

        public final Builder withJobKey(long jobKey) {
            this.jobKey = jobKey;
            return this;
        }

        public final Builder withVariableScopeKey(long variableScopeKey) {
            this.variableScopeKey = variableScopeKey;
            return this;
        }

        public final Builder addElementInstancePath(List<Long> element) {
            this.elementInstancePath.add(element);
            return this;
        }

        @SafeVarargs
        public final Builder addElementInstancePath(List<Long> ... elements) {
            for (List<Long> element : elements) {
                this.elementInstancePath.add(element);
            }
            return this;
        }

        public final Builder withElementInstancePath(Iterable<? extends List<Long>> elements) {
            this.elementInstancePath.clear();
            return this.addAllElementInstancePath(elements);
        }

        public final Builder addAllElementInstancePath(Iterable<? extends List<Long>> elements) {
            for (List<Long> list : elements) {
                this.elementInstancePath.add(list);
            }
            return this;
        }

        public final Builder addProcessDefinitionPath(Long element) {
            this.processDefinitionPath.add(element);
            return this;
        }

        public final Builder addProcessDefinitionPath(Long ... elements) {
            for (Long element : elements) {
                this.processDefinitionPath.add(element);
            }
            return this;
        }

        public final Builder withProcessDefinitionPath(Iterable<? extends Long> elements) {
            this.processDefinitionPath.clear();
            return this.addAllProcessDefinitionPath(elements);
        }

        public final Builder addAllProcessDefinitionPath(Iterable<? extends Long> elements) {
            for (Long l : elements) {
                this.processDefinitionPath.add(l);
            }
            return this;
        }

        public final Builder addCallingElementPath(Integer element) {
            this.callingElementPath.add(element);
            return this;
        }

        public final Builder addCallingElementPath(Integer ... elements) {
            for (Integer element : elements) {
                this.callingElementPath.add(element);
            }
            return this;
        }

        public final Builder withCallingElementPath(Iterable<? extends Integer> elements) {
            this.callingElementPath.clear();
            return this.addAllCallingElementPath(elements);
        }

        public final Builder addAllCallingElementPath(Iterable<? extends Integer> elements) {
            for (Integer n : elements) {
                this.callingElementPath.add(n);
            }
            return this;
        }

        public Builder clear() {
            this.tenantId = null;
            this.errorType = null;
            this.errorMessage = null;
            this.bpmnProcessId = null;
            this.processDefinitionKey = 0L;
            this.processInstanceKey = 0L;
            this.elementId = null;
            this.elementInstanceKey = 0L;
            this.jobKey = 0L;
            this.variableScopeKey = 0L;
            this.elementInstancePath.clear();
            this.processDefinitionPath.clear();
            this.callingElementPath.clear();
            return this;
        }

        public ImmutableIncidentRecordValue build() {
            return new ImmutableIncidentRecordValue(this.tenantId, this.errorType, this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.elementInstanceKey, this.jobKey, this.variableScopeKey, ImmutableIncidentRecordValue.createUnmodifiableList(true, this.elementInstancePath), ImmutableIncidentRecordValue.createUnmodifiableList(true, this.processDefinitionPath), ImmutableIncidentRecordValue.createUnmodifiableList(true, this.callingElementPath));
        }
    }
}

