package io.camunda.zeebe.protocol.record;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRecordValue.builder()}.
 */
@Generated(from = "RecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableRecordValue.Builder.class)
public final class ImmutableRecordValue implements RecordValue {
  private transient int hashCode; // hashCode lazily computed

  private ImmutableRecordValue(ImmutableRecordValue.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRecordValue
        && equalTo(0, (ImmutableRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return -694291146;
  }

  /**
   * Prints the immutable value {@code RecordValue}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RecordValue{}";
  }

  /**
   * Creates an immutable copy of a {@link RecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RecordValue instance
   */
  public static ImmutableRecordValue copyOf(RecordValue instance) {
    if (instance instanceof ImmutableRecordValue) {
      return (ImmutableRecordValue) instance;
    }
    return ImmutableRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRecordValue ImmutableRecordValue}.
   * <pre>
   * ImmutableRecordValue.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableRecordValue builder
   */
  public static ImmutableRecordValue.Builder builder() {
    return new ImmutableRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRecordValue ImmutableRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RecordValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RecordValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      return this;
    }

    /**
     * Builds a new {@link ImmutableRecordValue ImmutableRecordValue}.
     * @return An immutable instance of RecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRecordValue build() {
      return new ImmutableRecordValue(this);
    }



  }



}
