package io.camunda.zeebe.protocol.record.value.deployment;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.value.TenantOwned;
import java.util.Arrays;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ProcessMetadataValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProcessMetadataValue.builder()}.
 */
@Generated(from = "ProcessMetadataValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableProcessMetadataValue.Builder.class)
public final class ImmutableProcessMetadataValue
    implements ProcessMetadataValue {
  private final String tenantId;
  private final String bpmnProcessId;
  private final int version;
  private final String versionTag;
  private final long processDefinitionKey;
  private final String resourceName;
  private final byte[] checksum;
  private final boolean duplicate;
  private final long deploymentKey;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableProcessMetadataValue(
      String tenantId,
      String bpmnProcessId,
      int version,
      String versionTag,
      long processDefinitionKey,
      String resourceName,
      byte[] checksum,
      boolean duplicate,
      long deploymentKey) {
    this.tenantId = tenantId;
    this.bpmnProcessId = bpmnProcessId;
    this.version = version;
    this.versionTag = versionTag;
    this.processDefinitionKey = processDefinitionKey;
    this.resourceName = resourceName;
    this.checksum = checksum;
    this.duplicate = duplicate;
    this.deploymentKey = deploymentKey;
  }

  /**
   *Returns the identifier of the tenant that owns this entity. 
   */
  @Override
  public String getTenantId() {
    return tenantId;
  }

  /**
   * @return the bpmn process ID of this process
   */
  @Override
  public String getBpmnProcessId() {
    return bpmnProcessId;
  }

  /**
   * @return the version of this process
   */
  @Override
  public int getVersion() {
    return version;
  }

  /**
   * @return the custom version tag of this process
   */
  @Override
  public String getVersionTag() {
    return versionTag;
  }

  /**
   * @return the key of this process
   */
  @Override
  public long getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  /**
   * @return the name of the resource through which this process was deployed
   */
  @Override
  public String getResourceName() {
    return resourceName;
  }

  /**
   * @return the checksum of the process (MD5)
   */
  @Override
  public byte[] getChecksum() {
    return checksum;
  }

  /**
   * return true if the process is a duplicate (and has been deployed previously), false otherwise
   */
  @Override
  public boolean isDuplicate() {
    return duplicate;
  }

  /**
   * @return the key of the deployment this process was deployed with
   */
  @Override
  public long getDeploymentKey() {
    return deploymentKey;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessMetadataValue#getTenantId() tenantId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenantId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessMetadataValue withTenantId(String value) {
    if (Objects.equals(this.tenantId, value)) return this;
    return new ImmutableProcessMetadataValue(
        value,
        this.bpmnProcessId,
        this.version,
        this.versionTag,
        this.processDefinitionKey,
        this.resourceName,
        this.checksum,
        this.duplicate,
        this.deploymentKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessMetadataValue#getBpmnProcessId() bpmnProcessId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bpmnProcessId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessMetadataValue withBpmnProcessId(String value) {
    if (Objects.equals(this.bpmnProcessId, value)) return this;
    return new ImmutableProcessMetadataValue(
        this.tenantId,
        value,
        this.version,
        this.versionTag,
        this.processDefinitionKey,
        this.resourceName,
        this.checksum,
        this.duplicate,
        this.deploymentKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessMetadataValue#getVersion() version} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessMetadataValue withVersion(int value) {
    if (this.version == value) return this;
    return new ImmutableProcessMetadataValue(
        this.tenantId,
        this.bpmnProcessId,
        value,
        this.versionTag,
        this.processDefinitionKey,
        this.resourceName,
        this.checksum,
        this.duplicate,
        this.deploymentKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessMetadataValue#getVersionTag() versionTag} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for versionTag (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessMetadataValue withVersionTag(String value) {
    if (Objects.equals(this.versionTag, value)) return this;
    return new ImmutableProcessMetadataValue(
        this.tenantId,
        this.bpmnProcessId,
        this.version,
        value,
        this.processDefinitionKey,
        this.resourceName,
        this.checksum,
        this.duplicate,
        this.deploymentKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessMetadataValue#getProcessDefinitionKey() processDefinitionKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processDefinitionKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessMetadataValue withProcessDefinitionKey(long value) {
    if (this.processDefinitionKey == value) return this;
    return new ImmutableProcessMetadataValue(
        this.tenantId,
        this.bpmnProcessId,
        this.version,
        this.versionTag,
        value,
        this.resourceName,
        this.checksum,
        this.duplicate,
        this.deploymentKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessMetadataValue#getResourceName() resourceName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for resourceName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessMetadataValue withResourceName(String value) {
    if (Objects.equals(this.resourceName, value)) return this;
    return new ImmutableProcessMetadataValue(
        this.tenantId,
        this.bpmnProcessId,
        this.version,
        this.versionTag,
        this.processDefinitionKey,
        value,
        this.checksum,
        this.duplicate,
        this.deploymentKey);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ProcessMetadataValue#getChecksum() checksum}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for checksum
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProcessMetadataValue withChecksum(byte... elements) {
    byte[] newValue = elements == null ? null : elements.clone();
    return new ImmutableProcessMetadataValue(
        this.tenantId,
        this.bpmnProcessId,
        this.version,
        this.versionTag,
        this.processDefinitionKey,
        this.resourceName,
        newValue,
        this.duplicate,
        this.deploymentKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessMetadataValue#isDuplicate() duplicate} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for duplicate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessMetadataValue withDuplicate(boolean value) {
    if (this.duplicate == value) return this;
    return new ImmutableProcessMetadataValue(
        this.tenantId,
        this.bpmnProcessId,
        this.version,
        this.versionTag,
        this.processDefinitionKey,
        this.resourceName,
        this.checksum,
        value,
        this.deploymentKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessMetadataValue#getDeploymentKey() deploymentKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for deploymentKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessMetadataValue withDeploymentKey(long value) {
    if (this.deploymentKey == value) return this;
    return new ImmutableProcessMetadataValue(
        this.tenantId,
        this.bpmnProcessId,
        this.version,
        this.versionTag,
        this.processDefinitionKey,
        this.resourceName,
        this.checksum,
        this.duplicate,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProcessMetadataValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProcessMetadataValue
        && equalTo(0, (ImmutableProcessMetadataValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableProcessMetadataValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(tenantId, another.tenantId)
        && Objects.equals(bpmnProcessId, another.bpmnProcessId)
        && version == another.version
        && Objects.equals(versionTag, another.versionTag)
        && processDefinitionKey == another.processDefinitionKey
        && Objects.equals(resourceName, another.resourceName)
        && Arrays.equals(checksum, another.checksum)
        && duplicate == another.duplicate
        && deploymentKey == another.deploymentKey;
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code tenantId}, {@code bpmnProcessId}, {@code version}, {@code versionTag}, {@code processDefinitionKey}, {@code resourceName}, {@code checksum}, {@code duplicate}, {@code deploymentKey}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(tenantId);
    h += (h << 5) + Objects.hashCode(bpmnProcessId);
    h += (h << 5) + version;
    h += (h << 5) + Objects.hashCode(versionTag);
    h += (h << 5) + Long.hashCode(processDefinitionKey);
    h += (h << 5) + Objects.hashCode(resourceName);
    h += (h << 5) + Arrays.hashCode(checksum);
    h += (h << 5) + Boolean.hashCode(duplicate);
    h += (h << 5) + Long.hashCode(deploymentKey);
    return h;
  }

  /**
   * Prints the immutable value {@code ProcessMetadataValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProcessMetadataValue{"
        + "tenantId=" + tenantId
        + ", bpmnProcessId=" + bpmnProcessId
        + ", version=" + version
        + ", versionTag=" + versionTag
        + ", processDefinitionKey=" + processDefinitionKey
        + ", resourceName=" + resourceName
        + ", checksum=" + Arrays.toString(checksum)
        + ", duplicate=" + duplicate
        + ", deploymentKey=" + deploymentKey
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ProcessMetadataValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProcessMetadataValue instance
   */
  public static ImmutableProcessMetadataValue copyOf(ProcessMetadataValue instance) {
    if (instance instanceof ImmutableProcessMetadataValue) {
      return (ImmutableProcessMetadataValue) instance;
    }
    return ImmutableProcessMetadataValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProcessMetadataValue ImmutableProcessMetadataValue}.
   * <pre>
   * ImmutableProcessMetadataValue.builder()
   *    .withTenantId(String | null) // nullable {@link ProcessMetadataValue#getTenantId() tenantId}
   *    .withBpmnProcessId(String | null) // nullable {@link ProcessMetadataValue#getBpmnProcessId() bpmnProcessId}
   *    .withVersion(int) // optional {@link ProcessMetadataValue#getVersion() version}
   *    .withVersionTag(String | null) // nullable {@link ProcessMetadataValue#getVersionTag() versionTag}
   *    .withProcessDefinitionKey(long) // optional {@link ProcessMetadataValue#getProcessDefinitionKey() processDefinitionKey}
   *    .withResourceName(String | null) // nullable {@link ProcessMetadataValue#getResourceName() resourceName}
   *    .withChecksum(byte[] | null) // nullable {@link ProcessMetadataValue#getChecksum() checksum}
   *    .withDuplicate(boolean) // optional {@link ProcessMetadataValue#isDuplicate() duplicate}
   *    .withDeploymentKey(long) // optional {@link ProcessMetadataValue#getDeploymentKey() deploymentKey}
   *    .build();
   * </pre>
   * @return A new ImmutableProcessMetadataValue builder
   */
  public static ImmutableProcessMetadataValue.Builder builder() {
    return new ImmutableProcessMetadataValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProcessMetadataValue ImmutableProcessMetadataValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProcessMetadataValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private String tenantId;
    private String bpmnProcessId;
    private int version;
    private String versionTag;
    private long processDefinitionKey;
    private String resourceName;
    private byte[] checksum;
    private boolean duplicate;
    private long deploymentKey;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessMetadataValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.TenantOwned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TenantOwned instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof ProcessMetadataValue) {
        ProcessMetadataValue instance = (ProcessMetadataValue) object;
        this.withDeploymentKey(instance.getDeploymentKey());
        if ((bits & 0x1L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x1L;
        }
        byte[] checksumValue = instance.getChecksum();
        if (checksumValue != null) {
          withChecksum(checksumValue);
        }
        String versionTagValue = instance.getVersionTag();
        if (versionTagValue != null) {
          withVersionTag(versionTagValue);
        }
        String resourceNameValue = instance.getResourceName();
        if (resourceNameValue != null) {
          withResourceName(resourceNameValue);
        }
        this.withDuplicate(instance.isDuplicate());
        String bpmnProcessIdValue = instance.getBpmnProcessId();
        if (bpmnProcessIdValue != null) {
          withBpmnProcessId(bpmnProcessIdValue);
        }
        this.withVersion(instance.getVersion());
        this.withProcessDefinitionKey(instance.getProcessDefinitionKey());
      }
      if (object instanceof TenantOwned) {
        TenantOwned instance = (TenantOwned) object;
        if ((bits & 0x1L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link ProcessMetadataValue#getTenantId() tenantId} attribute.
     * @param tenantId The value for tenantId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTenantId(String tenantId) {
      this.tenantId = tenantId;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessMetadataValue#getBpmnProcessId() bpmnProcessId} attribute.
     * @param bpmnProcessId The value for bpmnProcessId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withBpmnProcessId(String bpmnProcessId) {
      this.bpmnProcessId = bpmnProcessId;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessMetadataValue#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVersion(int version) {
      this.version = version;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessMetadataValue#getVersionTag() versionTag} attribute.
     * @param versionTag The value for versionTag (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVersionTag(String versionTag) {
      this.versionTag = versionTag;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessMetadataValue#getProcessDefinitionKey() processDefinitionKey} attribute.
     * @param processDefinitionKey The value for processDefinitionKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessDefinitionKey(long processDefinitionKey) {
      this.processDefinitionKey = processDefinitionKey;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessMetadataValue#getResourceName() resourceName} attribute.
     * @param resourceName The value for resourceName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withResourceName(String resourceName) {
      this.resourceName = resourceName;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessMetadataValue#getChecksum() checksum} attribute.
     * @param checksum The elements for checksum
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withChecksum(byte... checksum) {
      this.checksum = checksum;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessMetadataValue#isDuplicate() duplicate} attribute.
     * @param duplicate The value for duplicate 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDuplicate(boolean duplicate) {
      this.duplicate = duplicate;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessMetadataValue#getDeploymentKey() deploymentKey} attribute.
     * @param deploymentKey The value for deploymentKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDeploymentKey(long deploymentKey) {
      this.deploymentKey = deploymentKey;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.tenantId = null;
      this.bpmnProcessId = null;
      this.version = 0;
      this.versionTag = null;
      this.processDefinitionKey = 0;
      this.resourceName = null;
      this.checksum = null;
      this.duplicate = false;
      this.deploymentKey = 0;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProcessMetadataValue ImmutableProcessMetadataValue}.
     * @return An immutable instance of ProcessMetadataValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProcessMetadataValue build() {
      return new ImmutableProcessMetadataValue(
          tenantId,
          bpmnProcessId,
          version,
          versionTag,
          processDefinitionKey,
          resourceName,
          checksum,
          duplicate,
          deploymentKey);
    }



  }



}
