/* Generated SBE (Simple Binary Encoding) message codec. */
package io.camunda.zeebe.protocol.record;

import org.agrona.DirectBuffer;
import org.agrona.sbe.*;


/**
 * Version information
 */
@SuppressWarnings("all")
public final class VersionDecoder implements CompositeDecoderFlyweight
{
    public static final int SCHEMA_ID = 0;
    public static final int SCHEMA_VERSION = 5;
    public static final String SEMANTIC_VERSION = "8.6.6";
    public static final int ENCODED_LENGTH = 12;
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private int offset;
    private DirectBuffer buffer;

    public VersionDecoder wrap(final DirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;

        return this;
    }

    public DirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public int encodedLength()
    {
        return ENCODED_LENGTH;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public static int majorVersionEncodingOffset()
    {
        return 0;
    }

    public static int majorVersionEncodingLength()
    {
        return 4;
    }

    public static int majorVersionSinceVersion()
    {
        return 2;
    }

    public static int majorVersionNullValue()
    {
        return -2147483648;
    }

    public static int majorVersionMinValue()
    {
        return -2147483647;
    }

    public static int majorVersionMaxValue()
    {
        return 2147483647;
    }

    public int majorVersion()
    {
        return buffer.getInt(offset + 0, BYTE_ORDER);
    }


    public static int minorVersionEncodingOffset()
    {
        return 4;
    }

    public static int minorVersionEncodingLength()
    {
        return 4;
    }

    public static int minorVersionSinceVersion()
    {
        return 2;
    }

    public static int minorVersionNullValue()
    {
        return -2147483648;
    }

    public static int minorVersionMinValue()
    {
        return -2147483647;
    }

    public static int minorVersionMaxValue()
    {
        return 2147483647;
    }

    public int minorVersion()
    {
        return buffer.getInt(offset + 4, BYTE_ORDER);
    }


    public static int patchVersionEncodingOffset()
    {
        return 8;
    }

    public static int patchVersionEncodingLength()
    {
        return 4;
    }

    public static int patchVersionSinceVersion()
    {
        return 2;
    }

    public static int patchVersionNullValue()
    {
        return -2147483648;
    }

    public static int patchVersionMinValue()
    {
        return -2147483647;
    }

    public static int patchVersionMaxValue()
    {
        return 2147483647;
    }

    public int patchVersion()
    {
        return buffer.getInt(offset + 8, BYTE_ORDER);
    }


    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        builder.append('(');
        builder.append("majorVersion=");
        builder.append(this.majorVersion());
        builder.append('|');
        builder.append("minorVersion=");
        builder.append(this.minorVersion());
        builder.append('|');
        builder.append("patchVersion=");
        builder.append(this.patchVersion());
        builder.append(')');

        return builder;
    }
}
