package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ClockRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableClockRecordValue.builder()}.
 */
@Generated(from = "ClockRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableClockRecordValue.Builder.class)
public final class ImmutableClockRecordValue
    implements ClockRecordValue {
  private final long time;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableClockRecordValue(long time) {
    this.time = time;
  }

  /**
   * Returns the value of this clock modification, if any.
   * <ol>
   *   <li>If the associated intent is a pin, then the time is a Unix timestamp as epoch
   *       milliseconds
   *   <li>If the associated intent is an offset, then time would be the duration in milliseconds
   *   <li>If the associated intent is a reset, then this value has no meaning, and will be 0
   * </ol>
   */
  @Override
  public long getTime() {
    return time;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClockRecordValue#getTime() time} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for time
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableClockRecordValue withTime(long value) {
    if (this.time == value) return this;
    return new ImmutableClockRecordValue(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableClockRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableClockRecordValue
        && equalTo(0, (ImmutableClockRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableClockRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return time == another.time;
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code time}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Long.hashCode(time);
    return h;
  }

  /**
   * Prints the immutable value {@code ClockRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ClockRecordValue{"
        + "time=" + time
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ClockRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ClockRecordValue instance
   */
  public static ImmutableClockRecordValue copyOf(ClockRecordValue instance) {
    if (instance instanceof ImmutableClockRecordValue) {
      return (ImmutableClockRecordValue) instance;
    }
    return ImmutableClockRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableClockRecordValue ImmutableClockRecordValue}.
   * <pre>
   * ImmutableClockRecordValue.builder()
   *    .withTime(long) // optional {@link ClockRecordValue#getTime() time}
   *    .build();
   * </pre>
   * @return A new ImmutableClockRecordValue builder
   */
  public static ImmutableClockRecordValue.Builder builder() {
    return new ImmutableClockRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableClockRecordValue ImmutableClockRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ClockRecordValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private long time;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ClockRecordValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ClockRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      this.withTime(instance.getTime());
      return this;
    }

    /**
     * Initializes the value for the {@link ClockRecordValue#getTime() time} attribute.
     * @param time The value for time 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTime(long time) {
      this.time = time;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.time = 0;
      return this;
    }

    /**
     * Builds a new {@link ImmutableClockRecordValue ImmutableClockRecordValue}.
     * @return An immutable instance of ClockRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableClockRecordValue build() {
      return new ImmutableClockRecordValue(time);
    }



  }



}
