package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.RecordValueWithVariables;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MessageCorrelationRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMessageCorrelationRecordValue.builder()}.
 */
@Generated(from = "MessageCorrelationRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableMessageCorrelationRecordValue.Builder.class)
public final class ImmutableMessageCorrelationRecordValue
    implements MessageCorrelationRecordValue {
  private final Map<String, Object> variables;
  private final String tenantId;
  private final long processInstanceKey;
  private final String name;
  private final String correlationKey;
  private final long messageKey;
  private final long requestId;
  private final int requestStreamId;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableMessageCorrelationRecordValue(
      Map<String, Object> variables,
      String tenantId,
      long processInstanceKey,
      String name,
      String correlationKey,
      long messageKey,
      long requestId,
      int requestStreamId) {
    this.variables = variables;
    this.tenantId = tenantId;
    this.processInstanceKey = processInstanceKey;
    this.name = name;
    this.correlationKey = correlationKey;
    this.messageKey = messageKey;
    this.requestId = requestId;
    this.requestStreamId = requestStreamId;
  }

  /**
   * @return the variables of this record. Can be empty.
   */
  @Override
  public Map<String, Object> getVariables() {
    return variables;
  }

  /**
   *Returns the identifier of the tenant that owns this entity. 
   */
  @Override
  public String getTenantId() {
    return tenantId;
  }

  /**
   * @return the key of the corresponding process instance
   */
  @Override
  public long getProcessInstanceKey() {
    return processInstanceKey;
  }

  /**
   * @return the name of the message
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return the correlation key of the message
   */
  @Override
  public String getCorrelationKey() {
    return correlationKey;
  }

  /**
   * @return the key of the message
   */
  @Override
  public long getMessageKey() {
    return messageKey;
  }

  /**
   * @return the request id of the initial correlate command
   */
  @Override
  public long getRequestId() {
    return requestId;
  }

  /**
   * @return the request stream id of the initial correlate command
   */
  @Override
  public int getRequestStreamId() {
    return requestStreamId;
  }

  /**
   * Copy the current immutable object by replacing the {@link MessageCorrelationRecordValue#getVariables() variables} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the variables map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMessageCorrelationRecordValue withVariables(Map<String, ? extends Object> entries) {
    if (this.variables == entries) return this;
    Map<String, Object> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableMessageCorrelationRecordValue(
        newValue,
        this.tenantId,
        this.processInstanceKey,
        this.name,
        this.correlationKey,
        this.messageKey,
        this.requestId,
        this.requestStreamId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageCorrelationRecordValue#getTenantId() tenantId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenantId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageCorrelationRecordValue withTenantId(String value) {
    if (Objects.equals(this.tenantId, value)) return this;
    return new ImmutableMessageCorrelationRecordValue(
        this.variables,
        value,
        this.processInstanceKey,
        this.name,
        this.correlationKey,
        this.messageKey,
        this.requestId,
        this.requestStreamId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageCorrelationRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageCorrelationRecordValue withProcessInstanceKey(long value) {
    if (this.processInstanceKey == value) return this;
    return new ImmutableMessageCorrelationRecordValue(
        this.variables,
        this.tenantId,
        value,
        this.name,
        this.correlationKey,
        this.messageKey,
        this.requestId,
        this.requestStreamId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageCorrelationRecordValue#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageCorrelationRecordValue withName(String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableMessageCorrelationRecordValue(
        this.variables,
        this.tenantId,
        this.processInstanceKey,
        value,
        this.correlationKey,
        this.messageKey,
        this.requestId,
        this.requestStreamId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageCorrelationRecordValue#getCorrelationKey() correlationKey} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for correlationKey (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageCorrelationRecordValue withCorrelationKey(String value) {
    if (Objects.equals(this.correlationKey, value)) return this;
    return new ImmutableMessageCorrelationRecordValue(
        this.variables,
        this.tenantId,
        this.processInstanceKey,
        this.name,
        value,
        this.messageKey,
        this.requestId,
        this.requestStreamId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageCorrelationRecordValue#getMessageKey() messageKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for messageKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageCorrelationRecordValue withMessageKey(long value) {
    if (this.messageKey == value) return this;
    return new ImmutableMessageCorrelationRecordValue(
        this.variables,
        this.tenantId,
        this.processInstanceKey,
        this.name,
        this.correlationKey,
        value,
        this.requestId,
        this.requestStreamId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageCorrelationRecordValue#getRequestId() requestId} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for requestId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageCorrelationRecordValue withRequestId(long value) {
    if (this.requestId == value) return this;
    return new ImmutableMessageCorrelationRecordValue(
        this.variables,
        this.tenantId,
        this.processInstanceKey,
        this.name,
        this.correlationKey,
        this.messageKey,
        value,
        this.requestStreamId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageCorrelationRecordValue#getRequestStreamId() requestStreamId} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for requestStreamId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageCorrelationRecordValue withRequestStreamId(int value) {
    if (this.requestStreamId == value) return this;
    return new ImmutableMessageCorrelationRecordValue(
        this.variables,
        this.tenantId,
        this.processInstanceKey,
        this.name,
        this.correlationKey,
        this.messageKey,
        this.requestId,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMessageCorrelationRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMessageCorrelationRecordValue
        && equalTo(0, (ImmutableMessageCorrelationRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableMessageCorrelationRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return variables.equals(another.variables)
        && Objects.equals(tenantId, another.tenantId)
        && processInstanceKey == another.processInstanceKey
        && Objects.equals(name, another.name)
        && Objects.equals(correlationKey, another.correlationKey)
        && messageKey == another.messageKey
        && requestId == another.requestId
        && requestStreamId == another.requestStreamId;
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code variables}, {@code tenantId}, {@code processInstanceKey}, {@code name}, {@code correlationKey}, {@code messageKey}, {@code requestId}, {@code requestStreamId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + variables.hashCode();
    h += (h << 5) + Objects.hashCode(tenantId);
    h += (h << 5) + Long.hashCode(processInstanceKey);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(correlationKey);
    h += (h << 5) + Long.hashCode(messageKey);
    h += (h << 5) + Long.hashCode(requestId);
    h += (h << 5) + requestStreamId;
    return h;
  }

  /**
   * Prints the immutable value {@code MessageCorrelationRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MessageCorrelationRecordValue{"
        + "variables=" + variables
        + ", tenantId=" + tenantId
        + ", processInstanceKey=" + processInstanceKey
        + ", name=" + name
        + ", correlationKey=" + correlationKey
        + ", messageKey=" + messageKey
        + ", requestId=" + requestId
        + ", requestStreamId=" + requestStreamId
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link MessageCorrelationRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MessageCorrelationRecordValue instance
   */
  public static ImmutableMessageCorrelationRecordValue copyOf(MessageCorrelationRecordValue instance) {
    if (instance instanceof ImmutableMessageCorrelationRecordValue) {
      return (ImmutableMessageCorrelationRecordValue) instance;
    }
    return ImmutableMessageCorrelationRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMessageCorrelationRecordValue ImmutableMessageCorrelationRecordValue}.
   * <pre>
   * ImmutableMessageCorrelationRecordValue.builder()
   *    .putVariable|putAllVariables(String =&gt; Object) // {@link MessageCorrelationRecordValue#getVariables() variables} mappings
   *    .withTenantId(String | null) // nullable {@link MessageCorrelationRecordValue#getTenantId() tenantId}
   *    .withProcessInstanceKey(long) // optional {@link MessageCorrelationRecordValue#getProcessInstanceKey() processInstanceKey}
   *    .withName(String | null) // nullable {@link MessageCorrelationRecordValue#getName() name}
   *    .withCorrelationKey(String | null) // nullable {@link MessageCorrelationRecordValue#getCorrelationKey() correlationKey}
   *    .withMessageKey(long) // optional {@link MessageCorrelationRecordValue#getMessageKey() messageKey}
   *    .withRequestId(long) // optional {@link MessageCorrelationRecordValue#getRequestId() requestId}
   *    .withRequestStreamId(int) // optional {@link MessageCorrelationRecordValue#getRequestStreamId() requestStreamId}
   *    .build();
   * </pre>
   * @return A new ImmutableMessageCorrelationRecordValue builder
   */
  public static ImmutableMessageCorrelationRecordValue.Builder builder() {
    return new ImmutableMessageCorrelationRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMessageCorrelationRecordValue ImmutableMessageCorrelationRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MessageCorrelationRecordValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private Map<String, Object> variables = new LinkedHashMap<String, Object>();
    private String tenantId;
    private long processInstanceKey;
    private String name;
    private String correlationKey;
    private long messageKey;
    private long requestId;
    private int requestStreamId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.MessageCorrelationRecordValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MessageCorrelationRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessInstanceRelated instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.TenantOwned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TenantOwned instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.RecordValueWithVariables} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RecordValueWithVariables instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof MessageCorrelationRecordValue) {
        MessageCorrelationRecordValue instance = (MessageCorrelationRecordValue) object;
        if ((bits & 0x1L) == 0) {
          this.withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
        this.withMessageKey(instance.getMessageKey());
        if ((bits & 0x2L) == 0) {
          putAllVariables(instance.getVariables());
          bits |= 0x2L;
        }
        this.withRequestId(instance.getRequestId());
        if ((bits & 0x4L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x4L;
        }
        String nameValue = instance.getName();
        if (nameValue != null) {
          withName(nameValue);
        }
        this.withRequestStreamId(instance.getRequestStreamId());
        String correlationKeyValue = instance.getCorrelationKey();
        if (correlationKeyValue != null) {
          withCorrelationKey(correlationKeyValue);
        }
      }
      if (object instanceof ProcessInstanceRelated) {
        ProcessInstanceRelated instance = (ProcessInstanceRelated) object;
        if ((bits & 0x1L) == 0) {
          this.withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
      }
      if (object instanceof TenantOwned) {
        TenantOwned instance = (TenantOwned) object;
        if ((bits & 0x4L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x4L;
        }
      }
      if (object instanceof RecordValueWithVariables) {
        RecordValueWithVariables instance = (RecordValueWithVariables) object;
        if ((bits & 0x2L) == 0) {
          putAllVariables(instance.getVariables());
          bits |= 0x2L;
        }
      }
    }

    /**
     * Put one entry to the {@link MessageCorrelationRecordValue#getVariables() variables} map.
     * @param key The key in the variables map
     * @param value The associated value in the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(String key, Object value) {
      this.variables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link MessageCorrelationRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.variables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link MessageCorrelationRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVariables(Map<String, ? extends Object> entries) {
      this.variables.clear();
      return putAllVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link MessageCorrelationRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllVariables(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.variables.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link MessageCorrelationRecordValue#getTenantId() tenantId} attribute.
     * @param tenantId The value for tenantId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTenantId(String tenantId) {
      this.tenantId = tenantId;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageCorrelationRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
     * @param processInstanceKey The value for processInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessInstanceKey(long processInstanceKey) {
      this.processInstanceKey = processInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageCorrelationRecordValue#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withName(String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageCorrelationRecordValue#getCorrelationKey() correlationKey} attribute.
     * @param correlationKey The value for correlationKey (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withCorrelationKey(String correlationKey) {
      this.correlationKey = correlationKey;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageCorrelationRecordValue#getMessageKey() messageKey} attribute.
     * @param messageKey The value for messageKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withMessageKey(long messageKey) {
      this.messageKey = messageKey;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageCorrelationRecordValue#getRequestId() requestId} attribute.
     * @param requestId The value for requestId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withRequestId(long requestId) {
      this.requestId = requestId;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageCorrelationRecordValue#getRequestStreamId() requestStreamId} attribute.
     * @param requestStreamId The value for requestStreamId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withRequestStreamId(int requestStreamId) {
      this.requestStreamId = requestStreamId;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.variables.clear();
      this.tenantId = null;
      this.processInstanceKey = 0;
      this.name = null;
      this.correlationKey = null;
      this.messageKey = 0;
      this.requestId = 0;
      this.requestStreamId = 0;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMessageCorrelationRecordValue ImmutableMessageCorrelationRecordValue}.
     * @return An immutable instance of MessageCorrelationRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMessageCorrelationRecordValue build() {
      return new ImmutableMessageCorrelationRecordValue(
          createUnmodifiableMap(false, false, variables),
          tenantId,
          processInstanceKey,
          name,
          correlationKey,
          messageKey,
          requestId,
          requestStreamId);
    }



  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }



}
