package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UserRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUserRecordValue.builder()}.
 */
@Generated(from = "UserRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableUserRecordValue.Builder.class)
public final class ImmutableUserRecordValue implements UserRecordValue {
  private final Long userKey;
  private final String username;
  private final String name;
  private final String email;
  private final String password;
  private final UserType userType;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableUserRecordValue(
      Long userKey,
      String username,
      String name,
      String email,
      String password,
      UserType userType) {
    this.userKey = userKey;
    this.username = username;
    this.name = name;
    this.email = email;
    this.password = password;
    this.userType = userType;
  }

  /**
   * @return The value of the {@code userKey} attribute
   */
  @Override
  public Long getUserKey() {
    return userKey;
  }

  /**
   * @return The value of the {@code username} attribute
   */
  @Override
  public String getUsername() {
    return username;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code email} attribute
   */
  @Override
  public String getEmail() {
    return email;
  }

  /**
   * @return The value of the {@code password} attribute
   */
  @Override
  public String getPassword() {
    return password;
  }

  /**
   * @return The value of the {@code userType} attribute
   */
  @Override
  public UserType getUserType() {
    return userType;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserRecordValue#getUserKey() userKey} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for userKey (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserRecordValue withUserKey(Long value) {
    if (Objects.equals(this.userKey, value)) return this;
    return new ImmutableUserRecordValue(value, this.username, this.name, this.email, this.password, this.userType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserRecordValue#getUsername() username} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for username (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserRecordValue withUsername(String value) {
    if (Objects.equals(this.username, value)) return this;
    return new ImmutableUserRecordValue(this.userKey, value, this.name, this.email, this.password, this.userType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserRecordValue#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserRecordValue withName(String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableUserRecordValue(this.userKey, this.username, value, this.email, this.password, this.userType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserRecordValue#getEmail() email} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for email (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserRecordValue withEmail(String value) {
    if (Objects.equals(this.email, value)) return this;
    return new ImmutableUserRecordValue(this.userKey, this.username, this.name, value, this.password, this.userType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserRecordValue#getPassword() password} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for password (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserRecordValue withPassword(String value) {
    if (Objects.equals(this.password, value)) return this;
    return new ImmutableUserRecordValue(this.userKey, this.username, this.name, this.email, value, this.userType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserRecordValue#getUserType() userType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for userType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserRecordValue withUserType(UserType value) {
    if (this.userType == value) return this;
    return new ImmutableUserRecordValue(this.userKey, this.username, this.name, this.email, this.password, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUserRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUserRecordValue
        && equalTo(0, (ImmutableUserRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableUserRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(userKey, another.userKey)
        && Objects.equals(username, another.username)
        && Objects.equals(name, another.name)
        && Objects.equals(email, another.email)
        && Objects.equals(password, another.password)
        && Objects.equals(userType, another.userType);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code userKey}, {@code username}, {@code name}, {@code email}, {@code password}, {@code userType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(userKey);
    h += (h << 5) + Objects.hashCode(username);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(email);
    h += (h << 5) + Objects.hashCode(password);
    h += (h << 5) + Objects.hashCode(userType);
    return h;
  }

  /**
   * Prints the immutable value {@code UserRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UserRecordValue{"
        + "userKey=" + userKey
        + ", username=" + username
        + ", name=" + name
        + ", email=" + email
        + ", password=" + password
        + ", userType=" + userType
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link UserRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UserRecordValue instance
   */
  public static ImmutableUserRecordValue copyOf(UserRecordValue instance) {
    if (instance instanceof ImmutableUserRecordValue) {
      return (ImmutableUserRecordValue) instance;
    }
    return ImmutableUserRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUserRecordValue ImmutableUserRecordValue}.
   * <pre>
   * ImmutableUserRecordValue.builder()
   *    .withUserKey(Long | null) // nullable {@link UserRecordValue#getUserKey() userKey}
   *    .withUsername(String | null) // nullable {@link UserRecordValue#getUsername() username}
   *    .withName(String | null) // nullable {@link UserRecordValue#getName() name}
   *    .withEmail(String | null) // nullable {@link UserRecordValue#getEmail() email}
   *    .withPassword(String | null) // nullable {@link UserRecordValue#getPassword() password}
   *    .withUserType(io.camunda.zeebe.protocol.record.value.UserType | null) // nullable {@link UserRecordValue#getUserType() userType}
   *    .build();
   * </pre>
   * @return A new ImmutableUserRecordValue builder
   */
  public static ImmutableUserRecordValue.Builder builder() {
    return new ImmutableUserRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUserRecordValue ImmutableUserRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UserRecordValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private Long userKey;
    private String username;
    private String name;
    private String email;
    private String password;
    private UserType userType;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UserRecordValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UserRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      Long userKeyValue = instance.getUserKey();
      if (userKeyValue != null) {
        withUserKey(userKeyValue);
      }
      String usernameValue = instance.getUsername();
      if (usernameValue != null) {
        withUsername(usernameValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        withName(nameValue);
      }
      String emailValue = instance.getEmail();
      if (emailValue != null) {
        withEmail(emailValue);
      }
      String passwordValue = instance.getPassword();
      if (passwordValue != null) {
        withPassword(passwordValue);
      }
      UserType userTypeValue = instance.getUserType();
      if (userTypeValue != null) {
        withUserType(userTypeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UserRecordValue#getUserKey() userKey} attribute.
     * @param userKey The value for userKey (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withUserKey(Long userKey) {
      this.userKey = userKey;
      return this;
    }

    /**
     * Initializes the value for the {@link UserRecordValue#getUsername() username} attribute.
     * @param username The value for username (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withUsername(String username) {
      this.username = username;
      return this;
    }

    /**
     * Initializes the value for the {@link UserRecordValue#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withName(String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link UserRecordValue#getEmail() email} attribute.
     * @param email The value for email (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withEmail(String email) {
      this.email = email;
      return this;
    }

    /**
     * Initializes the value for the {@link UserRecordValue#getPassword() password} attribute.
     * @param password The value for password (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withPassword(String password) {
      this.password = password;
      return this;
    }

    /**
     * Initializes the value for the {@link UserRecordValue#getUserType() userType} attribute.
     * @param userType The value for userType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withUserType(UserType userType) {
      this.userType = userType;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.userKey = null;
      this.username = null;
      this.name = null;
      this.email = null;
      this.password = null;
      this.userType = null;
      return this;
    }

    /**
     * Builds a new {@link ImmutableUserRecordValue ImmutableUserRecordValue}.
     * @return An immutable instance of UserRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUserRecordValue build() {
      return new ImmutableUserRecordValue(userKey, username, name, email, password, userType);
    }



  }



}
