/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.intent;

import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceRelatedIntent;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum UserTaskIntent implements ProcessInstanceRelatedIntent
{
    CREATING(0),
    CREATED(1),
    COMPLETE(2, false),
    COMPLETING(3),
    COMPLETED(4),
    CANCELING(5),
    CANCELED(6),
    ASSIGN(7),
    ASSIGNING(8),
    ASSIGNED(9),
    CLAIM(10),
    UPDATE(11),
    UPDATING(12),
    UPDATED(13),
    MIGRATED(14),
    COMPLETE_TASK_LISTENER(15),
    DENY_TASK_LISTENER(16),
    COMPLETION_DENIED(17),
    CORRECTED(18);

    private final short value;
    private final boolean shouldBanInstance;

    private UserTaskIntent(int value) {
        this(value, true);
    }

    private UserTaskIntent(int value, boolean shouldBanInstance) {
        this.value = (short)value;
        this.shouldBanInstance = shouldBanInstance;
    }

    public short getIntent() {
        return this.value;
    }

    public static Intent from(short value) {
        switch (value) {
            case 0: {
                return CREATING;
            }
            case 1: {
                return CREATED;
            }
            case 2: {
                return COMPLETE;
            }
            case 3: {
                return COMPLETING;
            }
            case 4: {
                return COMPLETED;
            }
            case 5: {
                return CANCELING;
            }
            case 6: {
                return CANCELED;
            }
            case 7: {
                return ASSIGN;
            }
            case 8: {
                return ASSIGNING;
            }
            case 9: {
                return ASSIGNED;
            }
            case 10: {
                return CLAIM;
            }
            case 11: {
                return UPDATE;
            }
            case 12: {
                return UPDATING;
            }
            case 13: {
                return UPDATED;
            }
            case 14: {
                return MIGRATED;
            }
            case 15: {
                return COMPLETE_TASK_LISTENER;
            }
            case 16: {
                return DENY_TASK_LISTENER;
            }
            case 17: {
                return COMPLETION_DENIED;
            }
            case 18: {
                return CORRECTED;
            }
        }
        return UNKNOWN;
    }

    @Override
    public short value() {
        return this.value;
    }

    @Override
    public boolean isEvent() {
        switch (this.ordinal()) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean shouldBanInstanceOnError() {
        return this.shouldBanInstance;
    }

    public static Set<UserTaskIntent> commands() {
        return Stream.of(UserTaskIntent.values()).filter(intent -> !intent.isEvent()).collect(Collectors.toSet());
    }
}

