/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="JobRecordValue.JobResultCorrectionsValue", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableJobResultCorrectionsValue
implements JobRecordValue.JobResultCorrectionsValue {
    private final String assignee;
    private final String dueDate;
    private final String followUpDate;
    private final List<String> candidateGroups;
    private final List<String> candidateUsers;
    private final int priority;
    private transient int hashCode;

    private ImmutableJobResultCorrectionsValue(String assignee, String dueDate, String followUpDate, List<String> candidateGroups, List<String> candidateUsers, int priority) {
        this.assignee = assignee;
        this.dueDate = dueDate;
        this.followUpDate = followUpDate;
        this.candidateGroups = candidateGroups;
        this.candidateUsers = candidateUsers;
        this.priority = priority;
    }

    @Override
    public String getAssignee() {
        return this.assignee;
    }

    @Override
    public String getDueDate() {
        return this.dueDate;
    }

    @Override
    public String getFollowUpDate() {
        return this.followUpDate;
    }

    @Override
    public List<String> getCandidateGroups() {
        return this.candidateGroups;
    }

    @Override
    public List<String> getCandidateUsers() {
        return this.candidateUsers;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public final ImmutableJobResultCorrectionsValue withAssignee(String value) {
        if (Objects.equals(this.assignee, value)) {
            return this;
        }
        return new ImmutableJobResultCorrectionsValue(value, this.dueDate, this.followUpDate, this.candidateGroups, this.candidateUsers, this.priority);
    }

    public final ImmutableJobResultCorrectionsValue withDueDate(String value) {
        if (Objects.equals(this.dueDate, value)) {
            return this;
        }
        return new ImmutableJobResultCorrectionsValue(this.assignee, value, this.followUpDate, this.candidateGroups, this.candidateUsers, this.priority);
    }

    public final ImmutableJobResultCorrectionsValue withFollowUpDate(String value) {
        if (Objects.equals(this.followUpDate, value)) {
            return this;
        }
        return new ImmutableJobResultCorrectionsValue(this.assignee, this.dueDate, value, this.candidateGroups, this.candidateUsers, this.priority);
    }

    public final ImmutableJobResultCorrectionsValue withCandidateGroups(String ... elements) {
        List<String> newValue = ImmutableJobResultCorrectionsValue.createUnmodifiableList(false, ImmutableJobResultCorrectionsValue.createSafeList(Arrays.asList(elements), false, false));
        return new ImmutableJobResultCorrectionsValue(this.assignee, this.dueDate, this.followUpDate, newValue, this.candidateUsers, this.priority);
    }

    public final ImmutableJobResultCorrectionsValue withCandidateGroups(Iterable<String> elements) {
        if (this.candidateGroups == elements) {
            return this;
        }
        List<String> newValue = ImmutableJobResultCorrectionsValue.createUnmodifiableList(false, ImmutableJobResultCorrectionsValue.createSafeList(elements, false, false));
        return new ImmutableJobResultCorrectionsValue(this.assignee, this.dueDate, this.followUpDate, newValue, this.candidateUsers, this.priority);
    }

    public final ImmutableJobResultCorrectionsValue withCandidateUsers(String ... elements) {
        List<String> newValue = ImmutableJobResultCorrectionsValue.createUnmodifiableList(false, ImmutableJobResultCorrectionsValue.createSafeList(Arrays.asList(elements), false, false));
        return new ImmutableJobResultCorrectionsValue(this.assignee, this.dueDate, this.followUpDate, this.candidateGroups, newValue, this.priority);
    }

    public final ImmutableJobResultCorrectionsValue withCandidateUsers(Iterable<String> elements) {
        if (this.candidateUsers == elements) {
            return this;
        }
        List<String> newValue = ImmutableJobResultCorrectionsValue.createUnmodifiableList(false, ImmutableJobResultCorrectionsValue.createSafeList(elements, false, false));
        return new ImmutableJobResultCorrectionsValue(this.assignee, this.dueDate, this.followUpDate, this.candidateGroups, newValue, this.priority);
    }

    public final ImmutableJobResultCorrectionsValue withPriority(int value) {
        if (this.priority == value) {
            return this;
        }
        return new ImmutableJobResultCorrectionsValue(this.assignee, this.dueDate, this.followUpDate, this.candidateGroups, this.candidateUsers, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJobResultCorrectionsValue && this.equalTo(0, (ImmutableJobResultCorrectionsValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableJobResultCorrectionsValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.assignee, another.assignee) && Objects.equals(this.dueDate, another.dueDate) && Objects.equals(this.followUpDate, another.followUpDate) && this.candidateGroups.equals(another.candidateGroups) && this.candidateUsers.equals(another.candidateUsers) && this.priority == another.priority;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.assignee);
        h += (h << 5) + Objects.hashCode(this.dueDate);
        h += (h << 5) + Objects.hashCode(this.followUpDate);
        h += (h << 5) + this.candidateGroups.hashCode();
        h += (h << 5) + this.candidateUsers.hashCode();
        h += (h << 5) + this.priority;
        return h;
    }

    public String toString() {
        return "JobResultCorrectionsValue{assignee=" + this.assignee + ", dueDate=" + this.dueDate + ", followUpDate=" + this.followUpDate + ", candidateGroups=" + this.candidateGroups + ", candidateUsers=" + this.candidateUsers + ", priority=" + this.priority + "}";
    }

    public static ImmutableJobResultCorrectionsValue copyOf(JobRecordValue.JobResultCorrectionsValue instance) {
        if (instance instanceof ImmutableJobResultCorrectionsValue) {
            return (ImmutableJobResultCorrectionsValue)instance;
        }
        return ImmutableJobResultCorrectionsValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @ImmutableProtocol.Builder
    @Generated(from="JobRecordValue.JobResultCorrectionsValue", generator="Immutables")
    public static final class Builder {
        private String assignee;
        private String dueDate;
        private String followUpDate;
        private List<String> candidateGroups = new ArrayList<String>();
        private List<String> candidateUsers = new ArrayList<String>();
        private int priority;

        private Builder() {
        }

        public final Builder from(JobRecordValue.JobResultCorrectionsValue instance) {
            String followUpDateValue;
            String dueDateValue;
            Objects.requireNonNull(instance, "instance");
            String assigneeValue = instance.getAssignee();
            if (assigneeValue != null) {
                this.withAssignee(assigneeValue);
            }
            if ((dueDateValue = instance.getDueDate()) != null) {
                this.withDueDate(dueDateValue);
            }
            if ((followUpDateValue = instance.getFollowUpDate()) != null) {
                this.withFollowUpDate(followUpDateValue);
            }
            this.addAllCandidateGroups(instance.getCandidateGroups());
            this.addAllCandidateUsers(instance.getCandidateUsers());
            this.withPriority(instance.getPriority());
            return this;
        }

        public final Builder withAssignee(String assignee) {
            this.assignee = assignee;
            return this;
        }

        public final Builder withDueDate(String dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        public final Builder withFollowUpDate(String followUpDate) {
            this.followUpDate = followUpDate;
            return this;
        }

        public final Builder addCandidateGroup(String element) {
            this.candidateGroups.add(element);
            return this;
        }

        public final Builder addCandidateGroups(String ... elements) {
            for (String element : elements) {
                this.candidateGroups.add(element);
            }
            return this;
        }

        public final Builder withCandidateGroups(Iterable<String> elements) {
            this.candidateGroups.clear();
            return this.addAllCandidateGroups(elements);
        }

        public final Builder addAllCandidateGroups(Iterable<String> elements) {
            for (String element : elements) {
                this.candidateGroups.add(element);
            }
            return this;
        }

        public final Builder addCandidateUser(String element) {
            this.candidateUsers.add(element);
            return this;
        }

        public final Builder addCandidateUsers(String ... elements) {
            for (String element : elements) {
                this.candidateUsers.add(element);
            }
            return this;
        }

        public final Builder withCandidateUsers(Iterable<String> elements) {
            this.candidateUsers.clear();
            return this.addAllCandidateUsers(elements);
        }

        public final Builder addAllCandidateUsers(Iterable<String> elements) {
            for (String element : elements) {
                this.candidateUsers.add(element);
            }
            return this;
        }

        public final Builder withPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder clear() {
            this.assignee = null;
            this.dueDate = null;
            this.followUpDate = null;
            this.candidateGroups.clear();
            this.candidateUsers.clear();
            this.priority = 0;
            return this;
        }

        public ImmutableJobResultCorrectionsValue build() {
            return new ImmutableJobResultCorrectionsValue(this.assignee, this.dueDate, this.followUpDate, ImmutableJobResultCorrectionsValue.createUnmodifiableList(true, this.candidateGroups), ImmutableJobResultCorrectionsValue.createUnmodifiableList(true, this.candidateUsers), this.priority);
        }
    }
}

