/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.value.EntityType;
import io.camunda.zeebe.protocol.record.value.TenantRecordValue;
import java.util.Objects;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="TenantRecordValue", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableTenantRecordValue
implements TenantRecordValue {
    private final long tenantKey;
    private final String tenantId;
    private final String name;
    private final long entityKey;
    private final EntityType entityType;
    private transient int hashCode;

    private ImmutableTenantRecordValue(long tenantKey, String tenantId, String name, long entityKey, EntityType entityType) {
        this.tenantKey = tenantKey;
        this.tenantId = tenantId;
        this.name = name;
        this.entityKey = entityKey;
        this.entityType = entityType;
    }

    @Override
    public long getTenantKey() {
        return this.tenantKey;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getEntityKey() {
        return this.entityKey;
    }

    @Override
    public EntityType getEntityType() {
        return this.entityType;
    }

    public final ImmutableTenantRecordValue withTenantKey(long value) {
        if (this.tenantKey == value) {
            return this;
        }
        return new ImmutableTenantRecordValue(value, this.tenantId, this.name, this.entityKey, this.entityType);
    }

    public final ImmutableTenantRecordValue withTenantId(String value) {
        if (Objects.equals(this.tenantId, value)) {
            return this;
        }
        return new ImmutableTenantRecordValue(this.tenantKey, value, this.name, this.entityKey, this.entityType);
    }

    public final ImmutableTenantRecordValue withName(String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableTenantRecordValue(this.tenantKey, this.tenantId, value, this.entityKey, this.entityType);
    }

    public final ImmutableTenantRecordValue withEntityKey(long value) {
        if (this.entityKey == value) {
            return this;
        }
        return new ImmutableTenantRecordValue(this.tenantKey, this.tenantId, this.name, value, this.entityType);
    }

    public final ImmutableTenantRecordValue withEntityType(EntityType value) {
        if (this.entityType == value) {
            return this;
        }
        return new ImmutableTenantRecordValue(this.tenantKey, this.tenantId, this.name, this.entityKey, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTenantRecordValue && this.equalTo(0, (ImmutableTenantRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableTenantRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.tenantKey == another.tenantKey && Objects.equals(this.tenantId, another.tenantId) && Objects.equals(this.name, another.name) && this.entityKey == another.entityKey && Objects.equals((Object)this.entityType, (Object)another.entityType);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.tenantKey);
        h += (h << 5) + Objects.hashCode(this.tenantId);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Long.hashCode(this.entityKey);
        h += (h << 5) + Objects.hashCode((Object)this.entityType);
        return h;
    }

    public String toString() {
        return "TenantRecordValue{tenantKey=" + this.tenantKey + ", tenantId=" + this.tenantId + ", name=" + this.name + ", entityKey=" + this.entityKey + ", entityType=" + (Object)((Object)this.entityType) + "}";
    }

    public static ImmutableTenantRecordValue copyOf(TenantRecordValue instance) {
        if (instance instanceof ImmutableTenantRecordValue) {
            return (ImmutableTenantRecordValue)instance;
        }
        return ImmutableTenantRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ImmutableProtocol.Builder
    @Generated(from="TenantRecordValue", generator="Immutables")
    public static final class Builder {
        private long tenantKey;
        private String tenantId;
        private String name;
        private long entityKey;
        private EntityType entityType;

        private Builder() {
        }

        public final Builder from(TenantRecordValue instance) {
            String nameValue;
            Objects.requireNonNull(instance, "instance");
            this.withTenantKey(instance.getTenantKey());
            String tenantIdValue = instance.getTenantId();
            if (tenantIdValue != null) {
                this.withTenantId(tenantIdValue);
            }
            if ((nameValue = instance.getName()) != null) {
                this.withName(nameValue);
            }
            this.withEntityKey(instance.getEntityKey());
            EntityType entityTypeValue = instance.getEntityType();
            if (entityTypeValue != null) {
                this.withEntityType(entityTypeValue);
            }
            return this;
        }

        public final Builder withTenantKey(long tenantKey) {
            this.tenantKey = tenantKey;
            return this;
        }

        public final Builder withTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final Builder withName(String name) {
            this.name = name;
            return this;
        }

        public final Builder withEntityKey(long entityKey) {
            this.entityKey = entityKey;
            return this;
        }

        public final Builder withEntityType(EntityType entityType) {
            this.entityType = entityType;
            return this;
        }

        public Builder clear() {
            this.tenantKey = 0L;
            this.tenantId = null;
            this.name = null;
            this.entityKey = 0L;
            this.entityType = null;
            return this;
        }

        public ImmutableTenantRecordValue build() {
            return new ImmutableTenantRecordValue(this.tenantKey, this.tenantId, this.name, this.entityKey, this.entityType);
        }
    }
}

