/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record;

import io.camunda.zeebe.protocol.record.MessageHeaderDecoder;
import io.camunda.zeebe.protocol.record.MetaAttribute;
import io.camunda.zeebe.protocol.record.ValueType;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class ExecuteCommandRequestDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 20;
    public static final int TEMPLATE_ID = 20;
    public static final int SCHEMA_ID = 0;
    public static final int SCHEMA_VERSION = 5;
    public static final String SEMANTIC_VERSION = "8.7.6";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ExecuteCommandRequestDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 20;
    }

    public int sbeTemplateId() {
        return 20;
    }

    public int sbeSchemaId() {
        return 0;
    }

    public int sbeSchemaVersion() {
        return 5;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public ExecuteCommandRequestDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public ExecuteCommandRequestDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (20 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public ExecuteCommandRequestDecoder sbeRewind() {
        return this.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int partitionIdId() {
        return 1;
    }

    public static int partitionIdSinceVersion() {
        return 0;
    }

    public static int partitionIdEncodingOffset() {
        return 0;
    }

    public static int partitionIdEncodingLength() {
        return 2;
    }

    public static String partitionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int partitionIdNullValue() {
        return 65535;
    }

    public static int partitionIdMinValue() {
        return 0;
    }

    public static int partitionIdMaxValue() {
        return 65534;
    }

    public int partitionId() {
        return this.buffer.getShort(this.offset + 0, BYTE_ORDER) & 0xFFFF;
    }

    public static int keyId() {
        return 4;
    }

    public static int keySinceVersion() {
        return 0;
    }

    public static int keyEncodingOffset() {
        return 2;
    }

    public static int keyEncodingLength() {
        return 8;
    }

    public static String keyMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long keyNullValue() {
        return -1L;
    }

    public static long keyMinValue() {
        return 0L;
    }

    public static long keyMaxValue() {
        return -2L;
    }

    public long key() {
        return this.buffer.getLong(this.offset + 2, BYTE_ORDER);
    }

    public static int valueTypeId() {
        return 5;
    }

    public static int valueTypeSinceVersion() {
        return 0;
    }

    public static int valueTypeEncodingOffset() {
        return 10;
    }

    public static int valueTypeEncodingLength() {
        return 1;
    }

    public static String valueTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short valueTypeRaw() {
        return (short)(this.buffer.getByte(this.offset + 10) & 0xFF);
    }

    public ValueType valueType() {
        return ValueType.get((short)(this.buffer.getByte(this.offset + 10) & 0xFF));
    }

    public static int intentId() {
        return 6;
    }

    public static int intentSinceVersion() {
        return 0;
    }

    public static int intentEncodingOffset() {
        return 11;
    }

    public static int intentEncodingLength() {
        return 1;
    }

    public static String intentMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static short intentNullValue() {
        return 255;
    }

    public static short intentMinValue() {
        return 0;
    }

    public static short intentMaxValue() {
        return 254;
    }

    public short intent() {
        return (short)(this.buffer.getByte(this.offset + 11) & 0xFF);
    }

    public static int operationReferenceId() {
        return 9;
    }

    public static int operationReferenceSinceVersion() {
        return 5;
    }

    public static int operationReferenceEncodingOffset() {
        return 12;
    }

    public static int operationReferenceEncodingLength() {
        return 8;
    }

    public static String operationReferenceMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long operationReferenceNullValue() {
        return -1L;
    }

    public static long operationReferenceMinValue() {
        return 0L;
    }

    public static long operationReferenceMaxValue() {
        return -2L;
    }

    public long operationReference() {
        if (this.parentMessage.actingVersion < 5) {
            return -1L;
        }
        return this.buffer.getLong(this.offset + 12, BYTE_ORDER);
    }

    public static int valueId() {
        return 7;
    }

    public static int valueSinceVersion() {
        return 0;
    }

    public static String valueCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String valueMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int valueHeaderLength() {
        return 4;
    }

    public int valueLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
    }

    public int skipValue() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getValue(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getValue(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapValue(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String value() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public static int authorizationId() {
        return 8;
    }

    public static int authorizationSinceVersion() {
        return 4;
    }

    public static String authorizationCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String authorizationMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int authorizationHeaderLength() {
        return 4;
    }

    public int authorizationLength() {
        if (this.parentMessage.actingVersion < 4) {
            return 0;
        }
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
    }

    public int skipAuthorization() {
        if (this.parentMessage.actingVersion < 4) {
            return 0;
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getAuthorization(MutableDirectBuffer dst, int dstOffset, int length) {
        if (this.parentMessage.actingVersion < 4) {
            return 0;
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getAuthorization(byte[] dst, int dstOffset, int length) {
        if (this.parentMessage.actingVersion < 4) {
            return 0;
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapAuthorization(DirectBuffer wrapBuffer) {
        if (this.parentMessage.actingVersion < 4) {
            wrapBuffer.wrap(this.buffer, this.offset, 0);
            return;
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String authorization() {
        if (this.parentMessage.actingVersion < 4) {
            return "";
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        ExecuteCommandRequestDecoder decoder = new ExecuteCommandRequestDecoder();
        decoder.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[ExecuteCommandRequest](sbeTemplateId=");
        builder.append(20);
        builder.append("|sbeSchemaId=");
        builder.append(0);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 5) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(5);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 20) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(20);
        builder.append("):");
        builder.append("partitionId=");
        builder.append(this.partitionId());
        builder.append('|');
        builder.append("key=");
        builder.append(this.key());
        builder.append('|');
        builder.append("valueType=");
        builder.append((Object)this.valueType());
        builder.append('|');
        builder.append("intent=");
        builder.append(this.intent());
        builder.append('|');
        builder.append("operationReference=");
        builder.append(this.operationReference());
        builder.append('|');
        builder.append("value=");
        builder.append('\'').append(this.value()).append('\'');
        builder.append('|');
        builder.append("authorization=");
        builder.append('\'').append(this.authorization()).append('\'');
        this.limit(originalLimit);
        return builder;
    }

    public ExecuteCommandRequestDecoder sbeSkip() {
        this.sbeRewind();
        this.skipValue();
        this.skipAuthorization();
        return this;
    }
}

