/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.management;

import io.camunda.zeebe.protocol.management.BackupStatusCode;
import io.camunda.zeebe.protocol.management.BackupStatusResponseDecoder;
import io.camunda.zeebe.protocol.management.MessageHeaderEncoder;
import io.camunda.zeebe.protocol.management.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class BackupStatusResponseEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 23;
    public static final int TEMPLATE_ID = 4;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final String SEMANTIC_VERSION = "8.7.7";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final BackupStatusResponseEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 23;
    }

    public int sbeTemplateId() {
        return 4;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public BackupStatusResponseEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 23);
        return this;
    }

    public BackupStatusResponseEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(23).templateId(4).schemaId(1).version(0);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int backupIdId() {
        return 1;
    }

    public static int backupIdSinceVersion() {
        return 0;
    }

    public static int backupIdEncodingOffset() {
        return 0;
    }

    public static int backupIdEncodingLength() {
        return 8;
    }

    public static String backupIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long backupIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long backupIdMinValue() {
        return -9223372036854775807L;
    }

    public static long backupIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public BackupStatusResponseEncoder backupId(long value) {
        this.buffer.putLong(this.offset + 0, value, BYTE_ORDER);
        return this;
    }

    public static int statusId() {
        return 2;
    }

    public static int statusSinceVersion() {
        return 0;
    }

    public static int statusEncodingOffset() {
        return 8;
    }

    public static int statusEncodingLength() {
        return 1;
    }

    public static String statusMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public BackupStatusResponseEncoder status(BackupStatusCode value) {
        this.buffer.putByte(this.offset + 8, (byte)value.value());
        return this;
    }

    public static int partitionIdId() {
        return 3;
    }

    public static int partitionIdSinceVersion() {
        return 0;
    }

    public static int partitionIdEncodingOffset() {
        return 9;
    }

    public static int partitionIdEncodingLength() {
        return 2;
    }

    public static String partitionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int partitionIdNullValue() {
        return 65535;
    }

    public static int partitionIdMinValue() {
        return 0;
    }

    public static int partitionIdMaxValue() {
        return 65534;
    }

    public BackupStatusResponseEncoder partitionId(int value) {
        this.buffer.putShort(this.offset + 9, (short)value, BYTE_ORDER);
        return this;
    }

    public static int brokerIdId() {
        return 4;
    }

    public static int brokerIdSinceVersion() {
        return 0;
    }

    public static int brokerIdEncodingOffset() {
        return 11;
    }

    public static int brokerIdEncodingLength() {
        return 2;
    }

    public static String brokerIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int brokerIdNullValue() {
        return 65535;
    }

    public static int brokerIdMinValue() {
        return 0;
    }

    public static int brokerIdMaxValue() {
        return 65534;
    }

    public BackupStatusResponseEncoder brokerId(int value) {
        this.buffer.putShort(this.offset + 11, (short)value, BYTE_ORDER);
        return this;
    }

    public static int checkpointPositionId() {
        return 5;
    }

    public static int checkpointPositionSinceVersion() {
        return 0;
    }

    public static int checkpointPositionEncodingOffset() {
        return 13;
    }

    public static int checkpointPositionEncodingLength() {
        return 8;
    }

    public static String checkpointPositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long checkpointPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long checkpointPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long checkpointPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public BackupStatusResponseEncoder checkpointPosition(long value) {
        this.buffer.putLong(this.offset + 13, value, BYTE_ORDER);
        return this;
    }

    public static int numberOfPartitionsId() {
        return 6;
    }

    public static int numberOfPartitionsSinceVersion() {
        return 0;
    }

    public static int numberOfPartitionsEncodingOffset() {
        return 21;
    }

    public static int numberOfPartitionsEncodingLength() {
        return 2;
    }

    public static String numberOfPartitionsMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int numberOfPartitionsNullValue() {
        return 65535;
    }

    public static int numberOfPartitionsMinValue() {
        return 0;
    }

    public static int numberOfPartitionsMaxValue() {
        return 65534;
    }

    public BackupStatusResponseEncoder numberOfPartitions(int value) {
        this.buffer.putShort(this.offset + 21, (short)value, BYTE_ORDER);
        return this;
    }

    public static int snapshotIdId() {
        return 7;
    }

    public static String snapshotIdCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String snapshotIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int snapshotIdHeaderLength() {
        return 4;
    }

    public BackupStatusResponseEncoder putSnapshotId(DirectBuffer src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public BackupStatusResponseEncoder putSnapshotId(byte[] src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public BackupStatusResponseEncoder snapshotId(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int failureReasonId() {
        return 8;
    }

    public static String failureReasonCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String failureReasonMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int failureReasonHeaderLength() {
        return 4;
    }

    public BackupStatusResponseEncoder putFailureReason(DirectBuffer src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public BackupStatusResponseEncoder putFailureReason(byte[] src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public BackupStatusResponseEncoder failureReason(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int createdAtId() {
        return 9;
    }

    public static String createdAtCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String createdAtMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int createdAtHeaderLength() {
        return 4;
    }

    public BackupStatusResponseEncoder putCreatedAt(DirectBuffer src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public BackupStatusResponseEncoder putCreatedAt(byte[] src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public BackupStatusResponseEncoder createdAt(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int lastUpdatedId() {
        return 10;
    }

    public static String lastUpdatedCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String lastUpdatedMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int lastUpdatedHeaderLength() {
        return 4;
    }

    public BackupStatusResponseEncoder putLastUpdated(DirectBuffer src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public BackupStatusResponseEncoder putLastUpdated(byte[] src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public BackupStatusResponseEncoder lastUpdated(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int brokerVersionId() {
        return 11;
    }

    public static String brokerVersionCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String brokerVersionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int brokerVersionHeaderLength() {
        return 4;
    }

    public BackupStatusResponseEncoder putBrokerVersion(DirectBuffer src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public BackupStatusResponseEncoder putBrokerVersion(byte[] src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public BackupStatusResponseEncoder brokerVersion(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        BackupStatusResponseDecoder decoder = new BackupStatusResponseDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset, 23, 0);
        return decoder.appendTo(builder);
    }
}

