/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.restore;

import io.atomix.cluster.MemberId;
import io.atomix.raft.partition.RaftPartition;
import io.atomix.raft.partition.RaftPartitionGroup;
import io.camunda.zeebe.backup.api.BackupDescriptor;
import io.camunda.zeebe.backup.api.BackupStore;
import io.camunda.zeebe.broker.partitioning.RaftPartitionGroupFactory;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.restore.PartitionRestoreService;
import io.camunda.zeebe.util.FileUtil;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreManager {
    private static final Logger LOG = LoggerFactory.getLogger(RestoreManager.class);
    private final BrokerCfg configuration;
    private final BackupStore backupStore;

    public RestoreManager(BrokerCfg configuration, BackupStore backupStore) {
        this.configuration = configuration;
        this.backupStore = backupStore;
    }

    public CompletableFuture<Void> restore(long backupId) {
        Path dataDirectory = Path.of(this.configuration.getData().getDirectory(), new String[0]);
        try {
            if (!FileUtil.isEmpty((Path)dataDirectory)) {
                LOG.error("Brokers's data directory {} is not empty. Aborting restore to avoid overwriting data. Please restart with a clean directory.", (Object)dataDirectory);
                return CompletableFuture.failedFuture(new DirectoryNotEmptyException(dataDirectory.toString()));
            }
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(e);
        }
        Set brokerIds = IntStream.range(0, this.configuration.getCluster().getClusterSize()).boxed().collect(Collectors.toSet());
        Set<RaftPartition> partitionToRestore = this.collectPartitions();
        int localBrokerId = this.configuration.getCluster().getNodeId();
        List<Integer> partitionIds = partitionToRestore.stream().map(p -> (Integer)p.id().id()).toList();
        LOG.info("Restoring partitions {}", partitionIds);
        return CompletableFuture.allOf((CompletableFuture[])partitionToRestore.stream().map(partition -> this.restorePartition((RaftPartition)partition, backupId, brokerIds, localBrokerId)).toArray(CompletableFuture[]::new)).exceptionallyComposeAsync(error -> this.logFailureAndDeleteDataDirectory(dataDirectory, (Throwable)error));
    }

    private CompletableFuture<Void> logFailureAndDeleteDataDirectory(Path dataDirectory, Throwable error) {
        LOG.error("Failed to restore broker. Deleting data directory {}", (Object)dataDirectory, (Object)error);
        try {
            FileUtil.deleteFolderContents((Path)dataDirectory);
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(e);
        }
        return CompletableFuture.failedFuture(error);
    }

    private void logSuccessfulRestore(BackupDescriptor backup, int partitionId, long backupId) {
        LOG.info("Successfully restored partition {} from backup {}. Backup description: {}", new Object[]{partitionId, backupId, backup});
    }

    private CompletableFuture<Void> restorePartition(RaftPartition partition, long backupId, Set<Integer> brokerIds, int localBrokerId) {
        return new PartitionRestoreService(this.backupStore, partition, brokerIds, localBrokerId).restore(backupId).thenAccept(backup -> this.logSuccessfulRestore((BackupDescriptor)backup, (Integer)partition.id().id(), backupId));
    }

    private Set<RaftPartition> collectPartitions() {
        RaftPartitionGroupFactory factory = new RaftPartitionGroupFactory();
        RaftPartitionGroup partitionsGroup = factory.buildRaftPartitionGroup(this.configuration, null);
        int localBrokerId = this.configuration.getCluster().getNodeId();
        MemberId localMember = MemberId.from((String)String.valueOf(localBrokerId));
        return partitionsGroup.getPartitions().stream().map(RaftPartition.class::cast).filter(partition -> partition.getMetadata().members().contains(localMember)).collect(Collectors.toSet());
    }
}

