/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.restore;

import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.PartitionMetadata;
import io.atomix.raft.partition.RaftPartition;
import io.camunda.zeebe.backup.api.BackupDescriptor;
import io.camunda.zeebe.backup.api.BackupStatus;
import io.camunda.zeebe.backup.api.BackupStore;
import io.camunda.zeebe.broker.partitioning.startup.RaftPartitionFactory;
import io.camunda.zeebe.broker.partitioning.topology.PartitionDistribution;
import io.camunda.zeebe.broker.partitioning.topology.PartitionDistributionResolver;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ClusterCfg;
import io.camunda.zeebe.broker.system.configuration.PartitioningCfg;
import io.camunda.zeebe.db.impl.rocksdb.ChecksumProviderRocksDBImpl;
import io.camunda.zeebe.restore.PartitionRestoreService;
import io.camunda.zeebe.snapshots.ChecksumProvider;
import io.camunda.zeebe.util.FileUtil;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreManager {
    private static final Logger LOG = LoggerFactory.getLogger(RestoreManager.class);
    private final BrokerCfg configuration;
    private final BackupStore backupStore;
    private final MeterRegistry meterRegistry;

    public RestoreManager(BrokerCfg configuration, BackupStore backupStore, MeterRegistry meterRegistry) {
        this.configuration = configuration;
        this.backupStore = backupStore;
        this.meterRegistry = meterRegistry;
    }

    public CompletableFuture<Void> restore(long backupId, boolean validateConfig) {
        Path dataDirectory = Path.of(this.configuration.getData().getDirectory(), new String[0]);
        try {
            if (!FileUtil.isEmpty((Path)dataDirectory)) {
                LOG.error("Brokers's data directory {} is not empty. Aborting restore to avoid overwriting data. Please restart with a clean directory.", (Object)dataDirectory);
                return CompletableFuture.failedFuture(new DirectoryNotEmptyException(dataDirectory.toString()));
            }
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(e);
        }
        Set<InstrumentedRaftPartition> partitionToRestore = this.collectPartitions();
        List<Integer> partitionIds = partitionToRestore.stream().map(p -> (Integer)p.partition().id().id()).toList();
        LOG.info("Restoring partitions {}", partitionIds);
        return CompletableFuture.allOf((CompletableFuture[])partitionToRestore.stream().map(partition -> this.restorePartition((InstrumentedRaftPartition)partition, backupId, validateConfig)).toArray(CompletableFuture[]::new)).exceptionallyComposeAsync(error -> this.logFailureAndDeleteDataDirectory(dataDirectory, (Throwable)error));
    }

    private CompletableFuture<Void> logFailureAndDeleteDataDirectory(Path dataDirectory, Throwable error) {
        LOG.error("Failed to restore broker. Deleting data directory {}", (Object)dataDirectory, (Object)error);
        try {
            FileUtil.deleteFolderContents((Path)dataDirectory);
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(e);
        }
        return CompletableFuture.failedFuture(error);
    }

    private void logSuccessfulRestore(BackupDescriptor backup, int partitionId, long backupId) {
        LOG.info("Successfully restored partition {} from backup {}. Backup description: {}", new Object[]{partitionId, backupId, backup});
    }

    private CompletableFuture<Void> restorePartition(InstrumentedRaftPartition partition, long backupId, boolean validateConfig) {
        PartitionRestoreService.BackupValidator validator;
        RaftPartition raftPartition = partition.partition();
        if (validateConfig) {
            validator = new ValidatePartitionCount(this.configuration.getCluster().getPartitionsCount());
        } else {
            LOG.warn("Restoring without validating backup");
            validator = PartitionRestoreService.BackupValidator.none();
        }
        CompositeMeterRegistry registry = partition.registry();
        return ((CompletableFuture)new PartitionRestoreService(this.backupStore, raftPartition, (ChecksumProvider)new ChecksumProviderRocksDBImpl(), (MeterRegistry)partition.registry()).restore(backupId, validator).thenAccept(backup -> this.logSuccessfulRestore((BackupDescriptor)backup, (Integer)raftPartition.id().id(), backupId))).whenComplete((ok, error) -> MicrometerUtil.discard((CompositeMeterRegistry)registry));
    }

    private Set<InstrumentedRaftPartition> collectPartitions() {
        int localBrokerId = this.configuration.getCluster().getNodeId();
        MemberId localMember = MemberId.from((String)String.valueOf(localBrokerId));
        PartitionDistribution clusterTopology = new PartitionDistribution(PartitionDistributionResolver.getStaticConfiguration((ClusterCfg)this.configuration.getCluster(), (PartitioningCfg)this.configuration.getExperimental().getPartitioning(), (MemberId)localMember).generatePartitionDistribution());
        RaftPartitionFactory raftPartitionFactory = new RaftPartitionFactory(this.configuration);
        return clusterTopology.partitions().stream().filter(partitionMetadata -> partitionMetadata.members().contains(localMember)).map(metadata -> this.createRaftPartition((PartitionMetadata)metadata, raftPartitionFactory)).collect(Collectors.toSet());
    }

    private InstrumentedRaftPartition createRaftPartition(PartitionMetadata metadata, RaftPartitionFactory factory) {
        Integer partitionId = (Integer)metadata.id().id();
        CompositeMeterRegistry partitionRegistry = MicrometerUtil.wrap((MeterRegistry)this.meterRegistry, (Tags)MicrometerUtil.PartitionKeyNames.tags((int)partitionId));
        return new InstrumentedRaftPartition(factory.createRaftPartition(metadata, (MeterRegistry)partitionRegistry), partitionRegistry);
    }

    private record InstrumentedRaftPartition(RaftPartition partition, CompositeMeterRegistry registry) {
    }

    static final class ValidatePartitionCount
    implements PartitionRestoreService.BackupValidator {
        private final int expectedPartitionCount;

        ValidatePartitionCount(int expectedPartitionCount) {
            this.expectedPartitionCount = expectedPartitionCount;
        }

        @Override
        public BackupStatus validateStatus(BackupStatus status) throws PartitionRestoreService.BackupValidator.BackupNotValidException {
            BackupDescriptor descriptor = (BackupDescriptor)status.descriptor().orElseThrow(() -> new PartitionRestoreService.BackupValidator.BackupNotValidException(status, "Backup does not have a descriptor"));
            if (descriptor.numberOfPartitions() != this.expectedPartitionCount) {
                throw new PartitionRestoreService.BackupValidator.BackupNotValidException(status, "Expected backup to have %d partitions, but has %d".formatted(this.expectedPartitionCount, descriptor.numberOfPartitions()));
            }
            return status;
        }
    }
}

